#ifndef _MATHPARSER_HEADER_H
#define _MATHPARSER_HEADER_H

#include<ctype.h>
#include<iostream.h>
#include<math.h>

// Parser contants
#define PAR_BSIZE  128
#define PAR_NSIZE  128
#define PAR_SYMMAX 100
#define PAR_NONE   -1
#define PAR_EOS    '\0'
#define PAR_STRMAX 100

// Function identifiers
#define PAR_NUM    256
#define PAR_DIV    257
#define PAR_ID     259
#define PAR_TN     260
#define PAR_SN     261
#define PAR_CS     262
#define PAR_ATN    263
#define PAR_ASN    264
#define PAR_ACS    265
#define PAR_LN     266
#define PAR_EX     267
#define PAR_QR     268
#define PAR_PW     269
#define PAR_R2D    270
#define PAR_MOD    271
#define PAR_PI     272
#define PAR_DONE   301
#define PAR_FALSE  0
#define PAR_TRUE   1

// Error codes and string
#define PAR_ERR_SUCCESS 0
#define PAR_ERR_FLTERR  1
#define PAR_ERR_INCPEXP 2
#define PAR_ERR_UNKIDNT 3
#define PAR_ERR_COMPILE 4
#define PAR_ERR_SYNFACT 5

extern const char* ErrorStr[];

// Class definitions
class entry 
{
    private:
        char*  lexptr;
        int    token;
        entry* ptr;

    public:                        
        entry()
        {
            lexptr=NULL;
        };

        entry(char*,int);


        ~entry();

        friend class parser;
};
 
class parser
{
    public:        
        int     parseErrorCode;
        char*   pExpStr;
        int     expStrIdx;
        int     expStrLen;

        parser ();
        ~parser();

        // returns :
        // 0 : success.
        int  analyser(char* pStr, double* pRTNValue);

    private:
        int lexan   (void);
        int is_float(int);
        int lookup  (char *);

        int expr  (double*);
        int term  (double*);
        int power (double*);
        int factor(double*);
        int match (int t);

        // ------------------------------

        int     lookahead;
        double  fnumber;
        entry*  symtable;
        char*   lexbuf;
        char*   numbuf;
        int     exp_flag;
        int     lastentry;
        int     lineno;
}; 

#endif

 
