// options.h : header file for Options tabbed dialog box
//

// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

#include "Partition.h"

/////////////////////////////////////////////////////////////////////////////
// CGeneralPage dialog

class CGeneralPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CGeneralPage)

// Construction
public:
	CGeneralPage();
	~CGeneralPage();

// Dialog Data
	//{{AFX_DATA(CGeneralPage)
	enum { IDD = IDD_OPT_SYSTEM };
	BOOL	backup_;
	BOOL	save_exit_;
	BOOL	one_only_;
	BOOL	shell_open_;
	BOOL	bg_search_;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CGeneralPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CGeneralPage)
	afx_msg void OnSaveNow();
	afx_msg void OnChange();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnShellopen();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CDefaultsPage dialog

class CDefaultsPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CDefaultsPage)

// Construction
public:
	CDefaultsPage();
	~CDefaultsPage();

// Dialog Data
	//{{AFX_DATA(CDefaultsPage)
	enum { IDD = IDD_OPT_DEFDISPLAY };
	BOOL	open_autofit_;
	BOOL	open_display_char_;
	BOOL	open_control_;
	BOOL	open_ebcdic_;
	BOOL	open_graphic_;
	BOOL	open_dec_addr_;
	int		open_insert_;
	int		open_allow_mods_;
	BOOL	open_max_;
	BOOL	open_oem_;
	//}}AFX_DATA

    LOGFONT *open_plf_;                 // Pointer to default font or NULL if none
    LOGFONT *open_oem_plf_;             // Pointer to default OEM font or NULL if none

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CDefaultsPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CDefaultsPage)
	afx_msg void OnChange();
	afx_msg void OnChangedDisplayChar();
	afx_msg void OnChangeEbcdic();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	virtual BOOL OnInitDialog();
	afx_msg void OnOpenFont();
	afx_msg void OnChangeGraphic();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CDisplayPage dialog

class CDisplayPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CDisplayPage)

// Construction
public:
	CDisplayPage();
	~CDisplayPage();

// Dialog Data
	//{{AFX_DATA(CDisplayPage)
	enum { IDD = IDD_OPT_WINDOW };
	BOOL	autofit_;
	BOOL	char_;
	UINT	cols_;
	UINT	grouping_;
	UINT	offset_;
	//}}AFX_DATA
        CString window_name_;

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CDisplayPage)
	public:
	virtual void OnOK();
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	virtual void OnCancel();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CDisplayPage)
	afx_msg void OnAutoFit();
	afx_msg void OnChange();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnChangeCols();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	bool update_ok_;
};

/////////////////////////////////////////////////////////////////////////////
// COptSheet

class COptSheet : public CPropertySheet
{
	DECLARE_DYNAMIC(COptSheet)

// Construction
public:
	COptSheet(UINT nIDCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);
	COptSheet(LPCTSTR pszCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COptSheet)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~COptSheet();

	// Generated message map functions
protected:
	//{{AFX_MSG(COptSheet)
	afx_msg BOOL OnNcCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CMacroPage dialog

class CMacroPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CMacroPage)

// Construction
public:
	CMacroPage();
	~CMacroPage();

// Dialog Data
	//{{AFX_DATA(CMacroPage)
	enum { IDD = IDD_OPT_MACRO };
	long	num_keys_;
	long	num_plays_;
	long	num_secs_;
	int		refresh_;
	BOOL	refresh_bars_;
	BOOL	refresh_props_;
	int		halt_level_;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CMacroPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CMacroPage)
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnChange();
	afx_msg void OnRefreshNever();
	afx_msg void OnRefreshPlays();
	afx_msg void OnRefreshSecs();
	afx_msg void OnRefreshKeys();
	virtual BOOL OnInitDialog();
	afx_msg void OnSavemacro();
	afx_msg void OnLoadmacro();
	afx_msg void OnMacrodir();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CColourList drop list box

class CColourList : public CComboBox
{
// Construction
public:
	CColourList();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CColourList)
	public:
	virtual int CompareItem(LPCOMPAREITEMSTRUCT lpCompareItemStruct);
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	virtual void MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CColourList();

	// Generated message map functions
protected:
	//{{AFX_MSG(CColourList)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CPartitionsPage dialog

class CPartitionsPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CPartitionsPage)

// Construction
public:
	CPartitionsPage();
	~CPartitionsPage();

// Dialog Data
	//{{AFX_DATA(CPartitionsPage)
	enum { IDD = IDD_OPT_PARTITIONS };
		// NOTE - ClassWizard will add data members here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_DATA
	std::vector<partn> partitions_;

// Controls
        CColourList list_colours_;
        CBitmapButton bb_up_, bb_down_;         // Up/down controls (IDC_UP, IDC_DOWN)

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPartitionsPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CPartitionsPage)
	afx_msg void OnAdd();
	afx_msg void OnRemove();
	afx_msg void OnReset();
	virtual BOOL OnInitDialog();
	afx_msg void OnChangeCurrent();
	afx_msg void OnSelchangeNames();
	afx_msg void OnChangeRanges();
	afx_msg void OnSelendokColour();
	afx_msg void OnSaveAsDefault();
	afx_msg void OnDown();
	afx_msg void OnUp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
        bool change_range_;             // Is change to range not done by user?
        void check_buttons();           // Enable up/down/remove buttons as approp.
};
/////////////////////////////////////////////////////////////////////////////
// CSysDisplayPage dialog

class CSysDisplayPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CSysDisplayPage)

// Construction
public:
	CSysDisplayPage();
	~CSysDisplayPage();

// Dialog Data
	//{{AFX_DATA(CSysDisplayPage)
	enum { IDD = IDD_OPT_SYSDISPLAY };
	BOOL	large_cursor_;
	BOOL	hex_ucase_;
	BOOL	nice_addr_;
	BOOL	open_restore_;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CSysDisplayPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CSysDisplayPage)
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnChange();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
