// Prop.h : header file for Properties tabbed dialog box
//

// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

#include <afxdisp.h>

/////////////////////////////////////////////////////////////////////////////
// CPropUpdatePage

// CPropUpdatePage is used as the base class for all property pages used
// in the "Properties" property sheet CPropSheet.  It is provided simply
// so that we can use the virtual function "Update" with a pointer
// obtained with GetActivePage() without regard to the particular derived
// class of the currently active page.

class CHexEditView;
class CPropUpdatePage : public CPropertyPage
{
protected:
    CPropUpdatePage(int id) : CPropertyPage(id) { }
    DECLARE_DYNAMIC(CPropUpdatePage)
public:
    virtual void Update(CHexEditView *pv = NULL, long address = -1) =0;
};

/////////////////////////////////////////////////////////////////////////////
// CPropFilePage dialog

class CPropFilePage : public CPropUpdatePage
{
	DECLARE_DYNCREATE(CPropFilePage)

// Construction
public:
	CPropFilePage();
	~CPropFilePage();

// Dialog Data
	//{{AFX_DATA(CPropFilePage)
	enum { IDD = IDD_PROP_FILE };
	CString	file_name_;
	CString	file_path_;
	CString	file_size_;
	int		file_hidden_;
	int		file_readonly_;
	int		file_system_;
	CString	file_type_;
	CString	file_modified_;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropFilePage)
	public:
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
	virtual void Update(CHexEditView *pv = NULL, long address = -1);

protected:
	// Generated message map functions
	//{{AFX_MSG(CPropFilePage)
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
    const char *get_type();
};

/////////////////////////////////////////////////////////////////////////////
// CPropCharPage dialog

class CPropCharPage : public CPropUpdatePage
{
	DECLARE_DYNCREATE(CPropCharPage)

// Construction
public:
	CPropCharPage();
	~CPropCharPage();

// Dialog Data
	//{{AFX_DATA(CPropCharPage)
	enum { IDD = IDD_PROP_CHAR };
	CString	char_ascii_;
	CString	char_binary_;
	CString	char_ebcdic_;
	CString	char_hex_;
	CString	char_octal_;
	CString	char_dec_;
	//}}AFX_DATA
	wchar_t char_unicode_[8];

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropCharPage)
	public:
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
	virtual void Update(CHexEditView *pv = NULL, long address = -1);

protected:
	// Generated message map functions
	//{{AFX_MSG(CPropCharPage)
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CPropDecPage dialog

class CPropDecPage : public CPropUpdatePage
{
	DECLARE_DYNCREATE(CPropDecPage)

// Construction
public:
	CPropDecPage();
	~CPropDecPage();

// Dialog Data
	//{{AFX_DATA(CPropDecPage)
	enum { IDD = IDD_PROP_DECIMAL };
	CString	dec_64bit_;
	CString	dec_16bit_;
	CString	dec_32bit_;
	CString	dec_8bit_;
	int		signed_;
	BOOL	big_endian_;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropDecPage)
	public:
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
	virtual void Update(CHexEditView *pv = NULL, long address = -1);

protected:
	// Generated message map functions
	//{{AFX_MSG(CPropDecPage)
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnChangeFormat();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CPropFloatPage dialog

class CPropFloatPage : public CPropUpdatePage
{
	DECLARE_DYNCREATE(CPropFloatPage)

// Construction
public:
	CPropFloatPage();
	~CPropFloatPage();

// Dialog Data
	//{{AFX_DATA(CPropFloatPage)
	enum { IDD = IDD_PROP_FLOAT };
	CString	exp_;
	CString	mant_;
	CString	val_;
	int		format_;
	BOOL	big_endian_;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropFloatPage)
	public:
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
	virtual void Update(CHexEditView *pv = NULL, long address = -1);

protected:
	// Generated message map functions
	//{{AFX_MSG(CPropFloatPage)
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnChangeFormat();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CPropIBMFloatPage dialog

class CPropIBMFloatPage : public CPropUpdatePage
{
	DECLARE_DYNCREATE(CPropIBMFloatPage)

// Construction
public:
	CPropIBMFloatPage();
	~CPropIBMFloatPage();

// Dialog Data
	//{{AFX_DATA(CPropIBMFloatPage)
	enum { IDD = IDD_PROP_IBMFP };
	BOOL	big_endian_;
	CString	exp_;
	CString	mant_;
	CString	val_;
	int		format_;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropIBMFloatPage)
	public:
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
	virtual void Update(CHexEditView *pv = NULL, long address = -1);

protected:
	// Generated message map functions
	//{{AFX_MSG(CPropIBMFloatPage)
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnChangeFormat();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
long double ibm_fp32(const unsigned char *pp, int *pexp = NULL,
		     long double *pmant = NULL, bool little_endian = false);
long double ibm_fp64(const unsigned char *pp, int *pexp = NULL,
		     long double *pmant = NULL, bool little_endian = false);
};

/////////////////////////////////////////////////////////////////////////////
// CPropSheet

class CPropSheet : public CPropertySheet
{
	DECLARE_DYNAMIC(CPropSheet)

// Construction
public:
	CPropSheet(UINT iSelectPage = 0, CHexEditView *pv = NULL);

// Attributes
public:

// Operations
public:
    void Update(CHexEditView *pv = NULL, long address = -1); // Update active page

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPropSheet)
	protected:
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPropSheet();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPropSheet)
	afx_msg void OnDestroy();
	afx_msg BOOL OnNcCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:
    CPropFilePage     prop_file;
    CPropCharPage     prop_char;
    CPropDecPage      prop_dec;
    CPropFloatPage    prop_float;
    CPropIBMFloatPage prop_ibmfp;
};

/////////////////////////////////////////////////////////////////////////////
