/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dialog;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class GCProblem
extends GProblem {
    public static final String DEFAULT_NAME = "Untitled";
    public static String shapeDir;
    public static String customShapeDir;
    protected static TextArea hypothesisView;

    public GCProblem(GCFrame gCFrame, GCMenuBar gCMenuBar, TextArea textArea, GCalculator gCalculator, GNotepad gNotepad) {
        super(gCFrame, gCMenuBar, gCalculator, gNotepad);
        hypothesisView = textArea;
        GProblem.name = DEFAULT_NAME;
        char c = File.separatorChar;
        shapeDir = "shapes" + c + "predef";
        customShapeDir = "shapes" + c + "custom";
        this.flush();
    }

    public void flush() {
        GProblem.saved = false;
        GProblem.modified = false;
        this.newSolidCount = 0;
        GProblem.solidWndInset = 0;
        this.solidWndList.flush();
        GProblem.menuBar.initWindowMenu();
        this.newSolid(null);
        this.hypothesis = "";
        this.answer = new GAnswer();
        this.randomized = true;
        this.year = "";
        this.author = "";
        this.authorEmail = "";
        this.authorWeb = "";
        this.comments = "";
        this.lineAvail = true;
        this.perpAvail = true;
        this.midpointAvail = true;
        this.bisectorAvail = true;
        this.layDistAvail = true;
        this.layAngleAvail = true;
        this.cutAvail = true;
    }

    public boolean onSolidWindowClose(GSolidWindow gSolidWindow) {
        return true;
    }

    public boolean logAlert(String string) {
        return false;
    }

    public void init() {
        this.unfoldSolidWnds(true);
        GProblem.saved = true;
        GProblem.modified = false;
    }

    public boolean onClose() {
        return true;
    }

    protected boolean save() {
        return true;
    }

    protected boolean saveAs() {
        return true;
    }

    public boolean onSave() {
        GYNPromptDialog gYNPromptDialog = new GYNPromptDialog(GProblem.frame, "Validate " + GProblem.name + " before saving?");
        if (gYNPromptDialog.result == 3) {
            this.validated = false;
            return true;
        }
        return this.validate();
    }

    protected boolean validate() {
        Object object;
        String string = "Cannot validate " + GProblem.name + ": ";
        String string2 = hypothesisView.getText().trim();
        if (string2.length() == 0) {
            new GAlertDialog(GProblem.frame, "warn.gif", "No Hypothesis", String.valueOf(string) + "no hypothesis");
            return false;
        }
        if (string2.indexOf(60) >= 0 || string2.indexOf(62) >= 0) {
            new GAlertDialog(GProblem.frame, "warn.gif", "Formatting Error", "Hypothesis cannot contain symbol &lt; nor &gt;");
            return false;
        }
        if (this.solidWndList.getDim() == 0) {
            new GAlertDialog(GProblem.frame, "warn.gif", "No Solid", String.valueOf(string) + "contains no solid window");
            return false;
        }
        boolean bl = false;
        GSolidWndNode gSolidWndNode = this.solidWndList.getHead();
        while (gSolidWndNode != null) {
            object = gSolidWndNode.getWindow();
            if (!gSolidWndNode.getSolid().isRipe()) {
                new GAlertDialog(GProblem.frame, "warn.gif", "Unformed Solid", String.valueOf(string) + ((Dialog)object).getTitle() + " not formed yet");
                return false;
            }
            bl = bl || !((GSolidWindow)object).getSolid().hasInitAttitude();
            gSolidWndNode = gSolidWndNode.getNext();
        }
        object = this.answer.validate(this);
        if (object != null) {
            new GAlertDialog(GProblem.frame, "warn.gif", "Error In Answer", String.valueOf(string) + (String)object);
            new GCAnswerDialog(GProblem.frame, this, this.answer, this.notepad);
            return false;
        }
        if (bl) {
            GYNCPromptDialog gYNCPromptDialog = new GYNCPromptDialog(GProblem.frame, "Some solids appear to have been revolved. Save current attitudes as initial?");
            if (gYNCPromptDialog.result == 1) {
                return false;
            }
            if (gYNCPromptDialog.result == 2) {
                gSolidWndNode = this.solidWndList.getHead();
                while (gSolidWndNode != null) {
                    gSolidWndNode.getSolid().setAttAsInitial();
                    gSolidWndNode = gSolidWndNode.getNext();
                }
            }
        }
        this.validated = true;
        return true;
    }

    public void setHypothesis() {
        String string = hypothesisView.getText().trim();
        if (this.hypothesis.equals(string)) {
            return;
        }
        this.hypothesis = string;
        GProblem.modified = true;
    }

    public void setAnswer() {
        GCAnswerDialog gCAnswerDialog = new GCAnswerDialog(GProblem.frame, this, this.answer, this.notepad);
        if (gCAnswerDialog.result == 0) {
            GProblem.modified = true;
        }
    }

    public void setRandomization() {
        boolean bl;
        GRandomizeDialog gRandomizeDialog = new GRandomizeDialog(GProblem.frame, this);
        if (gRandomizeDialog.result == 0 && (bl = gRandomizeDialog.getField()) != this.randomized) {
            GProblem.modified = true;
            this.randomized = bl;
        }
    }

    public void setToolsAvail() {
        GToolsAvailDialog gToolsAvailDialog = new GToolsAvailDialog(GProblem.frame, this);
        if (gToolsAvailDialog.result == 0) {
            boolean[] blArray = gToolsAvailDialog.getFields();
            this.lineAvail = blArray[0];
            this.perpAvail = blArray[1];
            this.midpointAvail = blArray[2];
            this.bisectorAvail = blArray[3];
            this.layDistAvail = blArray[4];
            this.layAngleAvail = blArray[5];
            this.cutAvail = blArray[6];
            GProblem.modified = true;
        }
    }

    public void setComments() {
        GCommentsDialog gCommentsDialog = new GCommentsDialog(GProblem.frame, this);
        if (gCommentsDialog.result == 0) {
            String string = gCommentsDialog.getField();
            if (this.comments.equals(string)) {
                return;
            }
            this.comments = string;
            GProblem.modified = true;
        }
    }

    public void setCopyright() {
        GCopyrightDialog gCopyrightDialog = new GCopyrightDialog(GProblem.frame, this.year, this.author, this.authorEmail, this.authorWeb);
        if (gCopyrightDialog.result == 0) {
            String string = gCopyrightDialog.getFields()[0];
            String string2 = gCopyrightDialog.getFields()[1];
            String string3 = gCopyrightDialog.getFields()[2];
            String string4 = gCopyrightDialog.getFields()[3];
            if (this.year.equals(string) && this.author.equals(string2) && string3.equals(this.authorEmail) && string4.equals(this.authorWeb)) {
                return;
            }
            this.year = string;
            this.author = string2;
            this.authorEmail = string3;
            this.authorWeb = string4;
            GProblem.modified = true;
        }
    }

    public GSolid newSolid(GShape gShape) {
        String string = String.valueOf(++this.newSolidCount);
        GSolid gSolid = new GSolid(GProblem.frame, this, gShape, string);
        GSolidWindow gSolidWindow = new GSolidWindow(GProblem.frame, this, gSolid, -1.0, GProblem.solidWndInset, GProblem.windowsMaximized, true);
        this.solidWndList.addToTail(gSolidWindow);
        GProblem.solidWndInset = (GProblem.solidWndInset + 10) % (GSolidWindow.getInitSize() / 2);
        if (gShape != null) {
            gSolidWindow.updateContent(null);
            this.updateLabelBag();
            GProblem.modified = true;
        }
        GProblem.menuBar.update(this, gSolidWindow);
        GProblem.menuBar.addWindowMenuItem(this, "Solid " + gSolid.getLabel());
        return gSolid;
    }

    public void renumberSolids() {
        GSolidWndNode gSolidWndNode = this.solidWndList.getHead();
        this.newSolidCount = 0;
        while (gSolidWndNode != null) {
            GSolidWindow gSolidWindow = gSolidWndNode.getWindow();
            GSolid gSolid = gSolidWindow.getSolid();
            String string = String.valueOf(++this.newSolidCount);
            gSolid.setLabel(string);
            String string2 = gSolidWindow.getTitle();
            gSolidWindow.setTitle("Solid " + string);
            if (string2.equals(this.answer.getSolidName())) {
                this.answer.setSolidName(gSolidWindow.getTitle());
            }
            GProblem.menuBar.addWindowMenuItem(this, "Solid " + string);
            gSolidWndNode = gSolidWndNode.getNext();
        }
        this.cascadeSolidWnds();
        GProblem.modified = true;
    }

    public void saveShape(GSolidWindow gSolidWindow) {
        if (gSolidWindow == null) {
            new GAlertDialog(GProblem.frame, "warn.gif", "No shape", "Nothing to save");
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        if (!gSolid.isRipe()) {
            new GAlertDialog(GProblem.frame, "warn.gif", "GEOMETRIA", "Solid " + gSolid.getLabel() + " not formed yet");
            return;
        }
        GSaveShapeDialog gSaveShapeDialog = new GSaveShapeDialog(GProblem.frame, customShapeDir);
        if (gSaveShapeDialog.result != 0) {
            return;
        }
        String string = gSaveShapeDialog.getShapeName();
        try {
            File file = new File(customShapeDir, string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(gSolid.toShape());
            objectOutputStream.flush();
            return;
        }
        catch (IOException iOException) {
            new GAlertDialog(GProblem.frame, "warn.gif", "GEOMETRIA", "Custom shapes directory corrupted");
            return;
        }
    }

    public void openShape(GSolidWindow gSolidWindow, String string, String string2) {
        try {
            File file = new File(string, string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            GShape gShape = (GShape)objectInputStream.readObject();
            if (gSolidWindow != null && gSolidWindow.getSolid().vertexList.getDim() == 0) {
                this.solidWndList.replace(gSolidWindow.getSolid(), new GSolid(GProblem.frame, this, gShape, gSolidWindow.getSolid().getLabel()));
                GProblem.menuBar.update(this, gSolidWindow);
                this.updateLabelBag();
                GProblem.modified = true;
                gSolidWindow.toFront();
                gSolidWindow.getCanvas().requestFocus();
                return;
            }
            this.newSolid(gShape);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException.toString());
            return;
        }
        catch (IOException iOException) {
            new GAlertDialog(GProblem.frame, "warn.gif", "GEOMETRIA Warning", "Shape file " + string2.toUpperCase() + " corrupted");
            return;
        }
    }

    protected void openShape(GSolidWindow gSolidWindow) {
        GOpenShapeDialog gOpenShapeDialog = new GOpenShapeDialog(GProblem.frame, customShapeDir);
        if (gOpenShapeDialog.result == 0) {
            this.openShape(gSolidWindow, customShapeDir, gOpenShapeDialog.getShapeName());
        }
    }

    public void addVertex(GSolidWindow gSolidWindow, GPoint3D gPoint3D) {
        GSolid gSolid = gSolidWindow.getSolid();
        GAddVertexDialog gAddVertexDialog = new GAddVertexDialog(GProblem.frame, this, this.notepad, gSolid, gPoint3D);
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.clearSelections();
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
        if (gAddVertexDialog.result == 0) {
            gSolidWindow.updateContent(null);
            GProblem.menuBar.update(this, gSolidWindow);
            this.updateLabelBag();
            this.notepad.update(gSolid, gSolid, true);
            GProblem.modified = true;
        }
    }

    public void undo(GSolidWindow gSolidWindow, int n) {
        GSolid gSolid = gSolidWindow.getSolid();
        GSolid gSolid2 = n == 0 ? gSolid.getTransformBak() : gSolid.getAddVertexBak();
        gSolid2.setLabel(gSolid.getLabel());
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.setRevolved(false);
        this.solidWndList.replace(gSolid, gSolid2);
        this.updateLabelBag();
        this.notepad.update(gSolid, gSolid2, true);
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
        GProblem.modified = true;
    }

    protected void stretchSolid(GSolidWindow gSolidWindow) {
        GSolid gSolid = gSolidWindow.getSolid();
        GStretchDialog gStretchDialog = new GStretchDialog(GProblem.frame, gSolidWindow.getTitle());
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.clearSelections();
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
        if (gStretchDialog.result == 0) {
            gSolid.stretch(gStretchDialog.getRatios());
            gSolidWindow.updateContent(null);
            GProblem.menuBar.update(this, gSolidWindow);
            this.notepad.update(gSolid, gSolid, true);
            GProblem.modified = true;
        }
    }

    protected void skewSolid(GSolidWindow gSolidWindow) {
        GSolid gSolid = gSolidWindow.getSolid();
        GSkewDialog gSkewDialog = new GSkewDialog(GProblem.frame, gSolidWindow.getTitle());
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.clearSelections();
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
        if (gSkewDialog.result == 0) {
            gSolid.skew(gSkewDialog.getAngles());
            gSolidWindow.updateContent(null);
            GProblem.menuBar.update(this, gSolidWindow);
            this.notepad.update(gSolid, gSolid, true);
            GProblem.modified = true;
        }
    }

    protected void switchXYGrid() {
        GSolidWindow gSolidWindow = this.solidWndList.getTop().getWindow();
        boolean bl = ((GCMenuBar)GProblem.menuBar).xyGridMenuItem.getState();
        gSolidWindow.getXYGrid().setVisible(bl);
        if (bl) {
            gSolidWindow.getSolid().setViewMode(0);
        }
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.clearSelections();
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
    }

    protected void facetArea(GSolidWindow gSolidWindow) {
        GSolid gSolid = gSolidWindow.getSolid();
        GFacetAreaDialog gFacetAreaDialog = new GFacetAreaDialog(GProblem.frame, this.notepad, gSolid);
        gSolid.clearSelection(true, true, true);
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.repaint();
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
        if (gFacetAreaDialog.result == 0) {
            GProblem.modified = true;
        }
    }

    protected void volume(GSolidWindow gSolidWindow) {
        GSolid gSolid = gSolidWindow.getSolid();
        new GVolumeDialog(GProblem.frame, this.notepad, gSolid);
        gSolid.clearSelection(true, true, true);
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.repaint();
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
        GProblem.modified = true;
    }

    public void join() {
        GJoinDialog gJoinDialog = new GJoinDialog(GProblem.frame, this.solidWndList);
        if (gJoinDialog.result == 0) {
            GSolid gSolid = gJoinDialog.getJointSolid();
            String string = String.valueOf(++this.newSolidCount);
            gSolid.setLabel(string);
            GSolidWindow gSolidWindow = new GSolidWindow(GProblem.frame, this, gSolid, -1.0, GProblem.solidWndInset, GProblem.windowsMaximized, true);
            this.solidWndList.addToTail(gSolidWindow);
            GProblem.solidWndInset = (GProblem.solidWndInset + 10) % (GSolidWindow.getInitSize() / 2);
            GProblem.menuBar.addWindowMenuItem(this, "Solid " + gSolid.getLabel());
            this.updateLabelBag();
            GProblem.modified = true;
        }
    }

    public void vertexProperties(GSolidWindow gSolidWindow) {
        GSolid gSolid = gSolidWindow.getSolid();
        GVertexNode gVertexNode = gSolid.getSelectedVertices().getHead();
        if (gVertexNode == null) {
            new GAlertDialog(GProblem.frame, "warn.gif", "GEOMETRIA Warning", "Please select a point");
            return;
        }
        GVertexPropsDialog gVertexPropsDialog = new GVertexPropsDialog(GProblem.frame, this.notepad, gSolid, gVertexNode.getVertex());
        gSolid.clearSelection(true, true, true);
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gVertexPropsDialog.result == 0) {
            gSolidWindow.updateContent(null);
            this.updateLabelBag();
            GProblem.menuBar.update(this, gSolidWindow);
            GProblem.modified = true;
        }
    }

    public void setFacetColor(GSolidWindow gSolidWindow) {
        GSolid gSolid = gSolidWindow.getSolid();
        GFacetNode gFacetNode = gSolid.getSelectedFacets().getHead();
        if (gFacetNode == null) {
            int n = gSolid.getViewMode();
            String string = n != 1 && n != 2 ? "switch to polychrome or monochrome view mode and " : "";
            new GAlertDialog(GProblem.frame, "warn.gif", "GEOMETRIA Warning", "Please " + string + "select a facet");
            return;
        }
        GFacetColorDialog gFacetColorDialog = new GFacetColorDialog(GProblem.frame, gSolidWindow.getTitle(), gFacetNode.getFacet());
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gFacetColorDialog.result == 0) {
            gSolidWindow.updateContent(null);
            GProblem.menuBar.update(this, gSolidWindow);
            GProblem.modified = true;
        }
    }

    public void setBasicColor(GSolidWindow gSolidWindow) {
        GSolid gSolid = gSolidWindow.getSolid();
        GBasicColorDialog gBasicColorDialog = new GBasicColorDialog(GProblem.frame, gSolid.palette.getBasicColor(), gSolidWindow.getTitle());
        if (gBasicColorDialog.result == 0) {
            gSolid.palette.setBasicColor(gBasicColorDialog.getColor());
            gSolidWindow.updateContent(null);
            GProblem.modified = true;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        GCheckboxMenuItem gCheckboxMenuItem = (GCheckboxMenuItem)itemEvent.getSource();
        GMenu cfr_ignored_0 = (GMenu)gCheckboxMenuItem.getParent();
        GCMenuBar gCMenuBar = (GCMenuBar)GProblem.menuBar;
        if (gCheckboxMenuItem == gCMenuBar.xyGridMenuItem) {
            this.switchXYGrid();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        GSolidWindow gSolidWindow;
        super.actionPerformed(actionEvent);
        GMenuItem gMenuItem = (GMenuItem)actionEvent.getSource();
        GMenu gMenu = (GMenu)gMenuItem.getParent();
        GCMenuBar gCMenuBar = (GCMenuBar)GProblem.menuBar;
        GSolidWindow gSolidWindow2 = gSolidWindow = this.solidWndList.getDim() > 0 ? this.solidWndList.getTop().getWindow() : null;
        if (gMenu == gCMenuBar.dataMenu) {
            if (gMenuItem == gCMenuBar.answerMenuItem) {
                this.setAnswer();
                return;
            }
            if (gMenuItem == gCMenuBar.randomizeMenuItem) {
                this.setRandomization();
                return;
            }
            if (gMenuItem == gCMenuBar.toolsAvailMenuItem) {
                this.setToolsAvail();
                return;
            }
            if (gMenuItem == gCMenuBar.commentsMenuItem) {
                this.setComments();
                return;
            }
            if (gMenuItem == gCMenuBar.copyrightMenuItem) {
                this.setCopyright();
                return;
            }
        } else if (gMenu == gCMenuBar.shapeMenu) {
            if (gMenuItem == gCMenuBar.customShapeMenuItem) {
                this.openShape(gSolidWindow);
                return;
            }
            if (gMenuItem == gCMenuBar.saveShapeMenuItem) {
                this.saveShape(gSolidWindow);
                return;
            }
        } else if (gMenu == gCMenuBar.prismMenu) {
            if (gMenuItem == gCMenuBar.prism3MenuItem) {
                this.openShape(gSolidWindow, shapeDir, "prism3");
                return;
            }
            if (gMenuItem == gCMenuBar.prism4MenuItem) {
                this.openShape(gSolidWindow, shapeDir, "prism4");
                return;
            }
            if (gMenuItem == gCMenuBar.prism5MenuItem) {
                this.openShape(gSolidWindow, shapeDir, "prism5");
                return;
            }
            if (gMenuItem == gCMenuBar.prism6MenuItem) {
                this.openShape(gSolidWindow, shapeDir, "prism6");
                return;
            }
        } else if (gMenu == gCMenuBar.pyramidMenu) {
            if (gMenuItem == gCMenuBar.pyramid3MenuItem) {
                this.openShape(gSolidWindow, shapeDir, "pyramid3");
                return;
            }
            if (gMenuItem == gCMenuBar.pyramid4MenuItem) {
                this.openShape(gSolidWindow, shapeDir, "pyramid4");
                return;
            }
            if (gMenuItem == gCMenuBar.pyramid5MenuItem) {
                this.openShape(gSolidWindow, shapeDir, "pyramid5");
                return;
            }
            if (gMenuItem == gCMenuBar.pyramid6MenuItem) {
                this.openShape(gSolidWindow, shapeDir, "pyramid6");
                return;
            }
        } else if (gMenu == gCMenuBar.platonicMenu) {
            if (gMenuItem == gCMenuBar.tetrahedronMenuItem) {
                this.openShape(gSolidWindow, shapeDir, "tetrahedron");
                return;
            }
            if (gMenuItem == gCMenuBar.cubeMenuItem) {
                this.openShape(gSolidWindow, shapeDir, "cube");
                return;
            }
            if (gMenuItem == gCMenuBar.octahedronMenuItem) {
                this.openShape(gSolidWindow, shapeDir, "octahedron");
                return;
            }
            if (gMenuItem == gCMenuBar.dodecahedronMenuItem) {
                this.openShape(gSolidWindow, shapeDir, "dodecahedron");
                return;
            }
            if (gMenuItem == gCMenuBar.icosahedronMenuItem) {
                this.openShape(gSolidWindow, shapeDir, "icosahedron");
                return;
            }
        } else if (gMenu == gCMenuBar.transformMenu) {
            if (gMenuItem == gCMenuBar.stretchMenuItem) {
                this.stretchSolid(gSolidWindow);
                return;
            }
            if (gMenuItem == gCMenuBar.skewMenuItem) {
                this.skewSolid(gSolidWindow);
                return;
            }
            if (gMenuItem == gCMenuBar.undoTransformMenuItem) {
                this.undo(gSolidWindow, 0);
                return;
            }
        } else if (gMenu == gCMenuBar.measureMenu) {
            if (gMenuItem == gCMenuBar.areaMenuItem) {
                this.facetArea(gSolidWindow);
                return;
            }
            if (gMenuItem == gCMenuBar.volumeMenuItem) {
                this.volume(gSolidWindow);
                return;
            }
        } else if (gMenu == gCMenuBar.combineMenu) {
            if (gMenuItem == gCMenuBar.joinMenuItem) {
                this.join();
                return;
            }
            if (gMenuItem == gCMenuBar.addVertexMenuItem) {
                this.addVertex(gSolidWindow, null);
                return;
            }
            if (gMenuItem == gCMenuBar.undoAddVertexMenuItem) {
                this.undo(gSolidWindow, 1);
                return;
            }
        } else if (gMenu == gCMenuBar.viewMenu) {
            if (gMenuItem == gCMenuBar.basicColorMenuItem) {
                this.setBasicColor(gSolidWindow);
                return;
            }
            if (gMenuItem == gCMenuBar.facetColorMenuItem) {
                this.setFacetColor(gSolidWindow);
                return;
            }
            if (gMenuItem == gCMenuBar.vertexPropsMenuItem) {
                this.vertexProperties(gSolidWindow);
                return;
            }
        } else if (gMenu == gCMenuBar.windowMenu) {
            if (gMenuItem == gCMenuBar.newWindowMenuItem) {
                this.newSolid(null);
                return;
            }
            if (gMenuItem == gCMenuBar.renumberMenuItem) {
                gCMenuBar.initWindowMenu();
                this.renumberSolids();
            }
        }
    }
}

