/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

public class GCutDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "cut.gif";
    public static final Dimension ICONDIM = new Dimension(74, 153);
    private TextField[] p;
    private Checkbox drawings;
    private GSolid solid;
    public GSolid[] solidKids;

    public GCutDialog(GFrame gFrame, GSolid gSolid, int n, Object[] objectArray) {
        super(gFrame, "Cut Solid");
        this.helpTopic = "cut solid";
        this.solid = gSolid;
        this.p = new TextField[3];
        this.drawings = new Checkbox("Preserve drawings", true);
        this.solidKids = new GSolid[2];
        int n2 = 0;
        while (n2 < 3) {
            this.p[n2] = new TextField(3);
            this.p[n2].setFont(gFrame.labelFont);
            ++n2;
        }
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.set(n, objectArray);
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.gridwidth = 2;
        Label label = new Label("Cut the solid through points:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets.right = 10;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 5;
        Label label2 = new Label("Point 1:", 2);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.p[0], gridBagConstraints);
        this.dataPanel.add(this.p[0]);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 10;
        Label label3 = new Label("Point 2:", 2);
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.p[1], gridBagConstraints);
        this.dataPanel.add(this.p[1]);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 10;
        Label label4 = new Label("Point 3:", 2);
        gridBagLayout.setConstraints(label4, gridBagConstraints);
        this.dataPanel.add(label4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.p[2], gridBagConstraints);
        this.dataPanel.add(this.p[2]);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 10;
        gridBagLayout.setConstraints(this.drawings, gridBagConstraints);
        this.dataPanel.add(this.drawings);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase(), this.p[2].getText().toUpperCase(), new Boolean(this.drawings.getState())};
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p[0]).setText((String)objectArray[0]);
        ((TextComponent)this.p[1]).setText((String)objectArray[1]);
        ((TextComponent)this.p[2]).setText((String)objectArray[2]);
        this.drawings.setState((Boolean)objectArray[3]);
    }

    protected boolean onOk() {
        String[] stringArray = new String[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase(), this.p[2].getText().toUpperCase()};
        if (stringArray[0].equals("") || stringArray[1].equals("") || stringArray[2].equals("") || stringArray[0].equals(stringArray[1]) || stringArray[1].equals(stringArray[2]) || stringArray[2].equals(stringArray[0])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Plane", "Cut plane improperly referenced");
            return false;
        }
        Object object = this.solid.cutThrough(stringArray, this.drawings.getState());
        if (object instanceof String) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Cut Failed", (String)object);
            return false;
        }
        this.solidKids[0] = ((GSolid[])object)[0];
        this.solidKids[1] = ((GSolid[])object)[1];
        return true;
    }

    public void set(int n, Object[] objectArray) {
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            this.setTitle("Cut Solid " + this.solid.getLabel());
            int n2 = 0;
            GVertexNode gVertexNode = this.solid.getSelectedVertices().getHead();
            while (gVertexNode != null && n2 < 3) {
                ((TextComponent)this.p[n2++]).setText(gVertexNode.getVertex().getLabel());
                gVertexNode = gVertexNode.getNext();
            }
            GEdgeNode gEdgeNode = this.solid.getSelectedEdges().getHead();
            if (n2 == 1 && gEdgeNode != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                ((TextComponent)this.p[1]).setText(gEdge.getHead().getLabel());
                ((TextComponent)this.p[2]).setText(gEdge.getTail().getLabel());
            }
        }
        if (n == 0) {
            this.show();
            return;
        }
        this.result = this.onOk() ? 0 : 1;
    }
}

