/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

public class GLineDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "line.gif";
    public static final Dimension ICONDIM = new Dimension(120, 40);
    private TextField[] p;
    private GSolid solid;

    public GLineDialog(GFrame gFrame, GSolid gSolid, int n, Object[] objectArray) {
        super(gFrame, "Draw Line");
        this.helpTopic = "draw line";
        this.solid = gSolid;
        this.p = new TextField[2];
        int n2 = 0;
        while (n2 < 2) {
            this.p[n2] = new TextField(3);
            this.p[n2].setFont(gFrame.labelFont);
            ++n2;
        }
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.set(n, objectArray);
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        Label label = new Label("Join with a line the points labeled:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.p[0], gridBagConstraints);
        this.dataPanel.add(this.p[0]);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 5;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.p[1], gridBagConstraints);
        this.dataPanel.add(this.p[1]);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase()};
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p[0]).setText((String)objectArray[0]);
        ((TextComponent)this.p[1]).setText((String)objectArray[1]);
    }

    protected boolean onOk() {
        String[] stringArray = new String[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase()};
        if (stringArray[0].equals("") || stringArray[1].equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "No label assigned to end point");
            return false;
        }
        if (stringArray[0].equals(stringArray[1])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Line", String.valueOf(stringArray[0]) + stringArray[1] + " is no line");
            return false;
        }
        String string = this.solid.drawLine(stringArray);
        if (string != null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Draw Failed", string);
            return false;
        }
        return true;
    }

    public void set(int n, Object[] objectArray) {
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            this.setTitle("Draw Line in Solid " + this.solid.getLabel());
            GVertexList gVertexList = this.solid.getSelectedVertices();
            if (gVertexList.getDim() > 1) {
                GVertexNode gVertexNode = gVertexList.getHead();
                ((TextComponent)this.p[0]).setText(gVertexNode.getVertex().getLabel());
                ((TextComponent)this.p[1]).setText(gVertexNode.getNext().getVertex().getLabel());
            }
        }
        if (n == 0) {
            this.show();
            return;
        }
        this.result = this.onOk() ? 0 : 1;
    }
}

