/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

public class GNPRecordPropsDialog
extends GOkCancelHelpDialog {
    private TextField varName;
    private TextField numValue;
    private TextField source;

    public GNPRecordPropsDialog(GFrame gFrame, GNPRecord gNPRecord) {
        super(gFrame, "Record Properties");
        this.helpTopic = "notepad record";
        this.varName = new TextField(12);
        this.varName.setFont(gFrame.labelFont);
        this.varName.setEditable(false);
        this.numValue = new TextField(12);
        this.numValue.setFont(gFrame.labelFont);
        this.numValue.setEditable(false);
        this.source = new TextField(12);
        this.source.setFont(gFrame.labelFont);
        this.source.setEditable(false);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.init(gNPRecord);
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        Label label = new Label("Variable:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.varName, gridBagConstraints);
        this.dataPanel.add(this.varName);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        Label label2 = new Label("Numerical value:");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.numValue, gridBagConstraints);
        this.dataPanel.add(this.numValue);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        Label label3 = new Label("Origin:");
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.source, gridBagConstraints);
        this.dataPanel.add(this.source);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        return true;
    }

    public void init(GNPRecord gNPRecord) {
        this.setTitle("Notepad Record Properties");
        GVariable gVariable = gNPRecord.getLSide();
        ((TextComponent)this.varName).setText(gVariable.getName());
        double d = gVariable.getValue();
        ((TextComponent)this.numValue).setText(String.valueOf(d));
        this.numValue.select(0, GMath.leadingDigits(d));
        Object object = gNPRecord.getOrigin();
        if (object instanceof GSolid) {
            ((TextComponent)this.source).setText("Solid " + ((GSolid)object).getLabel());
            return;
        }
        ((TextComponent)this.source).setText((String)object);
    }
}

