/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class GFrame
extends Frame
implements ActionListener,
WindowListener {
    public static final Color BACKGROUND = Color.lightGray;
    public static final Point LOCATION = new Point(100, 50);
    public static final Dimension SIZE = new Dimension(640, 450);
    public static Font menuFont = new Font("Helvetica", 0, 13);
    public Font labelFont = new Font("Helvetica", 1, 13);
    public Font buttonFont = new Font("Helvetica", 0, 13);
    public Font textFont = new Font("Helvetica", 0, 13);
    public Font numberFont = new Font("Courier", 1, 13);
    protected GMenuBar menuBar;
    protected Panel dataPanel;
    protected Panel solidsPanel;
    protected GCalculator calculator;
    protected GNotepad notepad = new GNotepad(this, 8);
    public Button evalButton;
    public Button writeDownButton;
    public Button clearButton;
    protected GProblem problem;
    public String problemDir = "problems";
    public String resDir = "resolutions";
    public String imageDir = "images";
    public String helpFile = "Help";
    public String helpStatus;
    public GHelpDialog helpDialog;

    public GFrame() {
        this.calculator = new GCalculator(25, this, this.notepad);
        this.evalButton = new Button("Get Value");
        this.evalButton.addActionListener(this.calculator);
        this.evalButton.setFont(this.buttonFont);
        this.writeDownButton = new Button("Write down");
        this.writeDownButton.addActionListener(this.calculator);
        this.writeDownButton.setFont(this.buttonFont);
        this.clearButton = new Button("Clear");
        this.clearButton.addActionListener(this.calculator);
        this.clearButton.setFont(this.buttonFont);
        this.addWindowListener(this);
        ((Component)this).setSize(SIZE);
        this.position();
        this.loadHelpFile();
    }

    protected abstract Component decorateHypothesisView();

    protected abstract void openProblem();

    protected void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.dataPanel = new Panel();
        this.solidsPanel = new Panel();
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        this.setLayout(gridBagLayout);
        this.dataPanel.setLayout(gridBagLayout);
        this.solidsPanel.setLayout(gridBagLayout);
        panel.setLayout(gridBagLayout);
        panel2.setLayout(gridBagLayout);
        panel3.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.dataPanel, gridBagConstraints);
        this.dataPanel.setBackground(BACKGROUND);
        ((Component)this.dataPanel).setFont(this.textFont);
        this.add(this.dataPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.solidsPanel, gridBagConstraints);
        this.solidsPanel.setBackground(BACKGROUND.darker());
        this.add(this.solidsPanel);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.dataPanel.add(panel);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.dataPanel.add(panel2);
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        this.dataPanel.add(panel3);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 10;
        Label label = new Label("Hypothesis:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.insets.right = 3;
        Component component = this.decorateHypothesisView();
        gridBagLayout.setConstraints(component, gridBagConstraints);
        panel.add(component);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        Label label2 = new Label("Calculator");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel2.add(label2);
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.insets.top = 5;
        gridBagLayout.setConstraints(this.calculator.awtField, gridBagConstraints);
        panel2.add(this.calculator.awtField);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 10;
        gridBagLayout.setConstraints(this.writeDownButton, gridBagConstraints);
        panel2.add(this.writeDownButton);
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.evalButton, gridBagConstraints);
        panel2.add(this.evalButton);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.clearButton, gridBagConstraints);
        panel2.add(this.clearButton);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.fill = 2;
        Label label3 = new Label("Notepad");
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        panel3.add(label3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.insets.top = 5;
        gridBagLayout.setConstraints(GNotepad.awtList, gridBagConstraints);
        panel3.add(GNotepad.awtList);
    }

    public Rectangle getSolidsArea() {
        Point point = this.getLocation();
        Rectangle rectangle = this.solidsPanel.getBounds();
        rectangle.translate(point.x, point.y);
        return rectangle;
    }

    public void repaintSolidsArea() {
        this.solidsPanel.repaint();
    }

    protected void position() {
        Dimension dimension = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dimension.width - GFrame.SIZE.width) / 2, (dimension.height - GFrame.SIZE.height) / 2);
    }

    protected void loadHelpFile() {
        FileInputStream fileInputStream;
        Object object;
        try {
            object = new File(this.helpFile);
            fileInputStream = new FileInputStream((File)object);
        }
        catch (IOException iOException) {
            this.helpStatus = "Help file not found";
            return;
        }
        try {
            object = new ObjectInputStream(fileInputStream);
            this.helpDialog = new GHelpDialog(this, (GHelpTopicList)((ObjectInputStream)object).readObject());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException.toString());
            return;
        }
        catch (IOException iOException) {
            this.helpStatus = "Help file corrupted";
            return;
        }
    }

    protected void setProblem(GProblem gProblem, GProblem gProblem2) {
        this.addComponentListener(gProblem2);
        this.menuBar.setProblem(gProblem, gProblem2);
        this.calculator.setProblem(gProblem2);
        this.notepad.setProblem(gProblem2);
    }

    public void notForShare() {
        new GAlertDialog(this, "warn.gif", "GEOMETRIA", "Feature not available in shareware version of GEOMETRIA");
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            ActionEvent actionEvent = new ActionEvent(this.menuBar.exitMenuItem, 0, null);
            this.actionPerformed(actionEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        GMenuItem gMenuItem = (GMenuItem)actionEvent.getSource();
        GMenu gMenu = (GMenu)gMenuItem.getParent();
        if (gMenu == this.menuBar.fileMenu) {
            if (gMenuItem == this.menuBar.openMenuItem) {
                if (this.problem == null || this.problem.onClose()) {
                    this.openProblem();
                }
            } else if (gMenuItem == this.menuBar.exitMenuItem) {
                if (this.problem == null) {
                    System.exit(0);
                }
                if (this.problem.onClose()) {
                    this.problem.close();
                    System.exit(0);
                }
            }
        }
        if (gMenu == this.menuBar.helpMenu) {
            if (gMenuItem == this.menuBar.aboutMenuItem) {
                new GAboutDialog(this);
                return;
            }
            if (this.helpStatus != null) {
                new GAlertDialog(this, "warn.gif", "No Help", this.helpStatus);
                return;
            }
            if (gMenuItem == this.menuBar.topicsMenuItem) {
                this.helpDialog.set("contents", false);
                return;
            }
            if (gMenuItem == this.menuBar.indexMenuItem) {
                this.helpDialog.set(null, false);
            }
        }
    }
}

