/*
 * Decompiled with CFR 0.152.
 */
import java.awt.MenuBar;
import java.awt.MenuShortcut;
import java.util.Enumeration;

public abstract class GMenuBar
extends MenuBar {
    public GMenu fileMenu;
    public GMenu measureMenu;
    public GMenu drawMenu;
    public GMenu viewMenu;
    public GMenu revolveMenu;
    public GMenu windowMenu;
    public GMenu helpMenu;
    public GMenuItem openMenuItem;
    public GMenuItem saveMenuItem;
    public GMenuItem saveAsMenuItem;
    public GMenuItem answerMenuItem;
    public GMenuItem exitMenuItem;
    public GMenuItem distanceMenuItem;
    public GMenuItem angleMenuItem;
    public GMenuItem lineMenuItem;
    public GMenuItem perpMenuItem;
    public GMenuItem midpointMenuItem;
    public GMenuItem layDistanceMenuItem;
    public GMenuItem layAngleMenuItem;
    public GMenuItem bisectorMenuItem;
    public GMenuItem intersectMenuItem;
    public GMenuItem cutMenuItem;
    public GMenuItem eraseMenuItem;
    public GMenuItem eraseAllMenuItem;
    public GMenuItem initAttMenuItem;
    public GMenuItem leftMenuItem;
    public GMenuItem rightMenuItem;
    public GMenuItem backMenuItem;
    public GMenuItem forthMenuItem;
    public GMenuItem zoomInMenuItem;
    public GMenuItem zoomOutMenuItem;
    public GMenuItem bestFitMenuItem;
    public GMenuItem cascadeMenuItem;
    public GMenuItem maximizeMenuItem;
    public GMenuItem topicsMenuItem;
    public GMenuItem indexMenuItem;
    public GMenuItem aboutMenuItem;
    public GCheckboxMenuItem transparentMenuItem;
    public GCheckboxMenuItem polychromeMenuItem;
    public GCheckboxMenuItem monochromeMenuItem;
    public GCheckboxMenuItem labelsMenuItem;
    public GMenuItemList windowMenuItemList;

    public GMenuBar(GFrame gFrame) {
        this.setFont(GFrame.menuFont);
        this.init(gFrame);
        this.windowMenuItemList = new GMenuItemList();
        this.build();
    }

    protected abstract void build();

    protected void init(GFrame gFrame) {
        this.fileMenu = new GMenu("File");
        this.measureMenu = new GMenu("Measure");
        this.drawMenu = new GMenu("Draw");
        this.viewMenu = new GMenu("View");
        this.revolveMenu = new GMenu("Revolve");
        this.windowMenu = new GMenu("Window");
        this.helpMenu = new GMenu("Help");
        this.openMenuItem = new GMenuItem("Open");
        this.openMenuItem.setShortcut(new MenuShortcut(79));
        this.openMenuItem.addActionListener(gFrame);
        this.saveMenuItem = new GMenuItem("Save");
        this.saveMenuItem.setShortcut(new MenuShortcut(83));
        this.saveAsMenuItem = new GMenuItem("Save As");
        this.answerMenuItem = new GMenuItem("Answer");
        this.exitMenuItem = new GMenuItem("Exit");
        this.exitMenuItem.setShortcut(new MenuShortcut(88));
        this.exitMenuItem.addActionListener(gFrame);
        this.distanceMenuItem = new GMenuItem("Distance");
        this.measureMenu.add(this.distanceMenuItem);
        this.angleMenuItem = new GMenuItem("Angle");
        this.measureMenu.add(this.angleMenuItem);
        this.lineMenuItem = new GMenuItem("Line");
        this.perpMenuItem = new GMenuItem("Perpendicular");
        this.midpointMenuItem = new GMenuItem("Midpoint");
        this.bisectorMenuItem = new GMenuItem("Bisector");
        this.intersectMenuItem = new GMenuItem("Intersection");
        this.layDistanceMenuItem = new GMenuItem("Lay Distance");
        this.layAngleMenuItem = new GMenuItem("Lay Angle");
        this.cutMenuItem = new GMenuItem("Cut");
        this.eraseMenuItem = new GMenuItem("Erase");
        this.eraseAllMenuItem = new GMenuItem("Erase All");
        this.initAttMenuItem = new GMenuItem("Initial attitude");
        this.initAttMenuItem.setShortcut(new MenuShortcut(36));
        this.leftMenuItem = new GMenuItem("Turn Left");
        this.leftMenuItem.setShortcut(new MenuShortcut(37));
        this.rightMenuItem = new GMenuItem("Turn Right");
        this.rightMenuItem.setShortcut(new MenuShortcut(39));
        this.backMenuItem = new GMenuItem("Bend Back");
        this.backMenuItem.setShortcut(new MenuShortcut(38));
        this.forthMenuItem = new GMenuItem("Bend Forth");
        this.forthMenuItem.setShortcut(new MenuShortcut(40));
        this.zoomInMenuItem = new GMenuItem("Zoom In");
        this.zoomInMenuItem.setShortcut(new MenuShortcut(33));
        this.zoomOutMenuItem = new GMenuItem("Zoom Out");
        this.zoomOutMenuItem.setShortcut(new MenuShortcut(34));
        this.bestFitMenuItem = new GMenuItem("Fit Into Window");
        this.bestFitMenuItem.setShortcut(new MenuShortcut(32));
        this.labelsMenuItem = new GCheckboxMenuItem("Show Labels");
        this.transparentMenuItem = new GCheckboxMenuItem("Transparent");
        this.polychromeMenuItem = new GCheckboxMenuItem("Polychrome");
        this.monochromeMenuItem = new GCheckboxMenuItem("Monochrome");
        this.cascadeMenuItem = new GMenuItem("Cascade");
        this.maximizeMenuItem = new GMenuItem("Maximize");
        this.topicsMenuItem = new GMenuItem("Help Topics");
        this.topicsMenuItem.addActionListener(gFrame);
        this.indexMenuItem = new GMenuItem("Index");
        this.indexMenuItem.addActionListener(gFrame);
        this.aboutMenuItem = new GMenuItem("About Geometria");
        this.aboutMenuItem.addActionListener(gFrame);
    }

    public void setProblem(GProblem gProblem, GProblem gProblem2) {
        int n = 0;
        while (n < this.getMenuCount()) {
            GMenu gMenu = (GMenu)this.getMenu(n);
            if (gMenu != this.fileMenu && gMenu != this.helpMenu) {
                ((GMenu)this.getMenu(n)).setListeners(gProblem, gProblem2);
            }
            ++n;
        }
        if (gProblem != null) {
            this.saveMenuItem.removeActionListener(gProblem);
            this.saveAsMenuItem.removeActionListener(gProblem);
        }
        this.saveMenuItem.addActionListener(gProblem2);
        this.saveAsMenuItem.addActionListener(gProblem2);
    }

    public void update(GProblem gProblem, GSolidWindow gSolidWindow) {
        if (gSolidWindow == null) {
            this.initWindowMenu();
            this.measureMenu.enableAll(false);
            this.drawMenu.enableAll(false);
            this.viewMenu.enableAll(false);
            this.windowMenu.enableAll(false);
            return;
        }
        this.measureMenu.enableAll(true);
        this.drawMenu.enableAll(true);
        if (gProblem instanceof GRProblem) {
            this.lineMenuItem.setEnabled(gProblem.isLineAvailable());
            this.perpMenuItem.setEnabled(gProblem.isPerpAvailable());
            this.midpointMenuItem.setEnabled(gProblem.isMidpointAvailable());
            this.bisectorMenuItem.setEnabled(gProblem.isBisectorAvailable());
            this.layDistanceMenuItem.setEnabled(gProblem.isLayDistAvailable());
            this.layAngleMenuItem.setEnabled(gProblem.isLayAngleAvailable());
            this.cutMenuItem.setEnabled(gProblem.isCutAvailable());
        }
        this.viewMenu.enableAll(true);
        this.windowMenu.enableAll(true);
        this.labelsMenuItem.setState(gSolidWindow.getSolid().isLabeled());
        this.checkViewMode(gSolidWindow.getSolid().getViewMode());
    }

    public void addWindowMenuItem(GProblem gProblem, String string) {
        GCheckboxMenuItem gCheckboxMenuItem = this.windowMenuItemList.addToTail(string);
        if (gCheckboxMenuItem == null) {
            return;
        }
        gCheckboxMenuItem.addItemListener(gProblem);
        gCheckboxMenuItem.setState(true);
        this.windowMenu.add(gCheckboxMenuItem);
    }

    public void removeWindowMenuItem(String string) {
        GCheckboxMenuItem gCheckboxMenuItem = this.windowMenuItemList.remove(string);
        if (gCheckboxMenuItem != null) {
            this.windowMenu.remove(gCheckboxMenuItem);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void selectWindowMenuItem(String var1_1) {
        var2_2 = this.windowMenuItemList.getHead();
        if (var2_2 != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2.getItem();
            var3_3.setState(var1_1.equals(var3_3.getLabel()));
            var2_2 = var2_2.getNext();
lbl7:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl8:
        // 1 sources

    }

    public int checkViewMode(GCheckboxMenuItem gCheckboxMenuItem) {
        this.transparentMenuItem.setState(false);
        this.polychromeMenuItem.setState(false);
        this.monochromeMenuItem.setState(false);
        gCheckboxMenuItem.setState(true);
        if (gCheckboxMenuItem == this.polychromeMenuItem) {
            return 1;
        }
        if (gCheckboxMenuItem == this.monochromeMenuItem) {
            return 2;
        }
        return 0;
    }

    public GCheckboxMenuItem checkViewMode(int n) {
        GCheckboxMenuItem gCheckboxMenuItem;
        this.transparentMenuItem.setState(false);
        this.polychromeMenuItem.setState(false);
        this.monochromeMenuItem.setState(false);
        switch (n) {
            case 1: {
                gCheckboxMenuItem = this.polychromeMenuItem;
                break;
            }
            case 2: {
                gCheckboxMenuItem = this.monochromeMenuItem;
                break;
            }
            default: {
                gCheckboxMenuItem = this.transparentMenuItem;
            }
        }
        gCheckboxMenuItem.setState(true);
        return gCheckboxMenuItem;
    }

    public GMenuItem seek(int n) {
        Enumeration<MenuShortcut> enumeration = this.shortcuts();
        while (enumeration.hasMoreElements()) {
            MenuShortcut menuShortcut = enumeration.nextElement();
            if (menuShortcut.getKey() != n) continue;
            GMenuItem gMenuItem = (GMenuItem)this.getShortcutMenuItem(menuShortcut);
            return gMenuItem;
        }
        return null;
    }

    public void initWindowMenu() {
        int n;
        while (this.windowMenu.getItem(n = this.windowMenu.getItemCount() - 1) instanceof GCheckboxMenuItem) {
            this.windowMenu.remove(n);
        }
        this.windowMenuItemList.flush();
    }
}

