/*
 * Decompiled with CFR 0.152.
 */
package Typing;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class TextComponentCutPaste
extends MouseAdapter {
    protected JTextComponent textComponent;
    protected AbstractAction cutAction;
    protected AbstractAction copyAction;
    protected AbstractAction pasteAction;
    protected JPopupMenu popupMenu = new JPopupMenu();

    public TextComponentCutPaste() {
        this.cutAction = new AbstractAction("Cut"){

            public void actionPerformed(ActionEvent actionEvent) {
                TextComponentCutPaste.this.textComponent.cut();
            }
        };
        this.popupMenu.add(this.cutAction);
        this.copyAction = new AbstractAction("Copy"){

            public void actionPerformed(ActionEvent actionEvent) {
                TextComponentCutPaste.this.textComponent.copy();
            }
        };
        this.popupMenu.add(this.copyAction);
        this.pasteAction = new AbstractAction("Paste"){

            public void actionPerformed(ActionEvent actionEvent) {
                TextComponentCutPaste.this.textComponent.paste();
            }
        };
        this.popupMenu.add(this.pasteAction);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkTrigger(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkTrigger(mouseEvent);
    }

    protected void checkTrigger(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.textComponent = (JTextComponent)mouseEvent.getSource();
            String string = this.textComponent.getSelectedText();
            boolean bl = string != null && string.length() > 0;
            this.cutAction.setEnabled(bl);
            this.copyAction.setEnabled(bl);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            this.pasteAction.setEnabled(transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && this.textComponent.hasFocus() && this.textComponent.isEditable());
            this.popupMenu.show(this.textComponent, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }
}

