/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public PushbackReader(Reader reader, int n) {
        super(reader);
        if (n <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new char[n];
        this.pos = n;
    }

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos < this.buf.length) {
                char c = this.buf[this.pos++];
                return c;
            }
            int n = super.read();
            return n;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            try {
                if (n2 <= 0) {
                    if (n2 < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (n < 0 || n > cArray.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    int n3 = 0;
                    return n3;
                }
                int n4 = this.buf.length - this.pos;
                if (n4 > 0) {
                    if (n2 < n4) {
                        n4 = n2;
                    }
                    System.arraycopy(this.buf, this.pos, cArray, n, n4);
                    this.pos += n4;
                    n += n4;
                    n2 -= n4;
                }
                if (n2 > 0) {
                    if ((n2 = super.read(cArray, n, n2)) == -1) {
                        int n5 = n4 == 0 ? -1 : n4;
                        return n5;
                    }
                    int n6 = n4 + n2;
                    return n6;
                }
                int n7 = n4;
                return n7;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public void unread(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos == 0) {
                throw new IOException("Pushback buffer overflow");
            }
            this.buf[--this.pos] = (char)n;
        }
    }

    public void unread(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n2 > this.pos) {
                throw new IOException("Pushback buffer overflow");
            }
            this.pos -= n2;
            System.arraycopy(cArray, n, this.buf, this.pos, n2);
        }
    }

    public void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            boolean bl = this.pos < this.buf.length || super.ready();
            return bl;
        }
    }

    public void mark(int n) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        super.close();
        this.buf = null;
    }
}

