/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.DefaultFocusManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class FocusManager {
    public static final String FOCUS_MANAGER_CLASS_PROPERTY = "FocusManagerClassName";
    private static final Object focusManagerKey = class$javax$swing$FocusManager == null ? (class$javax$swing$FocusManager = FocusManager.class$("javax.swing.FocusManager")) : class$javax$swing$FocusManager;
    static /* synthetic */ Class class$javax$swing$FocusManager;

    public static FocusManager getCurrentManager() {
        FocusManager focusManager = (FocusManager)SwingUtilities.appContextGet(focusManagerKey);
        if (focusManager == null) {
            String string = UIManager.getString(FOCUS_MANAGER_CLASS_PROPERTY);
            try {
                Class clazz = Class.forName(string);
                if (clazz != null) {
                    focusManager = (FocusManager)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Cannot find class " + string + " " + classNotFoundException);
                focusManager = null;
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Cannot instantiate class " + string + " " + instantiationException);
                focusManager = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Cannot access class " + string + " " + illegalAccessException);
                focusManager = null;
            }
            if (focusManager == null) {
                focusManager = new DefaultFocusManager();
            }
            SwingUtilities.appContextPut(focusManagerKey, focusManager);
        }
        return focusManager;
    }

    public static void setCurrentManager(FocusManager focusManager) {
        if (focusManager != null) {
            SwingUtilities.appContextPut(focusManagerKey, focusManager);
        } else {
            SwingUtilities.appContextRemove(focusManagerKey);
        }
    }

    public static void disableSwingFocusManager() {
        FocusManager.setCurrentManager(new DisabledFocusManager());
    }

    public static boolean isFocusManagerEnabled() {
        FocusManager focusManager = FocusManager.getCurrentManager();
        return !(focusManager instanceof DisabledFocusManager);
    }

    public abstract void processKeyEvent(Component var1, KeyEvent var2);

    public abstract void focusNextComponent(Component var1);

    public abstract void focusPreviousComponent(Component var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DisabledFocusManager
    extends FocusManager {
        DisabledFocusManager() {
        }

        public void processKeyEvent(Component component, KeyEvent keyEvent) {
        }

        public void focusNextComponent(Component component) {
        }

        public void focusPreviousComponent(Component component) {
        }
    }
}

