/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import sun.awt.image.BufferedImageDevice;
import sun.java2d.OutputManager;
import sun.java2d.loops.RasterOutputManager;

public class BufferedImageGraphicsConfig
extends GraphicsConfiguration {
    private static final int numconfigs = 12;
    private static BufferedImageGraphicsConfig[] configs = new BufferedImageGraphicsConfig[12];
    BufferedImage bImg;
    Component component;

    public static GraphicsConfiguration getConfig(BufferedImage bufferedImage) {
        BufferedImageGraphicsConfig bufferedImageGraphicsConfig;
        int n = bufferedImage.getType();
        if (n > 0 && n < 12 && (bufferedImageGraphicsConfig = configs[n]) != null) {
            return bufferedImageGraphicsConfig;
        }
        bufferedImageGraphicsConfig = new BufferedImageGraphicsConfig(bufferedImage, null);
        if (n > 0 && n < 12) {
            BufferedImageGraphicsConfig.configs[n] = bufferedImageGraphicsConfig;
        }
        return bufferedImageGraphicsConfig;
    }

    public static OutputManager getOutputManager(BufferedImage bufferedImage) {
        return RasterOutputManager.getManager();
    }

    public BufferedImageGraphicsConfig(BufferedImage bufferedImage, Component component) {
        this.bImg = bufferedImage;
        this.component = component;
    }

    public GraphicsDevice getDevice() {
        if (this.component == null) {
            return new BufferedImageDevice(this.bImg);
        }
        Graphics2D graphics2D = (Graphics2D)this.component.getGraphics();
        return graphics2D.getDeviceConfiguration().getDevice();
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.bImg.getColorModel();
        WritableRaster writableRaster = this.bImg.getRaster().createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        return this.createCompatibleImage(n, n2);
    }

    public ColorModel getColorModel() {
        return this.bImg.getColorModel();
    }

    public ColorModel getColorModel(int n) {
        ColorModel colorModel = this.bImg.getColorModel();
        if (colorModel.getTransparency() == n) {
            return colorModel;
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.bImg.getWidth(), this.bImg.getHeight());
    }
}

