/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.security.action.GetBooleanAction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProxyGenerator {
    private static final String superclassName = "java/lang/reflect/Proxy";
    private static final String handlerFieldName = "h";
    private static final boolean saveGeneratedFiles = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.misc.ProxyGenerator.saveGeneratedFiles"));
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    private String className;
    private Class[] interfaces;
    private ConstantPool cp = new ConstantPool();
    private List fields = new ArrayList();
    private List methods = new ArrayList();
    private Map proxyMethods = new HashMap(11);
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Error;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static byte[] generateProxyClass(final String string, Class[] classArray) {
        ProxyGenerator proxyGenerator = new ProxyGenerator(string, classArray);
        final byte[] byArray = proxyGenerator.generateClassFile();
        if (saveGeneratedFiles) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(ProxyGenerator.dotToSlash(string) + ".class");
                        fileOutputStream.write(byArray);
                        fileOutputStream.close();
                        return null;
                    }
                    catch (IOException iOException) {
                        throw new InternalError("I/O exception saving generated file: " + iOException);
                    }
                }
            });
        }
        return byArray;
    }

    private ProxyGenerator(String string, Class[] classArray) {
        this.className = string;
        this.interfaces = classArray;
    }

    private byte[] generateClassFile() {
        Object object;
        this.addProxyMethod(hashCodeMethod, class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object);
        this.addProxyMethod(equalsMethod, class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object);
        this.addProxyMethod(toStringMethod, class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object);
        int n = 0;
        while (n < this.interfaces.length) {
            object = this.interfaces[n].getMethods();
            int n2 = 0;
            while (n2 < ((Method[])object).length) {
                this.addProxyMethod((Method)object[n2], this.interfaces[n]);
                ++n2;
            }
            ++n;
        }
        try {
            this.methods.add(this.generateConstructor());
            object = this.proxyMethods.values().iterator();
            while (object.hasNext()) {
                ProxyMethod proxyMethod = (ProxyMethod)object.next();
                this.fields.add(new FieldInfo(proxyMethod.methodFieldName, "Ljava/lang/reflect/Method;", 10));
                this.methods.add(proxyMethod.generateMethod());
            }
            this.methods.add(this.generateStaticInitializer());
        }
        catch (IOException iOException) {
            throw new InternalError("unexpected I/O Exception");
        }
        this.cp.getClass(ProxyGenerator.dotToSlash(this.className));
        this.cp.getClass(superclassName);
        int n3 = 0;
        while (n3 < this.interfaces.length) {
            this.cp.getClass(ProxyGenerator.dotToSlash(this.interfaces[n3].getName()));
            ++n3;
        }
        this.cp.setReadOnly();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            Object object2;
            dataOutputStream.writeInt(-889275714);
            dataOutputStream.writeShort(3);
            dataOutputStream.writeShort(45);
            this.cp.write(dataOutputStream);
            dataOutputStream.writeShort(49);
            dataOutputStream.writeShort(this.cp.getClass(ProxyGenerator.dotToSlash(this.className)));
            dataOutputStream.writeShort(this.cp.getClass(superclassName));
            dataOutputStream.writeShort(this.interfaces.length);
            int n4 = 0;
            while (n4 < this.interfaces.length) {
                dataOutputStream.writeShort(this.cp.getClass(ProxyGenerator.dotToSlash(this.interfaces[n4].getName())));
                ++n4;
            }
            dataOutputStream.writeShort(this.fields.size());
            Iterator iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                object2 = (FieldInfo)iterator.next();
                ((FieldInfo)object2).write(dataOutputStream);
            }
            dataOutputStream.writeShort(this.methods.size());
            object2 = this.methods.iterator();
            while (object2.hasNext()) {
                MethodInfo methodInfo = (MethodInfo)object2.next();
                methodInfo.write(dataOutputStream);
            }
            dataOutputStream.writeShort(0);
        }
        catch (IOException iOException) {
            throw new InternalError("unexpected I/O Exception");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void addProxyMethod(Method method, Class clazz) {
        String string = method.getName();
        Class[] classArray = method.getParameterTypes();
        Class clazz2 = method.getReturnType();
        Class[] classArray2 = method.getExceptionTypes();
        String string2 = string + ProxyGenerator.getParameterDescriptors(classArray);
        ProxyMethod proxyMethod = (ProxyMethod)this.proxyMethods.get(string2);
        if (proxyMethod != null) {
            if (clazz2 != proxyMethod.returnType) {
                throw new IllegalArgumentException("methods with same name and parameter signature but different return type in " + proxyMethod.fromClass + " and " + clazz + ": " + string2);
            }
            ArrayList arrayList = new ArrayList();
            ProxyGenerator.collectCompatibleTypes(classArray2, proxyMethod.exceptionTypes, arrayList);
            ProxyGenerator.collectCompatibleTypes(proxyMethod.exceptionTypes, classArray2, arrayList);
            proxyMethod.exceptionTypes = new Class[arrayList.size()];
            proxyMethod.exceptionTypes = (Class[])arrayList.toArray(proxyMethod.exceptionTypes);
        } else {
            proxyMethod = new ProxyMethod(string, classArray, clazz2, classArray2, clazz, "m" + this.proxyMethods.size());
            this.proxyMethods.put(string2, proxyMethod);
        }
    }

    private MethodInfo generateConstructor() throws IOException {
        MethodInfo methodInfo = new MethodInfo("<init>", "(Ljava/lang/reflect/InvocationHandler;)V", 1);
        DataOutputStream dataOutputStream = new DataOutputStream(methodInfo.code);
        this.code_aload(0, dataOutputStream);
        this.code_aload(1, dataOutputStream);
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(this.cp.getMethodRef(superclassName, "<init>", "(Ljava/lang/reflect/InvocationHandler;)V"));
        dataOutputStream.writeByte(177);
        methodInfo.maxStack = (short)10;
        methodInfo.maxLocals = (short)2;
        methodInfo.declaredExceptions = new short[0];
        return methodInfo;
    }

    private MethodInfo generateStaticInitializer() throws IOException {
        short s;
        MethodInfo methodInfo = new MethodInfo("<clinit>", "()V", 8);
        int n = 1;
        short s2 = 0;
        DataOutputStream dataOutputStream = new DataOutputStream(methodInfo.code);
        Iterator iterator = this.proxyMethods.values().iterator();
        while (iterator.hasNext()) {
            ProxyMethod proxyMethod = (ProxyMethod)iterator.next();
            proxyMethod.codeFieldInitialization(dataOutputStream);
        }
        dataOutputStream.writeByte(177);
        short s3 = s = (short)methodInfo.code.size();
        methodInfo.exceptionTable.add(new ExceptionTableEntry(s2, s3, s, this.cp.getClass("java/lang/NoSuchMethodException")));
        this.code_astore(n, dataOutputStream);
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(this.cp.getClass("java/lang/NoSuchMethodError"));
        dataOutputStream.writeByte(89);
        this.code_aload(n, dataOutputStream);
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/Throwable", "getMessage", "()Ljava/lang/String;"));
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/NoSuchMethodError", "<init>", "(Ljava/lang/String;)V"));
        dataOutputStream.writeByte(191);
        s = (short)methodInfo.code.size();
        methodInfo.exceptionTable.add(new ExceptionTableEntry(s2, s3, s, this.cp.getClass("java/lang/ClassNotFoundException")));
        this.code_astore(n, dataOutputStream);
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(this.cp.getClass("java/lang/NoClassDefFoundError"));
        dataOutputStream.writeByte(89);
        this.code_aload(n, dataOutputStream);
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/Throwable", "getMessage", "()Ljava/lang/String;"));
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V"));
        dataOutputStream.writeByte(191);
        methodInfo.maxStack = (short)10;
        methodInfo.maxLocals = (short)(n + 1);
        methodInfo.declaredExceptions = new short[0];
        return methodInfo;
    }

    private void code_iload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 21, 26, dataOutputStream);
    }

    private void code_lload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 22, 30, dataOutputStream);
    }

    private void code_fload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 23, 34, dataOutputStream);
    }

    private void code_dload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 24, 38, dataOutputStream);
    }

    private void code_aload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 25, 42, dataOutputStream);
    }

    private void code_istore(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 54, 59, dataOutputStream);
    }

    private void code_lstore(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 55, 63, dataOutputStream);
    }

    private void code_fstore(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 56, 67, dataOutputStream);
    }

    private void code_dstore(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 57, 71, dataOutputStream);
    }

    private void code_astore(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 58, 75, dataOutputStream);
    }

    private void codeLocalLoadStore(int n, int n2, int n3, DataOutputStream dataOutputStream) throws IOException {
        ProxyGenerator.assert(n >= 0 && n <= 65535);
        if (n <= 3) {
            dataOutputStream.writeByte(n3 + n);
        } else if (n <= 255) {
            dataOutputStream.writeByte(n2);
            dataOutputStream.writeByte(n & 0xFF);
        } else {
            dataOutputStream.writeByte(196);
            dataOutputStream.writeByte(n2);
            dataOutputStream.writeShort(n & 0xFFFF);
        }
    }

    private void code_ldc(int n, DataOutputStream dataOutputStream) throws IOException {
        ProxyGenerator.assert(n >= 0 && n <= 65535);
        if (n <= 255) {
            dataOutputStream.writeByte(18);
            dataOutputStream.writeByte(n & 0xFF);
        } else {
            dataOutputStream.writeByte(19);
            dataOutputStream.writeShort(n & 0xFFFF);
        }
    }

    private void code_ipush(int n, DataOutputStream dataOutputStream) throws IOException {
        if (n >= -1 && n <= 5) {
            dataOutputStream.writeByte(3 + n);
        } else if (n >= -128 && n <= 127) {
            dataOutputStream.writeByte(16);
            dataOutputStream.writeByte(n & 0xFF);
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            dataOutputStream.writeByte(17);
            dataOutputStream.writeShort(n & 0xFFFF);
        } else {
            ProxyGenerator.assert(false);
        }
    }

    private void codeClassForName(Class clazz, DataOutputStream dataOutputStream) throws IOException {
        this.code_ldc(this.cp.getString(clazz.getName()), dataOutputStream);
        dataOutputStream.writeByte(184);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"));
    }

    private static void assert(boolean bl) {
        if (!bl) {
            throw new InternalError("assertion failure");
        }
    }

    private static String dotToSlash(String string) {
        return string.replace('.', '/');
    }

    private static String getMethodDescriptor(Class[] classArray, Class clazz) {
        return ProxyGenerator.getParameterDescriptors(classArray) + (clazz == Void.TYPE ? "V" : ProxyGenerator.getFieldType(clazz));
    }

    private static String getParameterDescriptors(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ProxyGenerator.getFieldType(classArray[n]));
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static String getFieldType(Class clazz) {
        if (clazz.isPrimitive()) {
            return PrimitiveTypeInfo.get((Class)clazz).baseTypeString;
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + ProxyGenerator.dotToSlash(clazz.getName()) + ";";
    }

    private static int getWordsPerType(Class clazz) {
        if (clazz == Long.TYPE || clazz == Double.TYPE) {
            return 2;
        }
        return 1;
    }

    private static void collectCompatibleTypes(Class[] classArray, Class[] classArray2, List list) {
        int n = 0;
        while (n < classArray.length) {
            if (!list.contains(classArray[n])) {
                int n2 = 0;
                while (n2 < classArray2.length) {
                    if (classArray2[n2].isAssignableFrom(classArray[n])) {
                        list.add(classArray[n]);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static List computeUniqueCatchList(Class[] classArray) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(class$java$lang$Error == null ? (class$java$lang$Error = ProxyGenerator.class$("java.lang.Error")) : class$java$lang$Error);
        arrayList.add(class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = ProxyGenerator.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException);
        int n = 0;
        while (n < classArray.length) {
            block6: {
                Class clazz = classArray[n];
                if (clazz.isAssignableFrom(class$java$lang$Throwable == null ? ProxyGenerator.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
                    arrayList.clear();
                    break;
                }
                if ((class$java$lang$Throwable == null ? ProxyGenerator.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(clazz)) {
                    int n2 = 0;
                    while (n2 < arrayList.size()) {
                        Class clazz2 = (Class)arrayList.get(n2);
                        if (!clazz2.isAssignableFrom(clazz)) {
                            if (clazz.isAssignableFrom(clazz2)) {
                                arrayList.remove(n2);
                                continue;
                            }
                            ++n2;
                            continue;
                        }
                        break block6;
                    }
                    arrayList.add(clazz);
                }
            }
            ++n;
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            hashCodeMethod = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object).getMethod("hashCode", null);
            equalsMethod = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object});
            toStringMethod = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object).getMethod("toString", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    private static class ConstantPool {
        private List pool = new ArrayList(32);
        private Map map = new HashMap(16);
        private boolean readOnly = false;

        private ConstantPool() {
        }

        public short getUtf8(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return this.getValue(string);
        }

        public short getInteger(int n) {
            return this.getValue(new Integer(n));
        }

        public short getFloat(float f) {
            return this.getValue(new Float(f));
        }

        public short getLong(long l) {
            return this.getValue(new Long(l));
        }

        public short getDouble(double d) {
            return this.getValue(new Double(d));
        }

        public short getClass(String string) {
            short s = this.getUtf8(string);
            return this.getIndirect(new IndirectEntry(7, s));
        }

        public short getString(String string) {
            short s = this.getUtf8(string);
            return this.getIndirect(new IndirectEntry(8, s));
        }

        public short getFieldRef(String string, String string2, String string3) {
            short s = this.getClass(string);
            short s2 = this.getNameAndType(string2, string3);
            return this.getIndirect(new IndirectEntry(9, s, s2));
        }

        public short getMethodRef(String string, String string2, String string3) {
            short s = this.getClass(string);
            short s2 = this.getNameAndType(string2, string3);
            return this.getIndirect(new IndirectEntry(10, s, s2));
        }

        public short getInterfaceMethodRef(String string, String string2, String string3) {
            short s = this.getClass(string);
            short s2 = this.getNameAndType(string2, string3);
            return this.getIndirect(new IndirectEntry(11, s, s2));
        }

        public short getNameAndType(String string, String string2) {
            short s = this.getUtf8(string);
            short s2 = this.getUtf8(string2);
            return this.getIndirect(new IndirectEntry(12, s, s2));
        }

        public void setReadOnly() {
            this.readOnly = true;
        }

        public void write(OutputStream outputStream) throws IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeShort(this.pool.size() + 1);
            Iterator iterator = this.pool.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                entry.write(dataOutputStream);
            }
        }

        private short addEntry(Entry entry) {
            this.pool.add(entry);
            return (short)this.pool.size();
        }

        private short getValue(Object object) {
            Short s = (Short)this.map.get(object);
            if (s != null) {
                return s;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition: " + object);
            }
            short s2 = this.addEntry(new ValueEntry(object));
            this.map.put(object, new Short(s2));
            return s2;
        }

        private short getIndirect(IndirectEntry indirectEntry) {
            Short s = (Short)this.map.get(indirectEntry);
            if (s != null) {
                return s;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition");
            }
            short s2 = this.addEntry(indirectEntry);
            this.map.put(indirectEntry, new Short(s2));
            return s2;
        }

        private static class IndirectEntry
        extends Entry {
            private int tag;
            private short index0;
            private short index1;

            public IndirectEntry(int n, short s) {
                this.tag = n;
                this.index0 = s;
                this.index1 = 0;
            }

            public IndirectEntry(int n, short s, short s2) {
                this.tag = n;
                this.index0 = s;
                this.index1 = s2;
            }

            public void write(DataOutputStream dataOutputStream) throws IOException {
                dataOutputStream.writeByte(this.tag);
                dataOutputStream.writeShort(this.index0);
                if (this.tag == 9 || this.tag == 10 || this.tag == 11 || this.tag == 12) {
                    dataOutputStream.writeShort(this.index1);
                }
            }

            public int hashCode() {
                return this.tag + this.index0 + this.index1;
            }

            public boolean equals(Object object) {
                if (object instanceof IndirectEntry) {
                    IndirectEntry indirectEntry = (IndirectEntry)object;
                    if (this.tag == indirectEntry.tag && this.index0 == indirectEntry.index0 && this.index1 == indirectEntry.index1) {
                        return true;
                    }
                }
                return false;
            }
        }

        private static class ValueEntry
        extends Entry {
            private Object value;

            public ValueEntry(Object object) {
                this.value = object;
            }

            public void write(DataOutputStream dataOutputStream) throws IOException {
                if (this.value instanceof String) {
                    dataOutputStream.writeByte(1);
                    dataOutputStream.writeUTF((String)this.value);
                } else if (this.value instanceof Integer) {
                    dataOutputStream.writeByte(3);
                    dataOutputStream.writeInt((Integer)this.value);
                } else if (this.value instanceof Float) {
                    dataOutputStream.writeByte(4);
                    dataOutputStream.writeFloat(((Float)this.value).floatValue());
                } else if (this.value instanceof Long) {
                    dataOutputStream.writeByte(5);
                    dataOutputStream.writeLong((Long)this.value);
                } else if (this.value instanceof Double) {
                    dataOutputStream.writeDouble(6.0);
                    dataOutputStream.writeDouble((Double)this.value);
                } else {
                    throw new InternalError("bogus value entry: " + this.value);
                }
            }
        }

        private static abstract class Entry {
            private Entry() {
            }

            public abstract void write(DataOutputStream var1) throws IOException;
        }
    }

    private static class PrimitiveTypeInfo {
        public String baseTypeString;
        public String wrapperClassName;
        public String wrapperConstructorDesc;
        public String unwrapMethodName;
        public String unwrapMethodDesc;
        private static Map table = new HashMap(11);

        private PrimitiveTypeInfo(String string, String string2, String string3, String string4, String string5) {
            this.baseTypeString = string;
            this.wrapperClassName = string2;
            this.wrapperConstructorDesc = string3;
            this.unwrapMethodName = string4;
            this.unwrapMethodDesc = string5;
        }

        public static PrimitiveTypeInfo get(Class clazz) {
            return (PrimitiveTypeInfo)table.get(clazz);
        }

        static {
            table.put(Integer.TYPE, new PrimitiveTypeInfo("I", "java/lang/Integer", "(I)V", "intValue", "()I"));
            table.put(Boolean.TYPE, new PrimitiveTypeInfo("Z", "java/lang/Boolean", "(Z)V", "booleanValue", "()Z"));
            table.put(Byte.TYPE, new PrimitiveTypeInfo("B", "java/lang/Byte", "(B)V", "byteValue", "()B"));
            table.put(Character.TYPE, new PrimitiveTypeInfo("C", "java/lang/Char", "(C)V", "charValue", "()C"));
            table.put(Short.TYPE, new PrimitiveTypeInfo("S", "java/lang/Short", "(S)V", "shortValue", "()S"));
            table.put(Long.TYPE, new PrimitiveTypeInfo("J", "java/lang/Long", "(J)V", "longValue", "()J"));
            table.put(Float.TYPE, new PrimitiveTypeInfo("F", "java/lang/Float", "(F)V", "floatValue", "()F"));
            table.put(Double.TYPE, new PrimitiveTypeInfo("D", "java/lang/Double", "(D)V", "doubleValue", "()D"));
        }
    }

    private class ProxyMethod {
        public String methodName;
        public Class[] parameterTypes;
        public Class returnType;
        public Class[] exceptionTypes;
        public Class fromClass;
        public String methodFieldName;

        private ProxyMethod(String string, Class[] classArray, Class clazz, Class[] classArray2, Class clazz2, String string2) {
            this.methodName = string;
            this.parameterTypes = classArray;
            this.returnType = clazz;
            this.exceptionTypes = classArray2;
            this.fromClass = clazz2;
            this.methodFieldName = string2;
        }

        private MethodInfo generateMethod() throws IOException {
            short s;
            String string = ProxyGenerator.getMethodDescriptor(this.parameterTypes, this.returnType);
            MethodInfo methodInfo = new MethodInfo(this.methodName, string, 17);
            int[] nArray = new int[this.parameterTypes.length];
            int n = 1;
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = n;
                n += ProxyGenerator.getWordsPerType(this.parameterTypes[n2]);
                ++n2;
            }
            int n3 = n;
            short s2 = 0;
            DataOutputStream dataOutputStream = new DataOutputStream(methodInfo.code);
            ProxyGenerator.this.code_aload(0, dataOutputStream);
            dataOutputStream.writeByte(180);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(ProxyGenerator.superclassName, ProxyGenerator.handlerFieldName, "Ljava/lang/reflect/InvocationHandler;"));
            ProxyGenerator.this.code_aload(0, dataOutputStream);
            dataOutputStream.writeByte(178);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(ProxyGenerator.dotToSlash(ProxyGenerator.this.className), this.methodFieldName, "Ljava/lang/reflect/Method;"));
            if (this.parameterTypes.length > 0) {
                ProxyGenerator.this.code_ipush(this.parameterTypes.length, dataOutputStream);
                dataOutputStream.writeByte(189);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass("java/lang/Object"));
                int n4 = 0;
                while (n4 < this.parameterTypes.length) {
                    dataOutputStream.writeByte(89);
                    ProxyGenerator.this.code_ipush(n4, dataOutputStream);
                    this.codeWrapArgument(this.parameterTypes[n4], nArray[n4], dataOutputStream);
                    dataOutputStream.writeByte(83);
                    ++n4;
                }
            } else {
                dataOutputStream.writeByte(1);
            }
            dataOutputStream.writeByte(185);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getInterfaceMethodRef("java/lang/reflect/InvocationHandler", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;"));
            dataOutputStream.writeByte(4);
            dataOutputStream.writeByte(0);
            if (this.returnType == Void.TYPE) {
                dataOutputStream.writeByte(87);
                dataOutputStream.writeByte(177);
            } else {
                this.codeUnwrapReturnValue(this.returnType, dataOutputStream);
            }
            short s3 = s = (short)methodInfo.code.size();
            List list = ProxyGenerator.computeUniqueCatchList(this.exceptionTypes);
            if (list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Class clazz = (Class)iterator.next();
                    methodInfo.exceptionTable.add(new ExceptionTableEntry(s2, s3, s, ProxyGenerator.this.cp.getClass(ProxyGenerator.dotToSlash(clazz.getName()))));
                }
                dataOutputStream.writeByte(191);
                s = (short)methodInfo.code.size();
                methodInfo.exceptionTable.add(new ExceptionTableEntry(s2, s3, s, ProxyGenerator.this.cp.getClass("java/lang/Throwable")));
                ProxyGenerator.this.code_astore(n3, dataOutputStream);
                dataOutputStream.writeByte(187);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass("java/lang/reflect/UndeclaredThrowableException"));
                dataOutputStream.writeByte(89);
                ProxyGenerator.this.code_aload(n3, dataOutputStream);
                dataOutputStream.writeByte(183);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef("java/lang/reflect/UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V"));
                dataOutputStream.writeByte(191);
            }
            methodInfo.maxStack = (short)10;
            methodInfo.maxLocals = (short)(n3 + 1);
            methodInfo.declaredExceptions = new short[this.exceptionTypes.length];
            int n5 = 0;
            while (n5 < this.exceptionTypes.length) {
                methodInfo.declaredExceptions[n5] = ProxyGenerator.this.cp.getClass(ProxyGenerator.dotToSlash(this.exceptionTypes[n5].getName()));
                ++n5;
            }
            return methodInfo;
        }

        private void codeWrapArgument(Class clazz, int n, DataOutputStream dataOutputStream) throws IOException {
            if (clazz.isPrimitive()) {
                PrimitiveTypeInfo primitiveTypeInfo = PrimitiveTypeInfo.get(clazz);
                dataOutputStream.writeByte(187);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass(primitiveTypeInfo.wrapperClassName));
                dataOutputStream.writeByte(89);
                if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE) {
                    ProxyGenerator.this.code_iload(n, dataOutputStream);
                } else if (clazz == Long.TYPE) {
                    ProxyGenerator.this.code_lload(n, dataOutputStream);
                } else if (clazz == Float.TYPE) {
                    ProxyGenerator.this.code_fload(n, dataOutputStream);
                } else if (clazz == Double.TYPE) {
                    ProxyGenerator.this.code_dload(n, dataOutputStream);
                } else {
                    ProxyGenerator.assert(false);
                }
                dataOutputStream.writeByte(183);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef(primitiveTypeInfo.wrapperClassName, "<init>", primitiveTypeInfo.wrapperConstructorDesc));
            } else {
                ProxyGenerator.this.code_aload(n, dataOutputStream);
            }
        }

        private void codeUnwrapReturnValue(Class clazz, DataOutputStream dataOutputStream) throws IOException {
            if (clazz.isPrimitive()) {
                PrimitiveTypeInfo primitiveTypeInfo = PrimitiveTypeInfo.get(clazz);
                dataOutputStream.writeByte(192);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass(primitiveTypeInfo.wrapperClassName));
                dataOutputStream.writeByte(182);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef(primitiveTypeInfo.wrapperClassName, primitiveTypeInfo.unwrapMethodName, primitiveTypeInfo.unwrapMethodDesc));
                if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE) {
                    dataOutputStream.writeByte(172);
                } else if (clazz == Long.TYPE) {
                    dataOutputStream.writeByte(173);
                } else if (clazz == Float.TYPE) {
                    dataOutputStream.writeByte(174);
                } else if (clazz == Double.TYPE) {
                    dataOutputStream.writeByte(175);
                } else {
                    ProxyGenerator.assert(false);
                }
            } else {
                dataOutputStream.writeByte(192);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass(ProxyGenerator.dotToSlash(clazz.getName())));
                dataOutputStream.writeByte(176);
            }
        }

        private void codeFieldInitialization(DataOutputStream dataOutputStream) throws IOException {
            ProxyGenerator.this.codeClassForName(this.fromClass, dataOutputStream);
            ProxyGenerator.this.code_ldc(ProxyGenerator.this.cp.getString(this.methodName), dataOutputStream);
            ProxyGenerator.this.code_ipush(this.parameterTypes.length, dataOutputStream);
            dataOutputStream.writeByte(189);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass("java/lang/Class"));
            int n = 0;
            while (n < this.parameterTypes.length) {
                dataOutputStream.writeByte(89);
                ProxyGenerator.this.code_ipush(n, dataOutputStream);
                if (this.parameterTypes[n].isPrimitive()) {
                    PrimitiveTypeInfo primitiveTypeInfo = PrimitiveTypeInfo.get(this.parameterTypes[n]);
                    dataOutputStream.writeByte(178);
                    dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(primitiveTypeInfo.wrapperClassName, "TYPE", "Ljava/lang/Class;"));
                } else {
                    ProxyGenerator.this.codeClassForName(this.parameterTypes[n], dataOutputStream);
                }
                dataOutputStream.writeByte(83);
                ++n;
            }
            dataOutputStream.writeByte(182);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef("java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"));
            dataOutputStream.writeByte(179);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(ProxyGenerator.dotToSlash(ProxyGenerator.this.className), this.methodFieldName, "Ljava/lang/reflect/Method;"));
        }
    }

    private class MethodInfo {
        public int accessFlags;
        public String name;
        public String descriptor;
        public short maxStack;
        public short maxLocals;
        public ByteArrayOutputStream code = new ByteArrayOutputStream();
        public List exceptionTable = new ArrayList();
        public short[] declaredExceptions;

        public MethodInfo(String string, String string2, int n) {
            this.name = string;
            this.descriptor = string2;
            this.accessFlags = n;
            ProxyGenerator.this.cp.getUtf8(string);
            ProxyGenerator.this.cp.getUtf8(string2);
            ProxyGenerator.this.cp.getUtf8("Code");
            ProxyGenerator.this.cp.getUtf8("Exceptions");
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.name));
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.descriptor));
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8("Code"));
            dataOutputStream.writeInt(12 + this.code.size() + 8 * this.exceptionTable.size());
            dataOutputStream.writeShort(this.maxStack);
            dataOutputStream.writeShort(this.maxLocals);
            dataOutputStream.writeInt(this.code.size());
            this.code.writeTo(dataOutputStream);
            dataOutputStream.writeShort(this.exceptionTable.size());
            Iterator iterator = this.exceptionTable.iterator();
            while (iterator.hasNext()) {
                ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)iterator.next();
                dataOutputStream.writeShort(exceptionTableEntry.startPc);
                dataOutputStream.writeShort(exceptionTableEntry.endPc);
                dataOutputStream.writeShort(exceptionTableEntry.handlerPc);
                dataOutputStream.writeShort(exceptionTableEntry.catchType);
            }
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8("Exceptions"));
            dataOutputStream.writeInt(2 + 2 * this.declaredExceptions.length);
            dataOutputStream.writeShort(this.declaredExceptions.length);
            int n = 0;
            while (n < this.declaredExceptions.length) {
                dataOutputStream.writeShort(this.declaredExceptions[n]);
                ++n;
            }
        }
    }

    private static class ExceptionTableEntry {
        public short startPc;
        public short endPc;
        public short handlerPc;
        public short catchType;

        public ExceptionTableEntry(short s, short s2, short s3, short s4) {
            this.startPc = s;
            this.endPc = s2;
            this.handlerPc = s3;
            this.catchType = s4;
        }
    }

    private class FieldInfo {
        public int accessFlags;
        public String name;
        public String descriptor;

        public FieldInfo(String string, String string2, int n) {
            this.name = string;
            this.descriptor = string2;
            this.accessFlags = n;
            ProxyGenerator.this.cp.getUtf8(string);
            ProxyGenerator.this.cp.getUtf8(string2);
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.name));
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.descriptor));
            dataOutputStream.writeShort(0);
        }
    }
}

