/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import sun.applet.AppletPanel;

class ClassLoaderInfo {
    private URL codebase;
    private int references = 0;
    private Hashtable jars;
    private boolean locked;
    private static boolean initialized;
    private static Hashtable infos;
    private static int zombieLimit;
    private static Vector zombies;
    private boolean localJarsLoaded = false;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        zombieLimit = Integer.getInteger("javaplugin.jar.cache.size", 100);
        if (zombieLimit > 0) {
            System.err.println("JAR cache enabled.");
        } else {
            System.err.println("JAR cache disabled.");
        }
    }

    static synchronized ClassLoaderInfo find(AppletPanel appletPanel) {
        ClassLoaderInfo.initialize();
        URL uRL = appletPanel.getCodeBase();
        ClassLoaderInfo classLoaderInfo = (ClassLoaderInfo)infos.get(uRL);
        if (classLoaderInfo == null) {
            classLoaderInfo = new ClassLoaderInfo(uRL);
            infos.put(uRL, classLoaderInfo);
        } else {
            zombies.removeElement(classLoaderInfo);
        }
        return classLoaderInfo;
    }

    synchronized void addReference() {
        ++this.references;
    }

    synchronized void removeReference() {
        --this.references;
        if (this.references < 0) {
            throw new Error("negative ref count???");
        }
        if (this.references == 0) {
            ClassLoaderInfo.addZombie(this);
        }
    }

    private static synchronized void addZombie(ClassLoaderInfo classLoaderInfo) {
        zombies.addElement(classLoaderInfo);
        if (zombies.size() > zombieLimit) {
            ClassLoaderInfo classLoaderInfo2 = (ClassLoaderInfo)zombies.elementAt(0);
            zombies.removeElementAt(0);
            infos.remove(classLoaderInfo2.codebase);
            AppletPanel.flushClassLoader((URL)classLoaderInfo2.codebase);
        }
    }

    private ClassLoaderInfo(URL uRL) {
        this.codebase = uRL;
        this.jars = new Hashtable();
    }

    synchronized void addJar(String string) {
        this.jars.put(string, string);
    }

    synchronized boolean hasJar(String string) {
        return this.jars.get(string) != null;
    }

    public boolean getLocalJarsLoaded() {
        return this.localJarsLoaded;
    }

    public void setLocalJarsLoaded(boolean bl) {
        this.localJarsLoaded = bl;
    }

    public final synchronized void lock() throws InterruptedException {
        while (this.locked) {
            this.wait();
        }
        this.locked = true;
    }

    public final synchronized void unlock() {
        this.locked = false;
        this.notifyAll();
    }

    static {
        infos = new Hashtable();
        zombies = new Vector();
    }
}

