/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;

public class AdvancedPanel
extends ActivatorSubPanel
implements ActionListener,
ItemListener,
KeyListener {
    private static boolean hideJITBox;
    private static boolean hideDebugBox;
    private MessageHandler mh = new MessageHandler("advanced");
    private JCheckBox debugButton;
    private JCheckBox jitButton;
    private JTextField debugPort;
    private JLabel debugPortLabel;
    private JLabel jitPathLabel;
    private JTextField jdkPath;
    private JTextField jitPath;
    private JComboBox jdkInstalled;
    private final String otherJDK = this.mh.getMessage("other_jdk");
    private final String defaultJRE = this.mh.getMessage("default_jdk");
    private JLabel pathLabel;
    private int jreNb;
    private int jdkNb;

    AdvancedPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mh.getMessage("jre_name")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(jPanel2);
        this.jdkInstalled = new JComboBox();
        if (this.setInstalledJavaList()) {
            this.jdkInstalled.addItemListener(this);
            jPanel2.add(this.jdkInstalled);
        }
        jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(1, 15)));
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(15, 8, 4, 4));
        this.pathLabel = new JLabel(this.mh.getMessage("path") + " ");
        jPanel3.add(this.pathLabel);
        this.jdkPath = new JTextField();
        this.jdkPath.addKeyListener(this);
        jPanel3.add(this.jdkPath);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.jitButton = new JCheckBox(this.mh.getMessage("enable_jit"));
        this.jitButton.addActionListener(this);
        jPanel4.add(this.jitButton);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 1)));
        this.jitPathLabel = new JLabel(this.mh.getMessage("jit_path"));
        jPanel4.add(this.jitPathLabel);
        this.jitPath = new JTextField(configurationInfo.getJITPath(), 8);
        this.jitPath.setAlignmentX(0.0f);
        this.jitPath.setMaximumSize(this.jitPath.getPreferredSize());
        this.jitPath.addKeyListener(this);
        jPanel4.add(this.jitPath);
        if (!hideJITBox) {
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
            jPanel.add(jPanel4);
        }
        this.debugButton = new JCheckBox(this.mh.getMessage("enable_debug"));
        this.debugButton.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel5.setBorder(BorderFactory.createTitledBorder(this.mh.getMessage("debug_settings")));
        jPanel5.add(this.debugButton);
        this.debugPortLabel = new JLabel(this.mh.getMessage("debug_port"));
        jPanel5.add(this.debugPortLabel);
        jPanel5.add(Box.createRigidArea(new Dimension(5, 1)));
        this.debugPort = new JTextField("2502", 6);
        this.debugPort.setAlignmentX(0.0f);
        this.debugPort.setMaximumSize(this.debugPort.getPreferredSize());
        this.debugPort.addKeyListener(this);
        jPanel5.add(this.debugPort);
        if (!hideDebugBox) {
            this.add(Box.createRigidArea(new Dimension(1, 5)));
            this.add(jPanel5);
        }
        this.reset();
    }

    private boolean setInstalledJavaList() {
        Object[] objectArray;
        Object object;
        if (this.jdkInstalled.getItemCount() > 0) {
            this.jdkInstalled.removeAllItems();
        }
        this.jdkInstalled.addItem(this.defaultJRE);
        String[][] stringArray = this.model.getInstalledJREList();
        this.jreNb = stringArray == null ? 0 : stringArray.length;
        int n = 0;
        while (n < this.jreNb) {
            object = stringArray[n][0];
            String string = stringArray[n][1];
            objectArray = new Object[]{object, string};
            this.jdkInstalled.addItem(MessageFormat.format(this.mh.getMessage("jre_format"), objectArray));
            ++n;
        }
        object = this.model.getInstalledJDKList();
        this.jdkNb = object == null ? 0 : ((String[][])object).length;
        int n2 = 0;
        while (n2 < this.jdkNb) {
            objectArray = object[n2][0];
            String string = object[n2][1];
            Object[] objectArray2 = new Object[]{objectArray, string};
            this.jdkInstalled.addItem(MessageFormat.format(this.mh.getMessage("jdk_format"), objectArray2));
            ++n2;
        }
        this.jdkInstalled.addItem(this.otherJDK);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.debugButton) {
            this.debugPort.setEnabled(this.debugButton.isSelected());
            this.debugPortLabel.setEnabled(this.debugButton.isSelected());
            this.debugPort.repaint();
            this.debugPortLabel.repaint();
            this.model.setDebugEnabled(this.debugButton.isSelected());
        }
        if (actionEvent.getSource() == this.jitButton) {
            boolean bl = this.jitButton.isSelected();
            this.jitPathLabel.setEnabled(bl);
            this.jitPath.setEnabled(bl);
            this.jitPath.repaint();
            this.jitPathLabel.repaint();
            this.model.setJITEnabled(bl);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.jdkInstalled) {
            String[][] stringArray;
            int n = this.jdkInstalled.getSelectedIndex();
            if (n == 0) {
                this.enableDebug(false);
                this.model.setJavaRuntime("Default");
            }
            if (n > 0 && n <= this.jreNb) {
                this.enableDebug(false);
                this.model.setJavaRuntime("JRE");
                stringArray = this.model.getInstalledJREList();
                this.model.setJavaRuntimeVersion(stringArray[n - 1][0]);
            }
            if (n > this.jreNb && n <= this.jreNb + this.jdkNb) {
                this.enableDebug(true);
                this.model.setJavaRuntime("JDK");
                stringArray = this.model.getInstalledJDKList();
                this.model.setJavaRuntimeVersion(stringArray[n - this.jreNb - 1][0]);
            }
            if (n == this.jdkInstalled.getItemCount() - 1) {
                this.enableDebug(true);
                this.model.setJavaRuntime(this.jdkPath.getText());
            }
            this.reset();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.debugPort) {
            this.model.setDebugPort(this.debugPort.getText());
        } else if (keyEvent.getSource() == this.jdkPath) {
            this.model.setJavaRuntime(this.jdkPath.getText());
        } else if (keyEvent.getSource() == this.jitPath) {
            if (this.jitPath.getText().length() != 0) {
                this.model.setJITPath(this.jitPath.getText());
            } else {
                this.model.setJITPath(null);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void reset() {
        boolean bl = this.model.isJITEnabled();
        this.jitButton.setSelected(bl);
        this.jitPath.setText(this.model.getJITPath());
        this.jitPathLabel.setEnabled(bl);
        this.jitPath.setEnabled(bl);
        boolean bl2 = this.model.isDebugEnabled();
        this.debugButton.setSelected(bl2);
        this.debugPort.setText(this.model.getDebugPort());
        this.debugPort.setEnabled(bl2);
        this.debugPortLabel.setEnabled(bl2);
        boolean bl3 = true;
        String string = this.model.getJavaRuntime();
        this.pathLabel.setEnabled(false);
        this.jdkPath.setEnabled(false);
        try {
            if (string.equalsIgnoreCase("Default")) {
                this.enableDebug(false);
                this.jdkInstalled.setSelectedIndex(0);
            } else if (string.equalsIgnoreCase("JDK")) {
                this.enableDebug(true);
                String[][] stringArray = this.model.getInstalledJDKList();
                String string2 = this.model.getJavaRuntimeVersion();
                int n = 0;
                while (!stringArray[n][0].equalsIgnoreCase(string2)) {
                    ++n;
                }
                this.jdkInstalled.setSelectedIndex(this.jreNb + n + 1);
            } else if (string.equalsIgnoreCase("JRE")) {
                this.enableDebug(false);
                String[][] stringArray = this.model.getInstalledJREList();
                String string3 = this.model.getJavaRuntimeVersion();
                int n = 0;
                while (!stringArray[n][0].equalsIgnoreCase(string3)) {
                    ++n;
                }
                this.jdkInstalled.setSelectedIndex(n + 1);
            } else {
                this.jdkInstalled.setSelectedIndex(this.jdkInstalled.getItemCount() - 1);
                this.jdkPath.setText(string);
                this.jdkPath.setEnabled(true);
                this.pathLabel.setEnabled(true);
                this.enableDebug(true);
            }
        }
        catch (Exception exception) {
            this.jdkInstalled.setSelectedIndex(0);
            this.model.firePropertyChange();
        }
    }

    public static void setHideJITBox(boolean bl) {
        hideJITBox = bl;
    }

    public static void setHideDebugBox(boolean bl) {
        hideDebugBox = bl;
    }

    private void enableDebug(boolean bl) {
        this.debugButton.setEnabled(bl);
        this.debugPort.setEnabled(bl);
        if (!bl) {
            this.model.setDebugEnabled(false);
            this.debugButton.setSelected(false);
        }
    }
}

