/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.cert.internal.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;

public class X509V1CertImpl
extends X509Certificate
implements Serializable {
    static final long serialVersionUID = -2048442350420423405L;
    private java.security.cert.X509Certificate wrappedCert;

    public X509V1CertImpl() {
    }

    public X509V1CertImpl(InputStream inputStream) throws CertificateException {
        try {
            this.wrappedCert = (java.security.cert.X509Certificate)X509V1CertImpl.getFactory().generateCertificate(inputStream);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }

    public X509V1CertImpl(byte[] byArray) throws CertificateException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.wrappedCert = (java.security.cert.X509Certificate)X509V1CertImpl.getFactory().generateCertificate(byteArrayInputStream);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            this.wrappedCert.checkValidity(date);
        }
        catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
            throw new CertificateNotYetValidException(certificateNotYetValidException.getMessage());
        }
        catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
            throw new CertificateExpiredException(certificateExpiredException.getMessage());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.wrappedCert.getEncoded();
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
            throw new CertificateEncodingException(certificateEncodingException.getMessage());
        }
    }

    private static synchronized CertificateFactory getFactory() throws java.security.cert.CertificateException {
        return CertificateFactory.getInstance("X.509");
    }

    public Principal getIssuerDN() {
        return this.wrappedCert.getIssuerDN();
    }

    public Date getNotAfter() {
        return this.wrappedCert.getNotAfter();
    }

    public Date getNotBefore() {
        return this.wrappedCert.getNotBefore();
    }

    public PublicKey getPublicKey() {
        PublicKey publicKey = this.wrappedCert.getPublicKey();
        return publicKey;
    }

    public BigInteger getSerialNumber() {
        return this.wrappedCert.getSerialNumber();
    }

    public String getSigAlgName() {
        return this.wrappedCert.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.wrappedCert.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.wrappedCert.getSigAlgParams();
    }

    public Principal getSubjectDN() {
        return this.wrappedCert.getSubjectDN();
    }

    public int getVersion() {
        return this.wrappedCert.getVersion();
    }

    public java.security.cert.X509Certificate getX509Certificate() {
        return this.wrappedCert;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.wrappedCert = (java.security.cert.X509Certificate)X509V1CertImpl.getFactory().generateCertificate(objectInputStream);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new IOException("generateCertificate failed: " + certificateException.getMessage());
        }
    }

    public String toString() {
        return this.wrappedCert.toString();
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.wrappedCert.verify(publicKey);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.wrappedCert.verify(publicKey, string);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.write(this.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException("getEncoded failed: " + certificateEncodingException.getMessage());
        }
    }
}

