unit DECENC32;

interface

const
  PROMPT_ALL = 0;        // DLL prompts for everything
  PROMPT_NONE = 1;       // No prompts, file names passed in are used
  PROMPT_OVERWRITE = 2;  // DLL only prompts for overwrites

  NONE_TYPE = 0;         // Returned from decoding routine
  UUE_TYPE = 1;          // DLL prompts for everything
  MIME_TYPE = 2;         // No prompts, file names passed in are used
  BINHEX_TYPE = 3;       // BinHex (Macintosh) encoding
  XXE_TYPE = 4;          // XXENCODED file
  TEXT_TYPE = 5;         // 7-bit or quoted-printable - encoding quoted-printable

Function GetNumFilesToDecode(strInFile : String) : LongInt; stdcall;
Function GetEncodedFile(strOutFile : String; nIndex : LongInt) : LongInt; stdcall;
Function DecodeFile(strInFile : String; strOutFile : String; nPrompts : LongInt) : LongInt; stdcall;
Function EncodeFile(SourceFile : String; EncodedFile : String; strBoundary : String; CodeOption : LongInt; xAppend : LongInt) : LongInt; stdcall;
Procedure FinishAttachments(strFileOut : String); stdcall;
Procedure SetEncodingApplication(strInFile : String); stdcall;
Function GetUniqueFileName(szFileName : String) : Boolean; stdcall;
Function ConcatenateRelated(bDeleteOthers : LongInt; szFileName : String) : Boolean; stdcall;
Function SplitFile(szFileName : String; lFileSize : LongInt) : Boolean; stdcall;
Function EncodeBuffer(pBufferIn : String; pBufferOut : String; nInBufferSize : LongInt; nType : LongInt) : LongInt; stdcall;
Function DecodeBuffer(pBufferIn : String; pBufferOut : String; nInBufferSize : LongInt; nType : LongInt) : LongInt; stdcall;
Function GetMessageText(szFileName : String; szTargetFileName : String) : LongInt; stdcall;

implementation

const
  DECENC32DLL = 'DECENC32.dll';

// '/* How many files are encoded */
// 'int WINAPI GetNumFilesToDecode(LPCSTR szInFile);
// Declare Function GetNumFilesToDecode Lib "decenc32.dll" (ByVal strInFile As String) As Long
Function GetNumFilesToDecode; external DECENC32DLL name 'GetNumFilesToDecode';

// '/* 0 relative index into the array of names (see call above) */
// 'int WINAPI GetEncodedFile(LPSTR szOutFile, int nIndex);
// Declare Function GetEncodedFile Lib "decenc32.dll" (ByVal strOutFile As String, ByVal nIndex As Long) As Long
Function GetEncodedFile; external DECENC32DLL name 'GetEncodedFile';

// '/* If PROMPT_NONE is used for nPrompt, the names of the files to decode are assumed to be in
// '   the strOutFile parameter.  That can be accomplished by calling GetNumFilesToDecode()
// '   and GetEncodedFile in a loop to get the list of files first. The list of files passed
// '   (after modification if needed) must then be delimited by the ';' character */
// '/* Return code is one of the Encoding types above */
// 'int WINAPI DecodeFile(LPCSTR strInFile, LPCSTR szOutFile, int nPrompts);
// Declare Function DecodeFile Lib "decenc32.dll" (ByVal strInFile As String, ByVal strOutFile As String, ByVal nPrompts As Long) As Long
Function DecodeFile; external DECENC32DLL name 'DecodeFile';

// '/* nAppend should be 0 to overwrite the output file, 1 to append (to encode more than one file
// '   for example */
// '/* Boundary should be passed in.  It needs to be listed in the message header as:
// '    boundary="<your boundary>" */
// 'int WINAPI EncodeFile(LPCSTR strFileIn, LPCSTR szFileOut, LPCTSTR szBoundary, int nType, BOOL bAppend);
// Declare Function EncodeFile Lib "decenc32.dll" (ByVal SourceFile As String, ByVal EncodedFile As String, ByVal strBoundary As String, ByVal CodeOption As Long, ByVal xAppend As Long) As Long
Function EncodeFile; external DECENC32DLL name 'EncodeFile';

// '/* Call after all files are encoded to append the final boundary */
// '/* You can also append -- and 2 linefeeds to the end of the encoded file or */
// '/* send that out with your message */
// 'void WINAPI FinishAttachments(LPCSTR strFileOut);
// Declare Sub FinishAttachments Lib "decenc32.dll" (ByVal strFileOut As String)
Procedure FinishAttachments; external DECENC32DLL name 'FinishAttachments';

// '/* call with the name of registered application to write that to the encoded file */
// 'void WINAPI SetEncodingApplication(LPCSTR szInFile);
// Declare Sub SetEncodingApplication Lib "decenc32.dll" (ByVal strInFile As String)
Procedure SetEncodingApplication; external DECENC32DLL name 'SetEncodingApplication';

// '/* Utility functions */
// '/* This function will return TRUE if the name of the file had to be changed to avoid an overwrite */
// 'BOOL WINAPI GetUniqueFileName(LPSTR szFileName);
// Declare Function GetUniqueFileName Lib "decenc32.dll" (ByVal szFileName As String) As Long
Function GetUniqueFileName; external DECENC32DLL name 'GetUniqueFileName';

// '/* This function will concatenate related files into the first one.  All files must
// '   be found in the same directory.
// '   For example: file1.dat, file2.dat, file3.dat will be concatenated into file1.dat
// '   If bDeleteOthers is TRUE, file2.dat and file3.dat are deleted
// '   This function returns TRUE when successful, FALSE otherwise
// '*/
// 'BOOL WINAPI ConcatenateRelated(BOOL bDeleteOthers, LPSTR szFileName);
// Declare Function ConcatenateRelated Lib "decenc32.dll" (ByVal bDeleteOthers As Long, ByVal szFileName As String) As Long
Function ConcatenateRelated; external DECENC32DLL name 'ConcatenateRelated';

// '/* This function will split a file into as many smaller files as necessary
// '   For example: file.dat of size 100000 will be split into
// '   file1.dat (size 35000), file2.dat(35000), file3.dat(size 30000)
// '   if 35000 is used for the lFileSize parameter
// '   This function returns TRUE when successful, FALSE otherwise
// '*/
// 'BOOL WINAPI SplitFile(LPSTR szFileName, long lFileSize);
// Declare Function SplitFile Lib "decenc32.dll" (ByVal szFileName As String, ByVal lFileSize As Long) As Long
Function SplitFile; external DECENC32DLL name 'SplitFile';

// '/* Use this function to encode a small buffer. The Output Buffer needs to be
// '   different than the input buffer and needs to be roughly 1.5 times larger
// '   Only UUE_TYPE, B64_TYPE and XXE_TYPE types are supported.
// '*/
// 'int WINAPI EncodeBuffer(LPCSTR pBufferIn, LPSTR pBufferOut, int nInBufferSize, int nType);
// Declare Function EncodeBuffer Lib "decenc32.dll" (ByVal pBufferIn As String, ByVal pBufferOut As String, ByVal nInBufferSize As Long, ByVal nType As Long) As Long
Function EncodeBuffer; external DECENC32DLL name 'EncodeBuffer';

// '/* Use this function to decode a small buffer. The Output Buffer needs to be
// '   different than the input buffer and needs to be about the same size.
// '   Only UUE_TYPE, B64_TYPE and XXE_TYPE types are supported.
// '*/
// 'int WINAPI DecodeBuffer(LPCSTR pBufferIn, LPSTR pBufferOut, int nInBufferSize, int nType);
// Declare Function DecodeBuffer Lib "decenc32.dll" (ByVal pBufferIn As String, ByVal pBufferOut As String, ByVal nInBufferSize As Long, ByVal nType As Long) As Long
Function DecodeBuffer; external DECENC32DLL name 'DecodeBuffer';

// '/* Use this function to save just the text of a message to a file */
// '/* Return code is one of the Encoding types above if successful */
// 'int  WINAPI GetMessageText(LPCTSTR szFileName, LPCTSTR szTargetFileName);
// Declare Function GetMessageText Lib "decenc32.dll" (ByVal szFileName As String, ByVal szTargetFileName As String) As Long
Function GetMessageText; external DECENC32DLL name 'GetMessageText';

end.
