unit msmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DECENC32, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Decode1: TMenuItem;
    ALLPrompts1: TMenuItem;
    OverwritePromptOnly1: TMenuItem;
    ShowFileNames1: TMenuItem;
    Encode1: TMenuItem;
    MIMEBase641: TMenuItem;
    UUENCODED1: TMenuItem;
    XXENCODED1: TMenuItem;
    BinHexMacintosh1: TMenuItem;
    Quotedprintable1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Util1: TMenuItem;
    SplitFile1: TMenuItem;
    ConcatenateFiles1: TMenuItem;
    EncodeBuffer1: TMenuItem;
    ShowMessageHeaders1: TMenuItem;
    Help1: TMenuItem;
    Aboutmstest1: TMenuItem;
    OpenDialog1: TOpenDialog;
    procedure ALLPrompts1Click(Sender: TObject);
    procedure OverwritePromptOnly1Click(Sender: TObject);
    procedure MIMEBase641Click(Sender: TObject);
    procedure UUENCODED1Click(Sender: TObject);
    procedure XXENCODED1Click(Sender: TObject);
    procedure BinHexMacintosh1Click(Sender: TObject);
    procedure Quotedprintable1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation


{$R *.DFM}


procedure TForm1.ALLPrompts1Click(Sender: TObject);

var
  FileToDecode : String;
  DecodedFile : String;

begin
  OpenDialog1.Filter := 'AllFiles (*.*)|*.*';
  OpenDialog1.Execute;
  FileToDecode := OpenDialog1.FileName;

  DecodeFile(FileToDecode, DecodedFile, PROMPT_ALL);
end;

procedure TForm1.OverwritePromptOnly1Click(Sender: TObject);

var
  FileToDecode : String;
  DecodedFile : String;

begin
  OpenDialog1.Filter := 'AllFiles (*.*)|*.*';
  OpenDialog1.Execute;
  FileToDecode := OpenDialog1.FileName;

  DecodeFile(FileToDecode, DecodedFile, PROMPT_OVERWRITE);
end;

procedure TForm1.MIMEBase641Click(Sender: TObject);

var
  FileToEncode : String;
  EncodedFile : String;
  EncodingApp : String;

begin
    EncodingApp := 'Delphi Test Application';
    SetEncodingApplication(EncodingApp);

    OpenDialog1.Filter := 'AllFiles (*.*)|*.*';
    OpenDialog1.Execute;
    FileToEncode := OpenDialog1.FileName;

    EncodedFile := Copy(FileToEncode, 1, Pos('.', FileToEncode)) + 'MIM';

    EncodeFile(FileToEncode, EncodedFile, '-----Boundary-122098-----', MIME_TYPE, 0);

    FinishAttachments(EncodedFile);
end;


procedure TForm1.UUENCODED1Click(Sender: TObject);

var
  FileToEncode : String;
  EncodedFile : String;

begin
  OpenDialog1.Filter := 'AllFiles (*.*)|*.*';
  OpenDialog1.Execute;
  FileToEncode := OpenDialog1.FileName;

  EncodedFile := Copy(FileToEncode, 1, Pos('.', FileToEncode)) + 'UUE';

  EncodeFile(FileToEncode, EncodedFile, '-----Boundary-122098-----', UUE_TYPE, 0);

  FinishAttachments(EncodedFile);
end;

procedure TForm1.XXENCODED1Click(Sender: TObject);

var
  FileToEncode : String;
  EncodedFile : String;

begin
  OpenDialog1.Filter := 'AllFiles (*.*)|*.*';
  OpenDialog1.Execute;
  FileToEncode := OpenDialog1.FileName;

  EncodedFile := Copy(FileToEncode, 1, Pos('.', FileToEncode)) + 'XXE';

  EncodeFile(FileToEncode, EncodedFile, '-----Boundary-122098-----', XXE_TYPE, 0);

  FinishAttachments(EncodedFile);
end;

procedure TForm1.BinHexMacintosh1Click(Sender: TObject);

var
  FileToEncode : String;
  EncodedFile : String;

begin
  OpenDialog1.Filter := 'AllFiles (*.*)|*.*';
  OpenDialog1.Execute;
  FileToEncode := OpenDialog1.FileName;

  EncodedFile := Copy(FileToEncode, 1, Pos('.', FileToEncode)) + 'HQX';

  EncodeFile(FileToEncode, EncodedFile, '-----Boundary-122098-----', BINHEX_TYPE, 0);

  FinishAttachments(EncodedFile);
end;

procedure TForm1.Quotedprintable1Click(Sender: TObject);

var
  FileToEncode : String;
  EncodedFile : String;

begin
  OpenDialog1.Filter := 'AllFiles (*.*)|*.*';
  OpenDialog1.Execute;
  FileToEncode := OpenDialog1.FileName;

  EncodedFile := Copy(FileToEncode, 1, Pos('.', FileToEncode)) + 'QP';

  EncodeFile(FileToEncode, EncodedFile, '-----Boundary-122098-----', TEXT_TYPE, 0);

  FinishAttachments(EncodedFile);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Application.Terminate;
end;

end.
