/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;

class PanelGenerator
extends Panel
implements ActionListener,
ItemListener,
Messages,
KeyListener {
    final short NONE = 0;
    final short SINGLE = 1;
    final short TAGGED = 2;
    final short FOLDER = 3;
    Frame frame;
    TextField fieldDir;
    TextField fieldName;
    DButton buttonMake;
    DButton buttonCancel;
    DLabel labelTitle;
    DLabel labelSource;
    Label labelName;
    Label labelPath;
    String htmlFile = null;
    String htmlName = "generated.htm";
    String htmlDir = "";
    int Mode = 0;
    String message = "";
    ActionListener actionListener = null;
    int action = 0;

    public PanelGenerator(Frame frame) {
        this.setVisible(false);
        this.setLayout(new BorderLayout());
        this.frame = frame;
        EmptyPanel emptyPanel = new EmptyPanel();
        emptyPanel.setBounds(0, 0, 450, 270);
        this.add((Component)emptyPanel, "North");
        Font font = new Font("Dialog", 1, 16);
        this.labelTitle = new DLabel();
        this.labelTitle.setBounds(64, 16, 320, 32);
        this.labelTitle.setFont(new Font("SansSerif", 1, 24));
        this.labelTitle.setTextColor(((Component)frame).getBackground().darker());
        emptyPanel.add(this.labelTitle);
        this.labelSource = new DLabel();
        this.labelSource.setBounds(16, 60, 420, 24);
        this.labelSource.setFont(font);
        emptyPanel.add(this.labelSource);
        this.labelPath = new Label("Path");
        this.labelPath.setBounds(16, 92, 128, 20);
        emptyPanel.add(this.labelPath);
        this.fieldDir = new TextField();
        this.fieldDir.setBounds(16, 115, 360, 24);
        this.fieldDir.addKeyListener(this);
        emptyPanel.add(this.fieldDir);
        this.labelName = new Label("Name");
        this.labelName.setBounds(16, 148, 128, 20);
        emptyPanel.add(this.labelName);
        this.fieldName = new TextField();
        this.fieldName.setBounds(16, 171, 256, 24);
        this.fieldName.addKeyListener(this);
        emptyPanel.add(this.fieldName);
        this.buttonCancel = new DButton("Cancel", true);
        this.buttonCancel.setBounds(100, 216, 100, 32);
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.setTip("Return to the target panel");
        emptyPanel.add(this.buttonCancel);
        this.buttonMake = new DButton("Make", true);
        this.buttonMake.setBounds(220, 216, 100, 32);
        this.buttonMake.addActionListener(this);
        emptyPanel.add(this.buttonMake);
    }

    void setAction(String string) {
        this.buttonMake.setTip(string);
    }

    void setTitle(String string) {
        this.labelTitle.setText(string);
    }

    void setMakeEnabled(boolean bl) {
        this.buttonMake.setEnabled(bl);
    }

    void setSource(String string) {
        this.labelSource.setText(string);
    }

    public String getSource() {
        return this.labelSource.getText();
    }

    void setDir(String string) {
        this.fieldDir.setText(string);
        this.htmlDir = string;
    }

    String getDir(String string) {
        if (this.htmlDir == null || this.htmlDir == "") {
            return string;
        }
        return this.getDir();
    }

    String getDir() {
        return this.htmlDir;
    }

    void makeFile() {
        this.htmlFile = Path.merge(this.htmlDir, this.htmlName);
    }

    String getFile() {
        return this.htmlFile;
    }

    void setFilename(String string) {
        this.htmlName = string;
        this.fieldName.setText(string);
    }

    String getFilename() {
        return this.fieldName.getText();
    }

    public void init(DirManager dirManager, DirManager dirManager2, boolean bl) {
        String string = null;
        String string2 = null;
        String string3 = dirManager.getDir();
        int[] nArray = dirManager.getSelectedIndexes();
        this.Mode = 0;
        this.buttonMake.setEnabled(true);
        switch (nArray.length) {
            case 1: {
                string2 = dirManager.getSelected();
                string = Path.merge(string3, string2);
                File file = new File(string3, string2);
                if (file.isDirectory()) {
                    this.Mode = 3;
                    break;
                }
                this.Mode = 1;
                break;
            }
            case 0: {
                if (bl) {
                    dirManager.selectAll();
                } else {
                    this.buttonMake.setEnabled(false);
                    string = "Select some file please";
                    this.dispTip(string);
                    break;
                }
            }
            default: {
                this.Mode = 2;
                string = String.valueOf(new StringBuffer(String.valueOf(string3)).append(File.separator).append("[TAGGED LIST]"));
            }
        }
        this.setSource(string);
        this.setDir(dirManager.getDir());
        this.setFilename(this.htmlName);
        this.makeFile();
    }

    void message(String string) {
        this.message = string;
        this.sourceActionEvent(0);
    }

    void dispTip(String string) {
        this.message = string;
        this.sourceActionEvent(1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonMake) {
            this.htmlDir = this.fieldDir.getText();
            this.htmlName = this.fieldName.getText();
            this.makeFile();
            this.sourceActionEvent(10);
            return;
        }
        if (object == this.buttonCancel) {
            this.sourceActionEvent(11);
            return;
        }
    }

    protected void sourceActionEvent(int n) {
        if (this.actionListener == null) {
            return;
        }
        this.action = n;
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, null));
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c;
        if (keyEvent.isControlDown() || keyEvent.isAltDown()) {
            return;
        }
        char c2 = keyEvent.getKeyChar();
        if (c2 != (c = new Character(c2).charValue())) {
            keyEvent.consume();
        }
        keyEvent.setKeyChar(c);
    }
}

