/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.persistence.sql;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.reflect.Field;
import org.nakedobjects.object.reflect.NakedClassException;
import org.nakedobjects.persistence.sql.DatabaseAccess;
import org.nakedobjects.persistence.sql.MapperDefinition;
import org.nakedobjects.persistence.sql.SimpleSqlObjectMapper;
import org.nakedobjects.persistence.sql.SqlObjectStore;
import org.nakedobjects.utility.ConfigurationParameters;

public class DatabaseInitialisation
extends DatabaseAccess {
    private static final Logger LOG = Logger.getLogger((Class)(class$org$nakedobjects$persistence$sql$DatabaseInitialisation == null ? (class$org$nakedobjects$persistence$sql$DatabaseInitialisation = DatabaseInitialisation.class$("org.nakedobjects.persistence.sql.DatabaseInitialisation")) : class$org$nakedobjects$persistence$sql$DatabaseInitialisation));
    private SqlObjectStore objectStore;
    static /* synthetic */ Class class$org$nakedobjects$persistence$sql$DatabaseInitialisation;

    public DatabaseInitialisation(SqlObjectStore sqlObjectStore) {
        super(sqlObjectStore);
        this.objectStore = sqlObjectStore;
    }

    public void init() throws ObjectStoreException {
        if (!this.databaseContainsTable("no_ids")) {
            this.execute("create table no_ids (id INTEGER)");
            this.execute("insert into no_ids values (1)");
        }
        this.createMappers(this.readMappings());
    }

    private Hashtable readMappings() {
        Properties properties = null;
        String string = "nakedobjects.sql-object-store.map.";
        int n = string.length();
        ConfigurationParameters configurationParameters = ConfigurationParameters.getInstance();
        properties = configurationParameters.getProperties();
        Enumeration enumeration = ((Hashtable)properties).keys();
        Hashtable<String, MapperDefinition> hashtable = new Hashtable<String, MapperDefinition>();
        while (enumeration.hasMoreElements()) {
            MapperDefinition mapperDefinition;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = (String)((Hashtable)properties).get(string2);
            String string4 = string2.substring(n, string2.indexOf(46, n));
            if (hashtable.containsKey(string4)) {
                mapperDefinition = (MapperDefinition)hashtable.get(string4);
            } else {
                mapperDefinition = new MapperDefinition();
                mapperDefinition.name = string4;
                hashtable.put(string4, mapperDefinition);
            }
            String string5 = string2.substring(string2.indexOf(46, n) + 1);
            if (string5.startsWith("column")) {
                String string6 = string2.substring(string2.lastIndexOf(46) + 1);
                mapperDefinition.add(string6, string3);
                continue;
            }
            if (string5.equals("class")) {
                mapperDefinition.className = string3;
                continue;
            }
            if (string5.equals("table")) {
                mapperDefinition.tableName = string3;
                continue;
            }
            if (string5.equals("key")) {
                mapperDefinition.keyColumn = string3;
                continue;
            }
            LOG.error((Object)("Invalid database property: " + string2));
        }
        return hashtable;
    }

    private void createMappers(Hashtable hashtable) throws ObjectStoreException {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            MapperDefinition mapperDefinition = (MapperDefinition)enumeration.nextElement();
            if (!this.databaseContainsTable(mapperDefinition.tableName)) {
                throw new ObjectStoreException("Can't find " + mapperDefinition.tableName + " table for " + mapperDefinition.name + " mapping.");
            }
            NakedClass nakedClass = NakedClass.getNakedClass(mapperDefinition.className);
            String[] stringArray = mapperDefinition.getFields();
            Field[] fieldArray = new Field[stringArray.length];
            try {
                int n = 0;
                while (n < stringArray.length) {
                    fieldArray[n] = nakedClass.getField(stringArray[n]);
                    ++n;
                }
            }
            catch (NakedClassException nakedClassException) {
                throw new ObjectStoreException("Invalid mapping for " + mapperDefinition.name + " map: " + nakedClassException.getMessage());
            }
            SimpleSqlObjectMapper simpleSqlObjectMapper = new SimpleSqlObjectMapper(nakedClass, this.objectStore, fieldArray, mapperDefinition.tableName, mapperDefinition.getColumns(), mapperDefinition.keyColumn, false);
            this.objectStore.addMapper(simpleSqlObjectMapper);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

