/*
 * Decompiled with CFR 0.152.
 */
package painter;

import dialog.DGif;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import painter.BitUtils;
import painter.ImageDescriptor;
import painter.LZWCompressor;
import painter.ScreenDescriptor;

public class GIFEncoder {
    short width_;
    short height_;
    int numColors_;
    byte[] pixels_;
    byte[] colors_;
    ScreenDescriptor sd_;
    ImageDescriptor id_;

    public GIFEncoder(Image image) {
        int n;
        this.width_ = (short)image.getWidth(null);
        this.height_ = (short)image.getHeight(null);
        int[] nArray = new int[this.width_ * this.height_];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, (int)this.width_, (int)this.height_, nArray, 0, (int)this.width_);
        try {
            if (!pixelGrabber.grabPixels()) {
                System.out.println(pixelGrabber.status());
            }
        }
        catch (InterruptedException interruptedException) {}
        byte[][] byArray = new byte[this.width_][this.height_];
        byte[][] byArray2 = new byte[this.width_][this.height_];
        byte[][] byArray3 = new byte[this.width_][this.height_];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.height_) {
            n = 0;
            while (n < this.width_) {
                byArray[n][n3] = (byte)(nArray[n2] >> 16 & 0xFF);
                byArray2[n][n3] = (byte)(nArray[n2] >> 8 & 0xFF);
                byArray3[n][n3] = (byte)(nArray[n2] & 0xFF);
                ++n2;
                ++n;
            }
            ++n3;
        }
        this.pixels_ = new byte[this.width_ * this.height_];
        this.colors_ = new byte[768];
        n = 0;
        int n4 = 0;
        while (n4 < this.width_) {
            int n5 = 0;
            while (n5 < this.height_) {
                int n6 = 0;
                while (n6 < n) {
                    if (this.colors_[n6 * 3] == byArray[n4][n5] && this.colors_[n6 * 3 + 1] == byArray2[n4][n5] && this.colors_[n6 * 3 + 2] == byArray3[n4][n5]) break;
                    ++n6;
                }
                if (n6 > 255) {
                    DGif dGif = new DGif();
                    dGif.TooManyColors();
                    return;
                }
                this.pixels_[n5 * this.width_ + n4] = (byte)n6;
                if (n6 == n) {
                    this.colors_[n6 * 3] = byArray[n4][n5];
                    this.colors_[n6 * 3 + 1] = byArray2[n4][n5];
                    this.colors_[n6 * 3 + 2] = byArray3[n4][n5];
                    ++n;
                }
                ++n5;
            }
            ++n4;
        }
        this.numColors_ = 1 << BitUtils.BitsNeeded(n);
        byte[] byArray4 = new byte[this.numColors_ * 3];
        System.arraycopy(this.colors_, 0, byArray4, 0, this.numColors_ * 3);
        this.colors_ = byArray4;
    }

    public void Write(OutputStream outputStream) throws IOException {
        BitUtils.WriteString(outputStream, "GIF87a");
        ScreenDescriptor screenDescriptor = new ScreenDescriptor(this.width_, this.height_, this.numColors_);
        screenDescriptor.Write(outputStream);
        outputStream.write(this.colors_, 0, this.colors_.length);
        ImageDescriptor imageDescriptor = new ImageDescriptor(this.width_, this.height_, ',');
        imageDescriptor.Write(outputStream);
        byte by = BitUtils.BitsNeeded(this.numColors_);
        if (by == 1) {
            by = (byte)(by + 1);
        }
        outputStream.write(by);
        LZWCompressor.LZWCompress(outputStream, by, this.pixels_);
        outputStream.write(0);
        imageDescriptor = new ImageDescriptor(0, 0, ';');
        imageDescriptor.Write(outputStream);
        outputStream.flush();
    }
}

