/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import java.awt.Color;

public class HtmlEncoder {
    private static final String[] htmlCode = new String[256];

    private HtmlEncoder() {
    }

    public static String encode(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            try {
                stringBuffer.append(htmlCode[c2]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                stringBuffer.append(c2);
            }
            ++n3;
        }
        return stringBuffer.toString().trim();
    }

    public static String encode(Color color) {
        StringBuffer stringBuffer = new StringBuffer("#");
        if (color.getRed() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(color.getRed(), 16));
        if (color.getGreen() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(color.getGreen(), 16));
        if (color.getBlue() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(color.getBlue(), 16));
        return stringBuffer.toString();
    }

    public static String getAlignment(int n2) {
        switch (n2) {
            case 0: {
                return "Left";
            }
            case 1: {
                return "Center";
            }
            case 2: {
                return "Right";
            }
            case 3: {
                return "Justify";
            }
            case 4: {
                return "Top";
            }
            case 5: {
                return "Middle";
            }
            case 6: {
                return "Bottom";
            }
            case 7: {
                return "Baseline";
            }
        }
        return "";
    }

    static {
        int n2 = 0;
        while (n2 < 10) {
            HtmlEncoder.htmlCode[n2] = "&#00" + n2 + ";";
            ++n2;
        }
        int n3 = 10;
        while (n3 < 32) {
            HtmlEncoder.htmlCode[n3] = "&#0" + n3 + ";";
            ++n3;
        }
        int n4 = 32;
        while (n4 < 128) {
            HtmlEncoder.htmlCode[n4] = String.valueOf((char)n4);
            ++n4;
        }
        HtmlEncoder.htmlCode[9] = "\t";
        HtmlEncoder.htmlCode[10] = "<br />\n";
        HtmlEncoder.htmlCode[34] = "&quot;";
        HtmlEncoder.htmlCode[38] = "&amp;";
        HtmlEncoder.htmlCode[60] = "&lt;";
        HtmlEncoder.htmlCode[62] = "&gt;";
        int n5 = 128;
        while (n5 < 256) {
            HtmlEncoder.htmlCode[n5] = "&#" + n5 + ";";
            ++n5;
        }
    }
}

