/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfLine;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ColumnText {
    public static final float GLOBAL_SPACE_CHAR_RATIO = 0.0f;
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected static final int LINE_STATUS_OK = 0;
    protected static final int LINE_STATUS_OFFLIMITS = 1;
    protected static final int LINE_STATUS_NOLINE = 2;
    protected float maxY;
    protected float minY;
    protected int alignment = 0;
    protected ArrayList leftWall;
    protected ArrayList rightWall;
    protected ArrayList chunks = new ArrayList();
    protected float yLine;
    protected float currentLeading = 16.0f;
    protected float fixedLeading = 16.0f;
    protected float multipliedLeading = 0.0f;
    protected PdfContentByte text;
    protected int lineStatus;
    protected float indent = 0.0f;
    protected float followingIndent = 0.0f;
    protected float rightIndent = 0.0f;
    protected float extraParagraphSpace = 0.0f;
    protected int currentChunkMarker = -1;
    protected PdfChunk currentStandbyChunk;
    protected String splittedChunkText;
    protected float rectangularWidth = -1.0f;
    private float spaceCharRatio = 0.0f;

    public ColumnText(PdfContentByte pdfContentByte) {
        this.text = pdfContentByte;
    }

    public void addText(Phrase phrase) {
        Iterator iterator = ((AbstractList)phrase.getChunks()).iterator();
        while (iterator.hasNext()) {
            this.chunks.add(new PdfChunk((Chunk)iterator.next(), null));
        }
    }

    public void addText(Chunk chunk) {
        this.chunks.add(new PdfChunk(chunk, null));
    }

    protected ArrayList convertColumn(float[] fArray) {
        if (fArray.length < 4) {
            throw new RuntimeException("No valid column line found.");
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        int n2 = 0;
        while (n2 < fArray.length - 2) {
            float f2 = fArray[n2];
            float f3 = fArray[n2 + 1];
            float f4 = fArray[n2 + 2];
            float f5 = fArray[n2 + 3];
            if (f3 != f5) {
                float f6 = (f2 - f4) / (f3 - f5);
                float f7 = f2 - f6 * f3;
                float[] fArray2 = new float[]{Math.min(f3, f5), Math.max(f3, f5), f6, f7};
                arrayList.add(fArray2);
                this.maxY = Math.max(this.maxY, fArray2[1]);
                this.minY = Math.min(this.minY, fArray2[0]);
            }
            n2 += 2;
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException("No valid column line found.");
        }
        return arrayList;
    }

    protected float findLimitsPoint(ArrayList arrayList) {
        this.lineStatus = 0;
        if (this.yLine < this.minY || this.yLine > this.maxY) {
            this.lineStatus = 1;
            return 0.0f;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            float[] fArray = (float[])arrayList.get(n2);
            if (!(this.yLine < fArray[0]) && !(this.yLine > fArray[1])) {
                return fArray[2] * this.yLine + fArray[3];
            }
            ++n2;
        }
        this.lineStatus = 2;
        return 0.0f;
    }

    protected float[] findLimitsOneLine() {
        float f2 = this.findLimitsPoint(this.leftWall);
        if (this.lineStatus == 1 || this.lineStatus == 2) {
            return null;
        }
        float f3 = this.findLimitsPoint(this.rightWall);
        if (this.lineStatus == 2) {
            return null;
        }
        return new float[]{f2, f3};
    }

    protected float[] findLimitsTwoLines() {
        float[] fArray;
        float[] fArray2;
        while (true) {
            fArray2 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            this.yLine -= this.currentLeading;
            if (this.lineStatus == 2) continue;
            fArray = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            if (this.lineStatus == 2) {
                this.yLine -= this.currentLeading;
                continue;
            }
            if (!(fArray2[0] >= fArray[1]) && !(fArray[0] >= fArray2[1])) break;
        }
        return new float[]{fArray2[0], fArray2[1], fArray[0], fArray[1]};
    }

    public void setColumns(float[] fArray, float[] fArray2) {
        this.rightWall = this.convertColumn(fArray2);
        this.leftWall = this.convertColumn(fArray);
        this.rectangularWidth = -1.0f;
    }

    public void setSimpleColumn(Phrase phrase, float f2, float f3, float f4, float f5, float f6, int n2) {
        this.addText(phrase);
        this.setSimpleColumn(f2, f3, f4, f5, f6, n2);
    }

    public void setSimpleColumn(float f2, float f3, float f4, float f5, float f6, int n2) {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        fArray[0] = Math.min(f2, f4);
        fArray[1] = Math.max(f3, f5);
        fArray[2] = fArray[0];
        fArray[3] = Math.min(f3, f5);
        fArray2[0] = Math.max(f2, f4);
        fArray2[1] = fArray[1];
        fArray2[2] = fArray2[0];
        fArray2[3] = fArray[3];
        this.setColumns(fArray, fArray2);
        this.setLeading(f6);
        this.alignment = n2;
        this.yLine = fArray[1];
        this.rectangularWidth = Math.abs(f2 - f4);
    }

    public void setLeading(float f2) {
        this.fixedLeading = f2;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float f2, float f3) {
        this.fixedLeading = f2;
        this.multipliedLeading = f3;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setYLine(float f2) {
        this.yLine = f2;
    }

    public float getYLine() {
        return this.yLine;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setIndent(float f2) {
        this.indent = f2;
    }

    public float getIndent() {
        return this.indent;
    }

    public void setFollowingIndent(float f2) {
        this.followingIndent = f2;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float f2) {
        this.rightIndent = f2;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    protected PdfLine createLine(float f2) {
        if (this.chunks.size() == 0) {
            return null;
        }
        this.splittedChunkText = null;
        this.currentStandbyChunk = null;
        PdfLine pdfLine = new PdfLine(0.0f, f2, this.alignment, 0.0f);
        this.currentChunkMarker = 0;
        while (this.currentChunkMarker < this.chunks.size()) {
            PdfChunk pdfChunk = (PdfChunk)this.chunks.get(this.currentChunkMarker);
            String string = pdfChunk.toString();
            this.currentStandbyChunk = pdfLine.add(pdfChunk);
            if (this.currentStandbyChunk != null) {
                this.splittedChunkText = pdfChunk.toString();
                pdfChunk.setValue(string);
                return pdfLine;
            }
            ++this.currentChunkMarker;
        }
        return pdfLine;
    }

    protected void shortenChunkArray() {
        if (this.currentChunkMarker < 0) {
            return;
        }
        if (this.currentChunkMarker >= this.chunks.size()) {
            this.chunks.clear();
            return;
        }
        PdfChunk pdfChunk = (PdfChunk)this.chunks.get(this.currentChunkMarker);
        pdfChunk.setValue(this.splittedChunkText);
        this.chunks.set(this.currentChunkMarker, this.currentStandbyChunk);
        int n2 = this.currentChunkMarker - 1;
        while (n2 >= 0) {
            this.chunks.remove(n2);
            --n2;
        }
    }

    public int go() throws DocumentException {
        return this.go(false);
    }

    public int go(boolean bl) throws DocumentException {
        int n2;
        PdfContentByte pdfContentByte;
        boolean bl2;
        block22: {
            bl2 = false;
            float f2 = this.spaceCharRatio;
            Object[] objectArray = new Object[2];
            PdfFont pdfFont = null;
            Float f3 = new Float(0.0f);
            objectArray[1] = f3;
            PdfDocument pdfDocument = null;
            pdfContentByte = null;
            if (this.text != null) {
                pdfDocument = this.text.getPdfDocument();
                pdfContentByte = this.text.getDuplicate();
            } else if (!bl) {
                throw new NullPointerException("ColumnText.go with simulate==false and text==null.");
            }
            if (!bl) {
                if (f2 == 0.0f) {
                    f2 = this.text.getPdfWriter().getSpaceCharRatio();
                } else if (f2 < 0.001f) {
                    f2 = 0.001f;
                }
            }
            float f4 = this.indent;
            n2 = 0;
            if (this.rectangularWidth > 0.0f) {
                while (true) {
                    if (this.rectangularWidth <= f4 + this.rightIndent) {
                        n2 = 2;
                        if (this.chunks.size() == 0) {
                            n2 |= 1;
                        }
                        break block22;
                    }
                    if (this.chunks.size() == 0) {
                        n2 = 1;
                        break block22;
                    }
                    float f5 = this.yLine;
                    PdfLine pdfLine = this.createLine(this.rectangularWidth - f4 - this.rightIndent);
                    float f6 = pdfLine.getMaxSizeSimple();
                    this.currentLeading = this.fixedLeading + f6 * this.multipliedLeading;
                    float[] fArray = this.findLimitsTwoLines();
                    if (fArray == null) {
                        n2 = 2;
                        this.yLine = f5;
                        break block22;
                    }
                    float f7 = Math.max(fArray[0], fArray[2]);
                    if (!bl && !bl2) {
                        this.text.beginText();
                        bl2 = true;
                    }
                    this.shortenChunkArray();
                    if (!bl) {
                        objectArray[0] = pdfFont;
                        this.text.setTextMatrix(f7 + f4 + pdfLine.indentLeft(), this.yLine);
                        pdfDocument.writeLineToContent(pdfLine, this.text, pdfContentByte, objectArray, f2);
                        pdfFont = (PdfFont)objectArray[0];
                    }
                    f4 = pdfLine.isNewlineSplit() ? this.indent : this.followingIndent;
                    this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                }
            }
            this.currentLeading = this.fixedLeading;
            while (true) {
                float f8 = this.yLine;
                float[] fArray = this.findLimitsTwoLines();
                if (fArray == null) {
                    n2 = 2;
                    if (this.chunks.size() == 0) {
                        n2 |= 1;
                    }
                    this.yLine = f8;
                    break;
                }
                if (this.chunks.size() == 0) {
                    n2 = 1;
                    this.yLine = f8;
                    break;
                }
                float f9 = Math.max(fArray[0], fArray[2]);
                float f10 = Math.min(fArray[1], fArray[3]);
                if (f10 - f9 <= f4 + this.rightIndent) continue;
                if (!bl && !bl2) {
                    this.text.beginText();
                    bl2 = true;
                }
                PdfLine pdfLine = this.createLine(f10 - f9 - f4 - this.rightIndent);
                this.shortenChunkArray();
                if (!bl) {
                    objectArray[0] = pdfFont;
                    this.text.setTextMatrix(f9 + f4 + pdfLine.indentLeft(), this.yLine);
                    pdfDocument.writeLineToContent(pdfLine, this.text, pdfContentByte, objectArray, f2);
                    pdfFont = (PdfFont)objectArray[0];
                }
                f4 = pdfLine.isNewlineSplit() ? this.indent : this.followingIndent;
                this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
            }
        }
        if (bl2) {
            this.text.endText();
            this.text.add(pdfContentByte);
        }
        return n2;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f2) {
        this.extraParagraphSpace = f2;
    }

    public void clearChunks() {
        this.chunks.clear();
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f2) {
        this.spaceCharRatio = f2;
    }
}

