/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class PatternTable
extends CGMTag {
    private int index;
    private Color[][] colorArray;
    private int precision;

    public PatternTable() {
        super(5, 32, 1);
    }

    public PatternTable(int index, Color[][] colorArray, int precision) {
        this();
        this.index = index;
        this.colorArray = colorArray;
        this.precision = 0;
    }

    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        cgm.writeIntegerIndex(this.index);
        cgm.writeInteger(this.colorArray.length);
        cgm.writeInteger(this.colorArray[0].length);
        cgm.writeInteger(this.precision);
        int i2 = 0;
        while (i2 < this.colorArray.length) {
            int j2 = 0;
            while (j2 < this.colorArray[i2].length) {
                cgm.writeColor(this.colorArray[i2][j2]);
                ++j2;
            }
            ++i2;
        }
    }

    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.print("PATTABLE ");
        cgm.writeInteger(this.index);
        cgm.print(", ");
        cgm.writeInteger(this.colorArray.length);
        cgm.print(", ");
        cgm.writeInteger(this.colorArray[0].length);
        cgm.print(", ");
        cgm.writeInteger(0);
        cgm.println(", ");
        cgm.indent();
        int i2 = 0;
        while (i2 < this.colorArray.length) {
            cgm.print("(");
            int j2 = 0;
            while (j2 < this.colorArray[i2].length) {
                cgm.writeColor(this.colorArray[i2][j2]);
                cgm.print(" ");
                ++j2;
            }
            cgm.println(")");
            ++i2;
        }
        cgm.outdent();
    }
}

