/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedInputStream;

public class EMFInputStream
extends TaggedInputStream
implements EMFConstants {
    public static int DEFAULT_VERSION = 1;
    private EMFHeader header;

    public EMFInputStream(InputStream is) throws IOException {
        this(is, DEFAULT_VERSION);
    }

    public EMFInputStream(InputStream is, int version) throws IOException {
        this(is, new EMFTagSet(version));
    }

    public EMFInputStream(InputStream is, EMFTagSet tagSet) throws IOException {
        super(is, tagSet, null, true);
    }

    public int readDWORD() throws IOException {
        long i2 = this.readUnsignedInt();
        return (int)i2;
    }

    public int[] readDWORD(int size) throws IOException {
        int[] x2 = new int[size];
        int i2 = 0;
        while (i2 < x2.length) {
            x2[i2] = this.readDWORD();
            ++i2;
        }
        return x2;
    }

    public int readWORD() throws IOException {
        return this.readUnsignedShort();
    }

    public int readLONG() throws IOException {
        return this.readInt();
    }

    public int[] readLONG(int size) throws IOException {
        int[] x2 = new int[size];
        int i2 = 0;
        while (i2 < x2.length) {
            x2[i2] = this.readLONG();
            ++i2;
        }
        return x2;
    }

    public float readFLOAT() throws IOException {
        return this.readFloat();
    }

    public int readUINT() throws IOException {
        return (int)this.readUnsignedInt();
    }

    public int readULONG() throws IOException {
        return (int)this.readUnsignedInt();
    }

    public Color readCOLORREF() throws IOException {
        Color c2 = new Color(this.readUnsignedByte(), this.readUnsignedByte(), this.readUnsignedByte());
        this.readByte();
        return c2;
    }

    public Color readCOLOR16() throws IOException {
        return new Color(this.readShort() >> 8, this.readShort() >> 8, this.readShort() >> 8, this.readShort() >> 8);
    }

    public AffineTransform readXFORM() throws IOException {
        return new AffineTransform(this.readFLOAT(), this.readFLOAT(), this.readFLOAT(), this.readFLOAT(), this.readFLOAT(), this.readFLOAT());
    }

    public Rectangle readRECTL() throws IOException {
        int x2 = this.readLONG();
        int y2 = this.readLONG();
        int w2 = this.readLONG() - x2;
        int h2 = this.readLONG() - y2;
        return new Rectangle(x2, y2, w2, h2);
    }

    public Point readPOINTL() throws IOException {
        int x2 = this.readLONG();
        int y2 = this.readLONG();
        return new Point(x2, y2);
    }

    public Point[] readPOINTL(int size) throws IOException {
        Point[] p2 = new Point[size];
        int i2 = 0;
        while (i2 < p2.length) {
            p2[i2] = this.readPOINTL();
            ++i2;
        }
        return p2;
    }

    public Point readPOINTS() throws IOException {
        short x2 = this.readShort();
        short y2 = this.readShort();
        return new Point(x2, y2);
    }

    public Point[] readPOINTS(int size) throws IOException {
        Point[] p2 = new Point[size];
        int i2 = 0;
        while (i2 < p2.length) {
            p2[i2] = this.readPOINTS();
            ++i2;
        }
        return p2;
    }

    public Dimension readSIZEL() throws IOException {
        return new Dimension(this.readLONG(), this.readLONG());
    }

    public int readBYTE() throws IOException {
        return this.readByte();
    }

    public byte[] readBYTE(int size) throws IOException {
        byte[] x2 = new byte[size];
        int i2 = 0;
        while (i2 < x2.length) {
            x2[i2] = (byte)this.readBYTE();
            ++i2;
        }
        return x2;
    }

    public boolean readBOOLEAN() throws IOException {
        return this.readBYTE() != 0;
    }

    public String readWCHAR(int size) throws IOException {
        byte[] bytes = this.readByte(2 * size);
        int length = 2 * size;
        int i2 = 0;
        while (i2 < 2 * size) {
            if (bytes[i2] == 0 && bytes[i2 + 1] == 0) {
                length = i2;
                break;
            }
            i2 += 2;
        }
        return new String(bytes, 0, length, "UTF-16LE");
    }

    protected TagHeader readTagHeader() throws IOException {
        int tagID = this.read();
        if (tagID == -1) {
            return null;
        }
        tagID |= this.readUnsignedByte() << 8;
        tagID |= this.readUnsignedByte() << 16;
        long length = this.readDWORD();
        return new TagHeader(tagID |= this.readUnsignedByte() << 24, length - 8L);
    }

    protected ActionHeader readActionHeader() throws IOException {
        return null;
    }

    public EMFHeader readHeader() throws IOException {
        if (this.header == null) {
            this.header = new EMFHeader(this);
        }
        return this.header;
    }

    public int getVersion() {
        return DEFAULT_VERSION;
    }
}

