/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.font.encoding.CharTable;

public abstract class FontIncluder {
    public static final double FONT_SIZE = 1000.0;
    private FontRenderContext context;
    private Rectangle2D fontBBox;
    private Font font;
    private String fontName;
    private CharTable charTable;
    private char[] unicode;
    private String[] charName;
    private int noDefinedChars;

    protected abstract void openIncludeFont() throws IOException;

    protected abstract void writeEncoding(CharTable var1) throws IOException;

    protected void closeIncludeFont() throws IOException {
    }

    public FontIncluder(FontRenderContext context) {
        this.context = context;
        this.noDefinedChars = -1;
    }

    protected FontRenderContext getContext() {
        return this.context;
    }

    protected String getFontName() {
        return this.fontName;
    }

    protected Font getFont() {
        return this.font;
    }

    protected CharTable getEncodingTable() {
        return this.charTable;
    }

    protected Rectangle2D getFontBBox() {
        return this.fontBBox;
    }

    protected String getCharName(int i2) {
        return this.charName[i2];
    }

    protected char getUnicode(int i2) {
        return this.unicode[i2];
    }

    protected char[] getUnicode() {
        return this.unicode;
    }

    protected int getNODefinedChars() {
        return this.noDefinedChars;
    }

    public void includeFont(Font font, CharTable charTable, String name) throws IOException {
        this.unicode = null;
        this.charName = null;
        this.font = font;
        this.charTable = charTable;
        this.fontName = name;
        this.fontBBox = font.getMaxCharBounds(this.context);
        this.noDefinedChars = 0;
        this.unicode = new char[256];
        this.charName = new String[256];
        int i2 = 0;
        while (i2 < this.unicode.length) {
            this.charName[i2] = charTable.toName(i2);
            if (this.charName[i2] != null) {
                this.unicode[i2] = charTable.toUnicode(this.charName[i2]);
                ++this.noDefinedChars;
            } else {
                this.unicode[i2] = '\u0000';
            }
            ++i2;
        }
        this.openIncludeFont();
        this.writeEncoding(charTable);
        this.closeIncludeFont();
    }

    protected double getUndefinedWidth() {
        return 1000.0;
    }
}

