/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFRedundanceTracker {
    private static int refCount = 1;
    private PDFWriter pdf;
    private Map objects;
    private Vector orderedObjects;

    public PDFRedundanceTracker(PDFWriter pdf) {
        this.pdf = pdf;
        this.objects = new Hashtable();
        this.orderedObjects = new Vector();
    }

    public PDFRef getReference(Object object, Object groupID, Writer writer) {
        Object o2 = this.objects.get(object);
        if (o2 != null) {
            return ((Entry)o2).reference;
        }
        Entry entry = new Entry(object, groupID, writer);
        this.objects.put(object, entry);
        this.orderedObjects.add(entry);
        return entry.reference;
    }

    public PDFRef getReference(Object object, Writer writer) {
        return this.getReference(object, null, writer);
    }

    public void writeAll() {
        Iterator i2 = this.orderedObjects.iterator();
        while (i2.hasNext()) {
            Entry entry = (Entry)i2.next();
            if (entry.written) continue;
            try {
                entry.writer.writeObject(entry.object, entry.reference, this.pdf);
                entry.written = true;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public Collection getGroup(Object groupID) {
        LinkedList<Object> result = new LinkedList<Object>();
        Iterator i2 = this.orderedObjects.iterator();
        while (i2.hasNext()) {
            Entry entry = (Entry)i2.next();
            if (!groupID.equals(entry.groupID)) continue;
            result.add(entry.object);
        }
        return result;
    }

    private class Entry {
        private static final String REF_PREFIX = "PDF_RTObj";
        private Object object;
        private Writer writer;
        private boolean written;
        private PDFRef reference;
        private Object groupID;

        private Entry(Object o2, Object groupID, Writer w2) {
            this.object = o2;
            this.groupID = groupID;
            this.writer = w2;
            this.written = false;
            this.reference = PDFRedundanceTracker.this.pdf.ref(REF_PREFIX + refCount++);
        }
    }

    public static interface Writer {
        public void writeObject(Object var1, PDFRef var2, PDFWriter var3) throws IOException;
    }
}

