/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.EOFException;
import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.graphicsio.swf.SoundInfo;

public class DefineButtonSound
extends DefinitionTag {
    private int character;
    private int[] soundID;
    private SoundInfo[] info;

    public DefineButtonSound(int id, int[] soundID, SoundInfo[] info) {
        this();
        this.character = id;
        this.soundID = soundID;
        this.info = info;
    }

    public DefineButtonSound() {
        super(17, 2);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineButtonSound tag = new DefineButtonSound();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        tag.soundID = new int[4];
        tag.info = new SoundInfo[4];
        try {
            int i2 = 0;
            while (i2 < 4) {
                tag.soundID[i2] = swf.readUnsignedShort();
                tag.info[i2] = new SoundInfo(swf);
                ++i2;
            }
        }
        catch (EOFException e2) {}
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        int i2 = 0;
        while (i2 < 4) {
            swf.writeUnsignedShort(this.soundID[i2]);
            if (this.info[i2] != null) {
                this.info[i2].write(swf);
            } else {
                swf.writeUnsignedByte(0);
            }
            ++i2;
        }
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append(super.toString() + "\n");
        s2.append("  character:  " + this.character + "\n");
        int i2 = 0;
        while (i2 < this.soundID.length) {
            s2.append("  ");
            s2.append(this.soundID[i2]);
            s2.append(": ");
            s2.append(this.info[i2]);
            s2.append("\n");
            ++i2;
        }
        return s2.toString();
    }
}

