/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;

public class RecentFileList
implements ActionListener {
    private Vector files;
    private String type;
    private int size;
    private int used;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public RecentFileList() {
        this(null);
    }

    public RecentFileList(int size) {
        this(null, size);
    }

    public RecentFileList(String type) {
        this(type, 4);
    }

    public RecentFileList(String type, int size) {
        this.files = new Vector(size);
        this.size = size;
        this.type = type;
        this.used = 0;
    }

    public void addActionListener(ActionListener l2) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = RecentFileList.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l2);
    }

    public void removeActionListener(ActionListener l2) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = RecentFileList.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l2);
    }

    protected void fireActionPerformed(ActionEvent e2) {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == (class$java$awt$event$ActionListener == null ? RecentFileList.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                ((ActionListener)listeners[i2 + 1]).actionPerformed(e2);
            }
            i2 -= 2;
        }
    }

    public void actionPerformed(ActionEvent e2) {
        this.fireActionPerformed(e2);
    }

    public void save(Properties props) {
        String key = "RecentFile_" + (this.type != null ? this.type + "_" : "");
        int i2 = 0;
        while (i2 < this.used) {
            props.put(key + i2, this.files.elementAt(i2).toString());
            ++i2;
        }
        props.put(key + "Used", String.valueOf(this.used));
    }

    public void load(Properties props) {
        String key = "RecentFile_" + (this.type != null ? this.type + "_" : "");
        this.files.removeAllElements();
        this.used = Integer.parseInt(props.getProperty(key + "Used", "0"));
        int i2 = 0;
        while (i2 < this.used) {
            String value = props.getProperty(key + i2);
            if (value == null) break;
            this.files.addElement(value);
            ++i2;
        }
    }

    public void add(File f2) {
        try {
            this.add(f2.getCanonicalPath());
        }
        catch (IOException x2) {
            this.add(f2.getAbsolutePath());
        }
    }

    public void remove(File f2) {
        this.remove(f2.getName());
    }

    public void add(String name) {
        int pos = this.files.indexOf(name);
        if (pos > 0) {
            this.files.removeElementAt(pos);
            this.files.insertElementAt(name, 0);
        } else if (pos != 0) {
            if (this.used == this.size) {
                this.files.removeElementAt(this.size - 1);
            } else {
                ++this.used;
            }
            this.files.insertElementAt(name, 0);
        }
    }

    public void remove(String name) {
        if (this.files.removeElement(name)) {
            --this.used;
        }
    }

    public void buildMenu(JMenu menu) {
        if (this.used > 0) {
            menu.addSeparator();
            int i2 = 0;
            while (i2 < this.used) {
                JMenuItem item = new JMenuItem(String.valueOf(i2 + 1) + " " + this.files.elementAt(i2));
                item.setActionCommand(this.files.elementAt(i2).toString());
                if (this.size < 9) {
                    item.setMnemonic(Character.forDigit(i2 + 1, 10));
                }
                item.addActionListener(this);
                menu.add(item);
                ++i2;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

