/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;

public class PanelArtistUtilities {
    public static AffineTransform getResizeTransform(int oldWidth, int oldHeight, int newWidth, int newHeight) {
        double scale = Math.min((double)newWidth / (double)oldWidth, (double)newHeight / (double)oldHeight);
        double tx = 0.5 * ((double)newWidth - scale * (double)oldWidth);
        double ty = 0.5 * ((double)newHeight - scale * (double)oldHeight);
        return new AffineTransform(scale, 0.0, 0.0, scale, tx, ty);
    }

    public static AffineTransform getStretchTransform(int oldWidth, int oldHeight, int newWidth, int newHeight) {
        double scaleX = (double)newWidth / (double)oldWidth;
        double scaleY = (double)newHeight / (double)oldHeight;
        return new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
    }

    public static AffineTransform getZoomTransform(double zoomFactor, int width, int height) {
        double tx = (double)width / 2.0 * (1.0 - zoomFactor);
        double ty = (double)height / 2.0 * (1.0 - zoomFactor);
        return new AffineTransform(zoomFactor, 0.0, 0.0, zoomFactor, tx, ty);
    }

    public static AffineTransform getXFlipTransform(int width) {
        return new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)width, 0.0);
    }

    public static AffineTransform getYFlipTransform(int height) {
        return new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)height);
    }

    public static AffineTransform getCenteringTransform(int newX, int newY, int width, int height) {
        return new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)width / 2.0 - (double)newX, (double)height / 2.0 - (double)newY);
    }

    public static AffineTransform getCCWRotateTransform(int width, int height) {
        return new AffineTransform(0.0, -((double)height) / (double)width, (double)width / (double)height, 0.0, 0.0, (double)height);
    }

    public static AffineTransform getCWRotateTransform(int width, int height) {
        return new AffineTransform(0.0, (double)height / (double)width, -((double)width) / (double)height, 0.0, (double)width, 0.0);
    }

    public static void getFittingTransform(AffineTransform transform, RectangularShape realBounds, RectangularShape windowBounds) {
        if (realBounds == null || windowBounds == null) {
            transform.setToIdentity();
        } else {
            double realWidth = realBounds.getWidth();
            double realHeight = realBounds.getHeight();
            double windowWidth = windowBounds.getWidth();
            double windowHeight = windowBounds.getHeight();
            if (realWidth > 0.0 && realHeight > 0.0) {
                double scaleWidth = windowWidth / realWidth;
                double scaleHeight = windowHeight / realHeight;
                double scale = Math.min(scaleWidth, scaleHeight);
                transform.setTransform(scale, 0.0, 0.0, -scale, windowWidth / 2.0, windowHeight / 2.0);
            } else {
                transform.setToIdentity();
            }
        }
    }

    public static void getFillingTransform(AffineTransform transform, RectangularShape realBounds, RectangularShape windowBounds) {
        if (realBounds == null || windowBounds == null) {
            transform.setToIdentity();
        } else {
            double realWidth = realBounds.getWidth();
            double realHeight = realBounds.getHeight();
            double windowWidth = windowBounds.getWidth();
            double windowHeight = windowBounds.getHeight();
            if (realWidth > 0.0 && realHeight > 0.0) {
                double scaleWidth = windowWidth / realWidth;
                double scaleHeight = windowHeight / realHeight;
                transform.setTransform(scaleWidth, 0.0, 0.0, -scaleHeight, -scaleWidth * realBounds.getX(), scaleHeight * realBounds.getY());
            } else {
                transform.setToIdentity();
            }
        }
    }

    public static Rectangle getLocalBounds(Rectangle bounds, Container c2) {
        if (bounds == null) {
            bounds = new Rectangle();
        }
        Insets insets = c2.getInsets();
        bounds.setBounds(0, 0, c2.getWidth() - (insets.left + insets.right), c2.getHeight() - (insets.top + insets.bottom));
        return bounds;
    }
}

