/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.freehep.util.DoubleWithError;

public class ScientificFormat
extends Format {
    private int sigDigit = 5;
    private int maxWidth = 8;
    private boolean SciNote = false;
    private static final double k = 1.0 / Math.log(10.0);

    public ScientificFormat() {
    }

    public ScientificFormat(int sigDigit, int maxWidth, boolean SciNote) {
        this.setSigDigits(sigDigit);
        this.setMaxWidth(maxWidth);
        this.setScientificNotationStyle(SciNote);
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            String result = this.format(((Number)obj).doubleValue());
            return toAppendTo.append(result);
        }
        if (obj instanceof DoubleWithError) {
            DoubleWithError dwe = (DoubleWithError)obj;
            toAppendTo.append(this.format(dwe.getValue()));
            if (dwe.hasAsymmetricError()) {
                toAppendTo.append("+");
                int errorSigDigit = this.resolveErrorSigDigit(dwe.getValue(), dwe.getPlusError());
                toAppendTo.append(this.formatError(errorSigDigit, dwe.getPlusError()));
                toAppendTo.append("-");
                errorSigDigit = this.resolveErrorSigDigit(dwe.getValue(), dwe.getMinError());
                toAppendTo.append(this.formatError(errorSigDigit, dwe.getMinError()));
            } else {
                toAppendTo.append("\ufffd");
                int errorSigDigit = this.resolveErrorSigDigit(dwe.getValue(), dwe.getError());
                toAppendTo.append(this.formatError(errorSigDigit, dwe.getError()));
            }
            return toAppendTo;
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public int getSigDigits() {
        return this.sigDigit;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public boolean getScientificNotationStyle() {
        return this.SciNote;
    }

    public void setSigDigits(int SigDigit) {
        if (SigDigit < 1) {
            throw new IllegalArgumentException("sigDigit");
        }
        this.sigDigit = SigDigit;
    }

    public void setMaxWidth(int mWidth) {
        if (mWidth < 3) {
            throw new IllegalArgumentException("maxWidth");
        }
        this.maxWidth = mWidth;
    }

    public void setScientificNotationStyle(boolean sciNote) {
        this.SciNote = sciNote;
    }

    private double Log10(double x2) {
        if (x2 == 0.0) {
            return 0.0;
        }
        return Math.log(x2) * k;
    }

    private int resolveErrorSigDigit(double x2, double dx) {
        dx = Math.abs(dx);
        x2 = Math.abs(x2);
        if (dx == 0.0 || Double.isInfinite(dx) || Double.isNaN(dx) || dx >= x2) {
            return this.sigDigit;
        }
        if (x2 == 0.0 || Double.isInfinite(x2) || Double.isNaN(x2)) {
            return this.sigDigit;
        }
        int log = (int)Math.round(this.Log10(dx / x2));
        int errorsigdigit = this.sigDigit + log;
        if (errorsigdigit < 1) {
            return 1;
        }
        return errorsigdigit;
    }

    public String format(double d2) {
        if (Double.isInfinite(d2)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d2)) {
            return "NaN";
        }
        String result = "";
        double c2 = 0.0;
        int ShiftNumber = 0;
        int IntOfNumberinput = 0;
        if (d2 == 0.0) {
            return "0";
        }
        c2 = d2;
        IntOfNumberinput = (int)Math.floor(this.Log10(d2 = Math.abs(c2)));
        if (IntOfNumberinput > -1 && d2 % Math.pow(10.0, IntOfNumberinput + 1) == 0.0) {
            ++IntOfNumberinput;
        }
        ShiftNumber = this.Log10(d2) < 0.0 ? this.sigDigit - IntOfNumberinput - 1 : this.sigDigit - IntOfNumberinput;
        long temp = Math.round(Math.pow(10.0, ShiftNumber) * d2);
        String Formatted = String.valueOf(temp);
        BigDecimal tempbunk = new BigDecimal(Math.pow(10.0, ShiftNumber) * d2);
        long bunk = tempbunk.longValue();
        String Formattedbunk = String.valueOf(bunk);
        if (Formatted.length() > Formattedbunk.length()) {
            ++IntOfNumberinput;
        }
        if (!this.SciNote) {
            if (IntOfNumberinput < 0) {
                String LoopZero1 = "";
                int a2 = 0;
                while (a2 < Math.abs(IntOfNumberinput) - 1) {
                    LoopZero1 = LoopZero1 + "0";
                    ++a2;
                }
                result = "0." + LoopZero1 + Formatted;
            } else {
                String[] FillDigits = new String[IntOfNumberinput + 1];
                int a3 = 0;
                while (a3 <= IntOfNumberinput) {
                    FillDigits[a3] = "0";
                    ++a3;
                }
                int a4 = 0;
                while (a4 < Formatted.length() && a4 <= IntOfNumberinput) {
                    FillDigits[a4] = Formatted.substring(a4, a4 + 1);
                    ++a4;
                }
                int i2 = 0;
                while (i2 <= FillDigits.length - 1) {
                    result = result + FillDigits[i2];
                    ++i2;
                }
                int length = result.length();
                if (length < this.sigDigit) {
                    String resultaddon = "";
                    int i3 = -1;
                    if (IntOfNumberinput == 0) {
                        while (length < this.sigDigit) {
                            resultaddon = resultaddon + Formatted.substring(result.length() + i3 + 1, result.length() + i3 + 2);
                            ++length;
                            ++i3;
                        }
                    } else {
                        i3 = 0;
                        while (length < this.sigDigit) {
                            resultaddon = resultaddon + Formatted.substring(result.length() + i3, result.length() + i3 + 1);
                            ++length;
                            ++i3;
                        }
                    }
                    result = result + "." + resultaddon;
                }
            }
            if (result.length() > this.maxWidth) {
                result = Formatted.substring(0, 1) + "." + Formatted.substring(1, this.sigDigit) + "E" + IntOfNumberinput;
            }
        }
        if (this.SciNote) {
            result = Formatted.substring(0, 1) + "." + Formatted.substring(1, this.sigDigit) + "E" + IntOfNumberinput;
        }
        if (c2 > 0.0) {
            return result;
        }
        return "-" + result;
    }

    public String formatError(double d2, double dx) {
        return this.formatError(this.resolveErrorSigDigit(d2, dx), dx);
    }

    public String formatError(int eSD, double d2) {
        if (Double.isInfinite(d2)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d2)) {
            return "NaN";
        }
        int errorSigDigit = eSD;
        String result = "";
        double c2 = 0.0;
        int ShiftNumber = 0;
        int IntOfNumberinput = 0;
        if (d2 == 0.0) {
            return "0";
        }
        c2 = d2;
        IntOfNumberinput = (int)Math.floor(this.Log10(d2 = Math.abs(c2)));
        if (IntOfNumberinput > -1 && d2 % Math.pow(10.0, IntOfNumberinput + 1) == 0.0) {
            ++IntOfNumberinput;
        }
        ShiftNumber = this.Log10(d2) < 0.0 ? errorSigDigit - IntOfNumberinput - 1 : errorSigDigit - IntOfNumberinput;
        long temp = Math.round(Math.pow(10.0, ShiftNumber) * d2);
        String Formatted = String.valueOf(temp);
        BigDecimal tempbunk = new BigDecimal(Math.pow(10.0, ShiftNumber) * d2);
        long bunk = tempbunk.longValue();
        String Formattedbunk = String.valueOf(bunk);
        if (Formatted.length() > Formattedbunk.length()) {
            ++IntOfNumberinput;
        }
        if (!this.SciNote) {
            if (IntOfNumberinput < 0) {
                String LoopZero1 = "";
                int a2 = 0;
                while (a2 < Math.abs(IntOfNumberinput) - 1) {
                    LoopZero1 = LoopZero1 + "0";
                    ++a2;
                }
                result = "0." + LoopZero1 + Formatted;
            } else {
                String[] FillDigits = new String[IntOfNumberinput + 1];
                int a3 = 0;
                while (a3 <= IntOfNumberinput) {
                    FillDigits[a3] = "0";
                    ++a3;
                }
                int a4 = 0;
                while (a4 < Formatted.length() && a4 <= IntOfNumberinput) {
                    FillDigits[a4] = Formatted.substring(a4, a4 + 1);
                    ++a4;
                }
                int i2 = 0;
                while (i2 <= FillDigits.length - 1) {
                    result = result + FillDigits[i2];
                    ++i2;
                }
                int length = result.length();
                if (length < errorSigDigit) {
                    String resultaddon = "";
                    int i3 = -1;
                    if (IntOfNumberinput == 0) {
                        while (length < errorSigDigit) {
                            resultaddon = resultaddon + Formatted.substring(result.length() + i3 + 1, result.length() + i3 + 2);
                            ++length;
                            ++i3;
                        }
                    } else {
                        i3 = 0;
                        while (length < errorSigDigit) {
                            resultaddon = resultaddon + Formatted.substring(result.length() + i3, result.length() + i3 + 1);
                            ++length;
                            ++i3;
                        }
                    }
                    result = result + "." + resultaddon;
                }
            }
            if (result.length() > this.maxWidth) {
                result = Formatted.substring(0, 1) + "." + Formatted.substring(1, errorSigDigit) + "E" + IntOfNumberinput;
            }
        }
        if (this.SciNote) {
            result = Formatted.substring(0, 1) + "." + Formatted.substring(1, errorSigDigit) + "E" + IntOfNumberinput;
        }
        if (c2 > 0.0) {
            return result;
        }
        return "-" + result;
    }
}

