/** \file CON_Misc.h 
    Miscalenous interfaces 

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.  
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/

class ProgressMonitor;

#ifndef H_CON_MISC
#define H_CON_MISC

#include <CON_Console.h>
#include <CON_Screen.h>

/** A generic monitor to check the progress of long time routines */
class ProgressMonitor
{
public:
  /** Callback function with the status of progress 0 to 1 */
  virtual void update(const float Status) = 0;
};


////////////////////////////////////////////////////////////
// Generic functions.
////////////////////////////////////////////////////////////
#ifndef FUNC_GENERIC
#define FUNC_GENERIC


/** \relates Console
    Returns the version of the library. */
DLLExport float    getVersion();

/** \relates Console
    Returns the Fraction frame time needed for a world's advance. */
DLLExport float    getFrameTime();

/** \relates Console
    Returns the Console object pointer. */
DLLExport Console* getConsole();

#endif // FUNC_GENERIC


#ifndef FUNC_SPECIAL
#define FUNC_SPECIAL
////////////////////////////////////////////////////////////
// Special Purpose.
////////////////////////////////////////////////////////////

/** \relates Screen 
    Used to create a screen for console (non graphic) apps batch processing. 
    For a usual graphics game, it shouldn't be used.
*/
DLLExport Screen*  newWindowScreen(void* hWnd_, int Width, int Height, int NoAccel=0);


#endif // FUNC_SPECIAL


#endif // H_CON_MISC