/** \file DS_Queue.h
    Queue data structure

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage.
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_DS_QUEUE
#define H_DS_QUEUE

#include <DS_Stack.h>

/** A classic FIFO data structure.
    See <DS_Stack.h> for other methods */
class Queue : public Stack
{
public:
  /** Default Constructor: Construct an empty queue. */
  Queue(const unsigned flags=0) : Stack(flags) {}

  /** Copy Constructor: Construct a copy of a queue. */
  Queue(const Queue& q)         : Stack(q)     {}

  /** Construct a queue from any container.  The elements
      are queued in the index order of the container. */
  Queue(const Container& c)     : Stack(c)     {}

  /** Construct a queue from an enumeration.  The elements
      are queued in the order they are enumerated. */
  Queue(const Enumeration& e)   : Stack(e)     {}

  /** Construct a queue from a vector.  The elements
      are queued in index order. */
  Queue(const Vector& v)        : Stack(v)     {}

  /** Destructor. */
  ~Queue()                                     {}

  /** Assignment: Copy a queue. */
  Queue& operator=(const Queue& q)             { return *this = q; }

 
  /** Retrieve the first element without removing. */
  Data peek(const int index=0)                 { return elementAt(index); }

  /** Retrieve and remove the first element.
      Note: pop() returns garbage in a destructive queue. */
  Data pop()                                   
  {
     if (size() == 0)
        return NULL;
     else {
        Data Item=peek();
        removeElement(0);
        return Item;
     }
  }
};

#endif // H_DS_QUEUE