/** \file DS_StringTokenizer.h
    String token seperator.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage.
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_DS_STRINGTOKENIZER
#define H_DS_STRINGTOKENIZER

#include <DS_String.h>
#include <DS_Vector.h>

/** This class separates a string to separate tokens.  It contains local storage, which
    solves the problem with the global strtok
    Delim can have any number of delimiters
    It also supplies an empty string capability:
    example: "AA|B||C"  breaks down with "|" delimiter to: "AA" "B" "" "C" */
class StringTokenizer
{
public:
  /** Construct a StringTokenizer. */
  StringTokenizer(const String& Text, const String& Delim, const DS_BOOL IncludeEmpty=0);
  
  /** Destructor. */
  virtual ~StringTokenizer();

  /** Returns the next token available.  Throws IndexOutOfBounds if there are no more tokens. */
  String& nextToken();

  /** Returns non-zero if there are more tokens. */
  int hasMoreTokens() const;

private:  
  String      m_Empty;
  int         m_Pos;
  Enumeration m_Tokens;
  Vector      m_TokensSource;
// Private member function
  void scanForEmpty(char* StringPtr, const int len, const String& Delim);
};

#endif // H_DS_STRINGTOKENIZER
