// MCar.h: interface for the MCar class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MCAR_H__A4384A92_7AB8_11D3_AA19_0020188CB1AB__INCLUDED_)
#define AFX_MCAR_H__A4384A92_7AB8_11D3_AA19_0020188CB1AB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


struct car_info {
	DWORD	car_handle;
	DWORD	front_left_wheel_handle[2];
	DWORD	front_right_wheel_handle[2];
	DWORD	back_left_wheel_handle[2];
	DWORD	back_right_wheel_handle[2];
	double	speed;
	double  width,length,height; 
	double	wheel_length,wheel_width,wheel_front_height,wheel_back_height;
	double	wheels_angle; //a positive value means turning left
						  //a negative value means turning right
	double  wheels_spin_angle; //a positive number means driving forward, a negative number means going backwards

	int		is_air_mode;
	int		current_sound;

	DWORD	wheel_mark_bitmap; //The bitmap that is used for the marks that the 
							 //wheel is leaving on the ground.
public:
	BOOL m_weelsMarkFlag;
	UINT m_Rudder;
	UINT m_carWindow;
};

class MCar : public CObject  
{
public:
	BOOL checkIntersectionForward();
	double m_intersection[3];
	void createMirror();
	void set_sounds();
	void move_car();
	int initialize();
	car_info car_info;
	MCar();
	virtual ~MCar();
private:
	void turn_wheel_left();
	void turn_wheel_right();
	void turn_wheels_default();
	void set_wheels_spin_angle();
	void put_wheels_in_place();
	void create_wheels_mark_on_the_ground(DWORD wheel);
	void move_car_according_to_wheels();
	void turn_car_according_to_wheels();
	void move_car_forward();
	void switch_to_air_mode();
	void copy_vec(double dst[3], double src[3]);

};

#endif // !defined(AFX_MCAR_H__A4384A92_7AB8_11D3_AA19_0020188CB1AB__INCLUDED_)
