// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "mirrorM.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_PREV_TRAN, OnPrevTran)
	ON_COMMAND(ID_NEXT_TRAN, OnNextTran)
	ON_UPDATE_COMMAND_UI(ID_PREV_TRAN, OnUpdatePrevTran)
	ON_UPDATE_COMMAND_UI(ID_NEXT_TRAN, OnUpdateNextTran)
	ON_COMMAND(ID_CHANGE_CAMERA, OnChangeCamera)
	ON_UPDATE_COMMAND_UI(ID_CHANGE_CAMERA, OnUpdateChangeCamera)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	m_needRender = FALSE;
	m_polyMirror = 0;
	m_typeT = FILTER_GLASS;
	m_typeIndex = 1;
		
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	// create a view to occupy the client area of the frame
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
void CMainFrame::OnSetFocus(CWnd* pOldWnd)
{
	// forward focus to the view window
	m_wndView.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// let the view have first crack at the command
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// otherwise, do default handling
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


void CMainFrame::m_Render()
{
	if(Morfit_engine_is_engine_empty() == NO)
	{
		Morfit_engine_render(m_wndView.m_hWnd,m_ActiveCamera);
		
		
	}

}

void CMainFrame::OnPrevTran() 
{
	// TODO: Add your command handler code here
	BYTE typeT[10] =  
	{
		DARK_FILTER_GLASS,
		FILTER_GLASS,
		OPAQUE_FILTER_GLASS,
		NORMAL_GLASS,
		CONTROL_GLASS,
		BRIGHT_TRANSPARENT_GLASS,
		BRIGHT_TRANSLUCENT_GLASS,
		BRIGHT_OPAQUE_GLASS,
		LIGHT_SOURCE_GLASS,
		INVERSE_GLASS
	};
	
	if(-- m_typeIndex < 0) m_typeIndex = 9;

	Morfit_polygon_set_translucent(m_polyMirror,typeT[m_typeIndex]);

	
}

void CMainFrame::OnNextTran() 
{
	BYTE typeT[10] =  
	{
		DARK_FILTER_GLASS,
		FILTER_GLASS,
		OPAQUE_FILTER_GLASS,
		NORMAL_GLASS,
		CONTROL_GLASS,
		BRIGHT_TRANSPARENT_GLASS,
		BRIGHT_TRANSLUCENT_GLASS,
		BRIGHT_OPAQUE_GLASS,
		LIGHT_SOURCE_GLASS,
		INVERSE_GLASS
	};
	
	if(++ m_typeIndex > 9) m_typeIndex = 0;

	Morfit_polygon_set_translucent(m_polyMirror,typeT[m_typeIndex]);
	
}

void CMainFrame::OnUpdatePrevTran(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if(!m_polyMirror)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

void CMainFrame::OnUpdateNextTran(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if(!m_polyMirror)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
	
}

void CMainFrame::OnChangeCamera() 
{
	// TODO: Add your command handler code here
	if(m_ActiveCamera == cameraExternal)
		m_ActiveCamera = cameraInternal;
	else
		m_ActiveCamera = cameraExternal;

	
}

void CMainFrame::OnUpdateChangeCamera(CCmdUI* pCmdUI) 
{

	
	
	// TODO: Add your command update UI handler code here




	if(m_ActiveCamera == cameraExternal)
	{
		pCmdUI->SetCheck(FALSE);
	
	}
	else
	{
		pCmdUI->SetCheck(TRUE);
	
	}


}
