//
//
//                                /\    /\
//                               /  \  /  \
//                              /    \/    \
//                             /  /\    /\  \
//                            /  /  \  /  Y T H O S
//                           /  /    \/    \  \
//                          /  /            \  \
//                         /__/              \__\
//
//                  Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// sysmain.cpp
//
//

//
//
//                                Includes
//
//

#include <iostream.h>

#include "mythos.hpp"

//
//
//                                 Data
//
//

MythosSystem    Mythos;

//
//
//                                 Code
//
//

//Ŀ
// atexit handlers                                                          
//
STATIC void atexit_1(void)
{
    cout << "ATEXIT 1:  Should happen\n";
}

STATIC void atexit_2(void)
{
    cout << "ATEXIT 2:  Shouldn't happen\n";
}

STATIC void atexit_3(void)
{
    cout << "ATEXIT 3:  Should happen\n";
}

//Ŀ
// main                                                                     
//
void main()
{
    cout << " Mythos System Tester \n";

    cout << "\n\n Mythos System Detect Tester \n";

    if (mythos_detect_mmx())
    {
        cout << "MMX detected\n";
    }
    else
    {
        cout << "MMX not present\n";
    }

    if (mythos_detect_amd3d())
    {
        cout << "AMD-3D detected\n";
    }
    else
    {
        cout << "AMD-3D not present\n";
    }

    cout << "\n\n Mythos AtExit Tester \n";

    if (mythos_atexit( atexit_1 ))
    {
        cout << " Error registering atexit 1!\n";
    }
    else
    {
        cout << "Atexit 1 registered.\n";
    }

    if (mythos_atexit( atexit_2 ))
    {
        cout << " Error registering atexit 2!\n";
    }
    else
    {
        cout << "Atexit 2 registered.\n";
    }

    if (mythos_atexit( atexit_3 ))
    {
        cout << " Error registering atexit 3!\n";
    }
    else
    {
        cout << "Atexit 3 registered.\n";
    }

    mythos_atexit_remove( atexit_2 );
    cout << "Removed atexit 2\n";
}

// End of module - sysmain.cpp 

