// IMGLIB_015.h : main header file for the IMGLIB_015 DLL
//
/*
 * Copyright (c) 2000-2001 Wenny Macura
 *
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL WENNY MACURA BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#if !defined   (AFX_IMGLIB_015_H__9FBB2D46_4016_11D5_97D2_0002E3037323__INCLUDED_)
#define AFX_IMGLIB_015_H__9FBB2D46_4016_11D5_97D2_0002E3037323__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif                           // _MSC_VER > 1000
//#include "TIFF_V357.h"

#ifndef __AFXWIN_H__
#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"            // main symbols
#include "ImgClass.h"
//#include "HdrClass.h"
#include <afxinet.h>
#include <math.h>
#include "TIFF_V357.h"

//#define     EXPORT_TII_DLL 1


#ifdef EXPORT_TII_DLL
#define IMGLIB_015_API __declspec(dllexport)
#else
#define IMGLIB_015_API __declspec(dllimport)
#endif

#define CHECK_BOUNDS(a,b) { if ( a < 0) a= 0; if ( a > b ) a =b; }

/* Function Definitions	*/

// START of FUNCTION DEFS

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	char *GetDll_Version();
//	FUNCTION:
//		Return the Library version as a string
//	RETURN:
//		Char Pointer to the LibVersionString
//	POSTED ERRORS:
//		NONE
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char *GetDll_Version();

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	void SetRW_Progress( PF Rd_Prog, PF Wr_Prog );
//	FUNCTION:
//		Allows user tod define his Read and or Write Progress functions
//		The function pointer is defined as
//			typedef void(*PF) (int,int);
//		If SetRW_Progress(..) is not called,or the arguments are NULL,
//		and the library will not process the Progress functions.
//
//	RETURN:
//		while processing the ImgData this function is called every 10% of the
//		Total number of lines processed
//	POSTED ERRORS:
//	NOTE:
//
//	Rd_Prog is a pointer to a local Read_Progress function
//	Wr_Prog is a pointer to a local Write_Progress function
//	Rd_Prog and Wr_Prog may be the same function.
//		I have created a global function:
//	ReadProgress( int TotalLines, int Current_Line);
//		Then a function pointer was cerated as
//	PF Prog;
//  and ReadProgress is passed to the pointer:
//	Prog = &RdProgress;
//				Then call SetRW_Progress(..)
//	One function handles both Read and Write
//	SetRW_Progress( Prog,Prog );
//	EXAMPLE of ReadProgress(...);
//
//	CProgressCtrl	m_Progress;		//define  somewhere
//
//void ReadProgress(int TotalLines, int Current_Line)
//{
//	static	int	TotalNoLines =0;	// keep track of the total no of lines
//									// this will change hopefully for different images
//	if ( TotalLines != TotalNoLines)
//	{
//		m_Progress.SetRange(0,TotalLines);	// set the range
//	}
//	m_Progress.SetPos( Current_Line);		// set the progress position
//	return;
//}
// to initiate you may call
//	ReadProgress(0,0);
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
// pointer to a progress function
typedef void(*PF) (int,int);
IMGLIB_015_API  void SetRW_Progress( PF Rd_Prog, PF Wr_Prog );

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool RGB_to_BW( ImgClass *Img );
//	FUNCTION:
//		Convert RGB image to BW image.
//		Conversion 	Function:
//				BW = 0.33*Red + 0.5*Green + 0.17*Blue))
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//		"RGB_to_BW Img->ImgStruct.ImgData = NULL"
//			if Img->ImgStruct.ImgData is NULL (empty)
//	NOTE:
//		The ImgData is not re-allocated, The BW image occupies the same memory
//		Space as the COLOR image
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool RGB_to_BW( ImgClass *Img );

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//	IMGLIB_015_API	bool	GetSingleColor
//	(
//			ImgClass *In,
//			ImgClass *Out,
//			int color
//	);
//	FUNCTION:
//		Obtain a single color chanel from a RGB or BW Image.
//		Calling this function with In beeing BW image is ruther fruitless ???
//
//		The single color Image is returned in Out,
//		This function allocates the memory space for Out->ImgStruct.ImgData
//		Color	Representation:
//			color = 0 Red;
//			color = 1 Green;
//			color = 2 Blue
//
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	1]	"GetSingleColor::ImgClass::In is NULL"
//			the In image is not specified
//	2]	"GetSingleColor ImgClass::Out is NULL"
//			The Out Image is not specified
//	3]	"GetSingleColor:: color out of range [0,1,2]"
//			The color specified is no one of 0,1 or 2
//	4]	"GetSingleColor:: In->ImgData = NULL"
//			The In image has no ImgData specified
//	5]	"GetSingleColor:: Can't Get %d color out of B/W image",color);
//			The In image is BW and the color was not 0
//	6]	"GetSingleColor:: Output memory allocation ERROR"
//			The memory for Out->ImgStruct.ImgData could not be allocated
//	NOTE:
//	GetSingleColor(ImgClass *In,ImgClass *Out,int color)
//	Get a single color from a RGB image in In and place it into Out
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    GetSingleColor(ImgClass *In,ImgClass *Out,int color);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	YCCtoRGB(ImgClass *In);
//	FUNCTION:
//		Converts a YCC image to RGB
//		Algorithm:
//			r  -= 128;
//			g -= 128;
//			b -= 128;
//
//			Y = r+b;
//			Cb = r - 0.3341*g - 0.7142*b;
//			Cr = r + 1.7718 * g;
//			*Dptr++ = (byte)Y + 128;
//			*Dptr++ = (byte)Cb + 128;
//			*Dptr++ = (byte)Cr + 128;
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	1]	"YCCtoRGB  Image is NULL"
//	2]	"YCCtoRGB  Image is BW"
//	NOTE:
//		The Convert assumes no subsampling of the YCC image
//		Used by ReadImage(...) private !!!
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    YCCtoRGB(ImgClass *In);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	RGBtoYCC(ImgClass *In);
//	FUNCTION:
//		Convert RGB Image to YCC
//		Algorithm:
//			r -= 128;
//			g -= 128;
//			b -= 128;
//			Y = 0.299*(r - g) + g + 0.114*(b-g);
//			Cb = 0.564*(b - Y);
//			Cr = 0.713*(r - Y);
//			*Dptr++ = (byte)Y	+	128;
//			*Dptr++ = (byte)Cb	+	128;
//			*Dptr++ = (byte)Cr	+	128;
//
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	1]	"RGBtoYCC  Image is NULL"
//			NoImage specified
//	2]	"RGBtoYCC  Image is BW"
//			The RGB Image is actualyy BW Image
//	NOTE:
//		There is sub-sumpling done for the YCC Image
//		Used by WriteTII_TIFF(... )	Private	!!!
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    RGBtoYCC(ImgClass *In);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//	IMGLIB_015_API	bool	OPen_Inet(void);
//
//	FUNCTION:
//		Opens a network connection to the Image Server
//		Must be precceeded by Put_Server(..) !!!
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	1]	"OPen_Inet: Can't determine TEMP path"
//			The system temporary path could not be determined
//	2]	"Icom_FTP::OpenFTP:Invalid Server URL"
//			The Server URL could not be resolved
//	3]	All of Microsoft CInternetExceptions
//
//	NOTE:
//		The Image Server communicates via FTP with the library
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    OPen_Inet(void);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Close_Inet();
//	FUNCTION:
//		Closes the FTP connection to the Image Server
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//		none
//	NOTE:
//	Closes the connection to the ImageServer
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
                                 //DONE
IMGLIB_015_API  bool    Close_Inet();

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	char	*Get_Last_Error();
//	FUNCTION:
//		Get the pointer to Last Error message,
//	RETURN:
//		char * to the Error
//	POSTED ERRORS:
//		NONE
//	NOTE:
//		Obtain the last execution Library Error
//		The Errors are pushed on the Error Stack, Get_Last_Error return the pointer
//		to the Error stack.
//		The Error stack is not vleared by Get_Last_Error.
//		To clear the Error Stack call Post_Error("");
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
                                 //DONE
IMGLIB_015_API  char    *Get_Last_Error();

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Put_Server( char *ServerInfo);
//	FUNCTION:
//		Assign the Library Server info.
//		ServerInfo is a string containig Host,Server,User,Password
//			Host:		should be the Name of the calling computer but may be anything
//			Server:		Name or an IP address of the Image Server
//			User:		User name, as on the Image Server, this user must have an account on the Image Server
//			Password:	Password for the Image Sever
//	RETURN:
//		true	on any		ERROR
//		false	on normal	EXIT
//	POSTED ERRORS:
//		"Put_Server ServerInfo is NULL";
//	NOTE:
//		Host may be ommited but then ServerInfo must start with a leading ',' as ",Server,User,Password"
//		if Server is empty no connection will be established as Host,,User,Password
//		At this time the Password is not encrypted. (:-o
//		ServerInfo may be an empty string, which cleares the library's Server Information
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Put_Server( char *ServerInfo);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	char	*Get_Server();
//	FUNCTION:
//		Get a pointer to the Library Server info string
//		The Error stack is cleared on entry
//		The Host Name is not returned
//		if a parameter is not initiated "NONE" is returned
//	RETURN:
//		char * to the ServerInfo
//		char * to an empty string
//	POSTED ERRORS:
//	NOTE:
//	Get the server Information as set by Put_Server(...)
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char    *Get_Server();

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//		Get_Remote_File
//		(
//			char *RemoteFileName,
//			char *LocalFileName,
//			int Wait
//		);
//	FUNCTION:
//		Obtain RemoteFile from the Server and copy it to LocalFile
//		wait for max Wait seconds to complete the transfer
//		Wait is a maximut time to wait for the Image in seconds.
//		When Wait expires true is returned,
//		The function wil not overwrite the local file, and returns true
//		if the file already exists.
//
//	POSTED ERRORS:
//		"CCOM_Tii_Obj_010::Get_Remote_File(..) File %s exists",LocalFileName);
//		"CCOM_Tii_Obj_010::Get_Remote_File(..) remote=%s local=%s FAILED\n",Remote,Local);
//		"Icom_FTP::GetRemoteFile: m_pFtpConnection is NULL, call Open_Inet first");
//		"Icom_FTP::GetRemoteFile:Can't determine TEMP path"
//		"Icom_FTP::GetRemoteFile: faild in obtaining RemoteFileName from the Server"
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	NOTE:
//		Get_Remote_File does not check for the prsence of remote file
//		and times out after Wait seconds ( should be changed wm)
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Get_Remote_File( char *RemoteFileName, char *LocalFileName, int Wait);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//	IMGLIB_015_API	bool
//		GetRemoteDir
//		(
//			char *Dir,
//			char *Files,
//			int FileLenght,
//			int NoFiles
//		);
//	FUNCTION:
//		Obtain the remote directory and place it into Files
//		Dir is a string pointing to the remote directory ("./" ) beeing the top directory
//		Obtains the remote directory, places the entries into array Files
//		Files is an array of strings as Files[NoFiles][FileLength]
//
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//		"GetRemoteDir::Failed to Open Remote Directory [ Dir ] "
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    GetRemoteDir(char *Dir,char *Files, int FileLenght, int NoFiles);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	PlaceCommand( char *LocalFile );
//	FUNCTION:
//		places the command file Localfile, to the Image Server command dirctory
//		if the connectio to the server is not opend, will try to open the connection
//		and transfer the file to the Image Server.
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//		"Icom_FTP::SendCommandToServer: No Server connection"
//		"Icom_FTP::SendCommandToServer: PutFile Failed"
//	NOTE:
//	Copy  Local Command File to the ImageServer
//	Used internally DO NOT USE !!
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    PlaceCommand( char *LocalFile );

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	char	*ZoomImageRemote
//		(
//			int Xpos, int Ypos,
//			int ImgW, int ImgH,
//			CRect *Crop,
//			double Magnification,
//			int	Quality,
//			char	*ImageHdr
//		);
//	FUNCTION:
//		Error stack is cleared on entry
//		If Connection to the Server is not established, it will be opend.
//		Zoom image remote will ask the Image Server to generate an image on the Image Server,
//		This image will represent a crop area of the original image, as defined in the ImageHdr file.
//		If Crop is not empty, it is assumed that ImgW and ImgH represens the user display
//		of the Crop rectangle, and And the disered Magnification is within the Crop.
//		If Crop is empty, then ImgW, ImgH represent the entire as displayed by the user.
//
//		The crop region is generated from the eoriginal image and subsampled to the
//		ImgW,ImgH parameters.
//
//		Parameters:
//			Xpos, Ypos:
//				Center of the desired Zoom region in display coordinates.
//				Xpos, Ypos should be within ImgW, ImgH
//			ImgW, ImgH:
//				Size of the clients Display region in display coordinates.
//
//			Magnification:	Desired ZoomFactor
//
//			Quality:
//				JPG quality factor 1 to 100
//				If Quality == 0	the resulting Image is TIFF
//			Image:
//				Name of the ImageHeader file to be Zoomed.
//				Tis file is assumed to reside on the Image Server
//			Crop:
//				If empty, indicates that ImgW x ImgH reprsents the entire Image.
//				If non empty indicates that ImgW,ImgH represents this Crop rectangle
//

//	RETURN:
//		NORMAL EXIT:
//			ImageName of the generated zoomed Inage.
//			This image id resident on the Server in the ./NetImages directory.
//			This image should be retrieved by GetRemoteFile(...)
//
//		ERROR:	an empty string as ""
//
//	POSTED ERRORS:
//		"ZoomImageRemote: Can't determine TEMP path"
//		"ZoomImageRemote fabs(Magnification) < 1.0"
//		"ZommImageRemote: CropRct is empty"
//			Error in calculating new Crop rectangle.
//		"ZommImageRemote: CropRct is larger than Image"

//	NOTE:
//		If len of ZoomImageRemote is <= 0 examine the Get_Last_Error
//		Only the Image_Name is returned.
//		The Image will reside on the Image Server. See  NORMAL EXIT above.
//
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char    *ZoomImageRemote
(
int Xpos, int Ypos,
int ImgW, int ImgH,
CRect *Crop,
double Magnification,
int Quality,
char    *ImageHdr
);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//	IMGLIB_015_API	char	*ZoomImageLocal
//	(
//		int Xpos, int Ypos,
//		int ImgW, int ImgH,
//		CRect	*Crop,
//		double Magnification,
//		int	Quality,
//		ImgClass	*Src	//The Source image.
//	)
//
//	FUNCTION:
//		See ZoomImageRemote above.
//		[1]	Produce an Output file from an Image
//		Instead of ImageHdr file an Image pointer is processed

//	RETURN:
//		NORMAL EXIT:
//			ImageName of the generated zoomed Inage.
//			This image is local and fully qualified path is returned.
//
//		ERROR:	an empty string as ""
//
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char    *ZoomImageLocal
(
int Xpos, int Ypos,
int ImgW, int ImgH,
CRect   *Crop,
double Magnification,
int Quality,
ImgClass    *Src                 //The Source image.
);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//	IMGLIB_015_API	char	*ZoomImageLocal
//	(
//		int Xpos, int Ypos,
//		int ImgW, int ImgH,
//		CRect	*Crop,
//		double Magnification,
//		int	Quality,
//		ImgClass	*Src,
//		ImgClass	*Dest
//	)
//
//	FUNCTION:
//		See ZoomImageRemote above.
//		[1]	Produce an Output Image from an Image
//		Instead of ImageHdr file an Image pointer is processed
//		The quickest of of the ZoomImageLocals
//		The returned filename is not relevant.
//
//	RETURN:
//		NORMAL EXIT:
//			ImageName of the generated zoomed Inage.
//			This image is local, and fully qualified path is returned.
//
//		ERROR:	an empty string as ""
//
//	POSTED ERRORS:
//	NOTE:
//	[2] Produce an output Image from a source Image
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char    *ZoomImageLocal
(
int Xpos, int Ypos,
int ImgW, int ImgH,
CRect   *Crop,
double Magnification,
int Quality,
ImgClass    *Src,
ImgClass    *Dest
);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//	IMGLIB_015_API	char	*ZoomImageLocal
//	(
//		int Xpos, int Ypos,
//		int ImgW, int ImgH,
//		CRect *Crop,
//		double Magnification,
//		int	Quality,
//		char	*ImageHdr
//	)
//
//	FUNCTION:
//		See ZoomImageRemote above.
//		This is the full local equivalent of ZoomImageRemote
//		The returned filename is not relevant.
//
//	RETURN:
//		NORMAL EXIT:
//			ImageName of the generated zoomed Inage.
//			This image is local, and fully qualified path is returned.
//
//		ERROR:	an empty string as ""
//
//	POSTED ERRORS:
//	NOTE:
//	[2] Produce an output Image from a source Image
//	[3] Produce an output file from a source file
//	same as ZoomImageRemote slow, try to avoid using it
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char    *ZoomImageLocal
(
int Xpos, int Ypos,
int ImgW, int ImgH,
CRect *Crop,
double Magnification,
int Quality,
char    *ImageHdr
);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	GetCropImage
//		(
//			int ImgW,			// destination Image Width in pixels
//			CRect *Crop,		// Cop Rect in Image Coordianets
//			char	*ImageHdr,	//Image name or header file
//			ImgClass *Dest		// destination image
//		);
//	FUNCTION:
//		Get a crop region as an Image of an image, deescribed in ImageHeader.
//		The resulting crop image is subsampled to ImgW, aspect is preserved
//
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    GetCropImage
(
int ImgW,
CRect *Crop,
char    *ImageName,              //Image name or header file
ImgClass *Dest
);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	char*	GetCropImageRemote
//		(
//			int ImgW,
//			CRect *Crop,
//			char	*ImageName,	//Image name or header file
//			int	Quality
//		);
//	FUNCTION:
//		Same as GetCropImage(...)
//		returns the file name of the generated image.
//		use Get_Remote_File (File name ) to obtain the image from the ImageServer
//	RETURN:
//		char * Image Name on the Image Server
//		empty string
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char*   GetCropImageRemote
(
int ImgW,
CRect *Crop,
char    *ImageName,              //Image name or header file
int Quality
);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	char	*Get_Temp_Path();
//	FUNCTION:
//	return the current Dll's temp path.
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
//	return the current Dll's temp path.
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char    *Get_Temp_Path();

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Reset_IcomDb();
//	FUNCTION:
//		Reset all teh Library, temporaray image parameters
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
//	Reset all the Dll parameters.
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Reset_IcomDb();

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//	IMGLIB_015_API	bool	Make_Local_Header(char *ImageFile,char *OutFile);
//	FUNCTION:
//		Produce a loacal Header.
//		Outfile is an optional ouput file name.
//
//		If OutFile is an ampty string or NULL, then the Header file
//		will have the same name as the ImageFile but the extention will be ".hdr".
//		The OutFile will be placed in the directory of the ImageFile.
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Make_Local_Header(char *ImageFile,char *OutFile);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//		Make_Local_Tnl
//		(
//			int Quality,
//			int Size,
//			char *HdrFile,
//			char *Outfile
//		);
//	FUNCTION:
//		Produce a loacal Thumbnail file.
//		Outfile is an optional ouput file name.
//		If OutFile is an empty string, then the Header file
//		will have the same name as the ImageFile but the extention wil be ".tnl".
//		The OutFile will be placed in the Dll's temp directory.
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Make_Local_Tnl(int Quality, int Size, char *HdrFile,char *Outfile);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//			Make_Local_Tnl
//			(
//				int Quality,
//				int Size,
//				char *HdrFile,
//				char *Outfile,
//				ImgClass *Src
//			);
//	FUNCTION:
//		Produce local thumbnail file
//		If Outfile == "" and Src->ImgStruct.ImgData == NULL then
//		Src is the destination Image for the Thumbnail.
//		The resulting file will have a ".tnl" extention
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Make_Local_Tnl(int Quality, int Size, char *HdrFile,char *Outfile,ImgClass *Src);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	double	Get_Aspect( char *HdrFile);
//	FUNCTION:
//		Get the iamge Aspect ratio from a Header file
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
//	returns the Image Aspect ratio.( Width /Height
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  double  Get_Aspect( char *HdrFile);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Get_Image_Dimension( char *HdrFile,int *Width, int *Height);
//	FUNCTION:
//		Get the Image Dimensions fro a Header file
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
//	Obtain the Image Width and Heigth
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Get_Image_Dimension( char *HdrFile,int *Width, int *Height);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//		Get_Image_Res
//		(
//			char *HdrFile,
//			double *Xres,
//			double *Yres,
//			int *ResType
//		);
//	FUNCTION:
//		Get the Image resolution fro a Header file
//		Xres, Yres:	X-Y Resolution.
//		ResType:	The Res type is same as TIFF
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Get_Image_Res( char *HdrFile,double *Xres, double *Yres, int *ResType);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	ReadImage( bool RGBSwap, ImgClass *Img );
//	FUNCTION:
//		RGBSwap:		true		Swap the Red and Blue channels of an Image
//						fasle		No action
//		Special:
//			if Img->ImgStruct.ShouldRotate is one of ROTATE ( see ImgClass.h )
//			and Rotated is false the image will be rotated on read;
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    ReadImage( bool RGBSwap, ImgClass *Img );

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//		ScaleImage
//		(
//			ImgClass *From,
//			double XScale,
//			double YScale,
//			ImgClass *To
//		);
//	FUNCTION:
//		Scale Image From to To by XScale and YScale
//		if YScale == -1.0	teh Image aspect ratio is preserved
//		and the image is scled by XScale
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    ScaleImage(ImgClass *From, double XScale, double YScale,  ImgClass *To);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//		Low_Memory_ScaleImage
//		(
//			bool Compress,
//			ImgClass *From,
//			char *To,
//			double XScale,
//			double YScale
//		);
//	FUNCTION:
//		Slow but low memory usage:
//		From and To are just filenames
//		Scale Image From to To by XScale and YScale
//		if YScale == -1.0	them XScale is used for both axis
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Low_Memory_ScaleImage(bool Compress, ImgClass *From, char *To, double XScale, double YScale);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//		SubsampleLocalImage
//		(
//			ImgClass *In,
//			ImgClass *Out,
//			int OutX,
//			int OutY
//		);
//	FUNCTION:
//		Subsample Image In to Out
//		OutX:	no of resulting pixels.
//		OutY:	no of resulting lines
//
//		If OutY == -1 then the Aspect ratio of In is preserved.
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    SubsampleLocalImage(ImgClass *In, ImgClass *Out,int OutX,int OutY);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	WriteTII_TIFF(bool compress, bool bgr,ImgClass * Out);
//	FUNCTION:
//		Write an Image as a TIFF file.
//		compress:	If true, the output image will be LZW compressed
//		bgr:		If true	the Image hs the Red and Blue channels swaped
//					before writing
//		the Img->ImgStruct.File must be a fully qualified image name
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
// Private do not use, you will not be able te read the image
// Only ReadImage(..) sees this option
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    WriteTIFF(bool compress, bool bgr,ImgClass * Out);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	DO NOT USE
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	WriteTII_TIFF(bool compress, bool bgr,ImgClass * Out);
//	FUNCTION:
//		Write an Image as a special TIFF file.
//		compress:	If true, the output image will be LZW compressed
//		bgr:		If true	the Image hs the Red and Blue channels swaped
//					before writing
//		the Img->ImgStruct.File must be a fully qualified image name
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
// Private do not use, you will not be able te read the image
// Only ReadImage(..) sees this option
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    WriteTII_TIFF(bool compress, bool bgr,ImgClass * Out);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	WriteJPEG( int Quality, ImgClass *Img);
//	FUNCTION:
//		Write an Image as a JPEG file
//		the Img->ImgStruct.File must be a fully qualified image name
//		Quality range is 1 to 100
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
IMGLIB_015_API  bool    WriteJPEG( int Quality, ImgClass *Img);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Write_8BitPPM( ImgClass *Img);
//	FUNCTION:
//		Write an Image as a 24 bit PPM file
//		the Img->ImgStruct.File must be a fully qualified image name
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
IMGLIB_015_API  bool    Write_8BitPPM( ImgClass *Img);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Write_8BitPGM( ImgClass *Img);
//	FUNCTION:
//		Write an Image as an eight bit Gray (PGM)
//		the Img->ImgStruct.File must be a fully qualified image name
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
IMGLIB_015_API  bool    Write_8BitPGM( ImgClass *Img);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Write_BMP( ImgClass *Img);
//	FUNCTION:
//		Write an Image as a 24 bit Bitmap file
//		The Img->ImgStruct.File must be a fully qualified image name
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
IMGLIB_015_API  bool    Write_BMP( ImgClass *Img);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	!!!	Do not Use	!!!!
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  CFtpConnection *GetFTPConnection();

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//		GetImageRectangle	(char *File, CRect Rct, ImgClass *Img);
//	FUNCTION:
//		Get a crop rectangle, from a fully qualified image path, File
//		CRect:		Represennts the Crop rectangle in Image coordinates
//		Img:		Destination Image
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    GetImageRectangle(char *File, CRect Rct, ImgClass *Img);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//		Convert_Image
//		(
//			char *In,
//			char *Out,
//			int Type,
//			int Quality
//		);
//	FUNCTION:
//		Convert image from one type to another and write the image out
//		Type must be one of IMG_TYPE
//			TIFF_FILE,
//			JPEG_FILE,
//			PPM_FILE,
//			PGM_FILE,
//			BMP_FILE,
//			TII_FILE,		// do not use
//			F_PBMASCII,		// do not use
//			F_PBMRAW		// do not use
//		Quality is used only for JPEG_FILE
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
//		See ImgClass.h for types and IMG_TYPE
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Convert_Image( char *In, char *Out, int Type, int Quality);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Read_Hdr( char *ImgHdr, IMAGE_HDR *hdr);
//	FUNCTION:
//		Fill the IMAGE_HDR structure from a ImgHdr Header file
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Read_Hdr( char *ImgHdr, IMAGE_HDR *hdr);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Rotate_Image( ImgClass	*InImg, int Rotation);
//	FUNCTION:
//		Rotate an Image InImg;
//		Rortation is one of	ROTATE see ImgClass.h
//			NO_ACTION,
//			CW90,			//clockwise 90
//			CCW90,			// counter clock wise
//			CW180,			// 180 degrees
//			TOP_BOT,		// flip top bottom
//			LEFT_RIGHT		// flip left to right
//
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Rotate_Image( ImgClass  *InImg, int Rotation);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool
//		Image_Diff
//		(
//			ImgClass	*Src1,
//			ImgClass	*Src2,
//			ImgClass *Dest
//		);
//	FUNCTION:
//		Produce a difference Image  between Src1 and Src2 and place the image into Dest.
//		If Dest is NULL, the difference is placed into Src2
//		The images must have identical ImgStruct parameters mainly pixels,lines and nCh
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Image_Diff ( ImgClass   *Src1, ImgClass *Src2, ImgClass *Dest);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	GetCropRect( CRect *Crp);
//	FUNCTION:
//		Obtain the Library's Crop Rectangle
//		should be used after Zoom
//		Empty Crop Rectangle Generates Error;
//
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//		None;
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    GetCropRect( CRect *Crp);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Swap_RGB( ImgClass *Img);
//	FUNCTION:
//	Swap the red and blue channels, ImgClass keeps the data in RGB
//	ImgClass.ImgStruct.BGR is set appropriatelly
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  bool    Swap_RGB( ImgClass *Img);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	bool	Post_Error ( char *Str );
//	FUNCTION:
//		Push the Str on the Error stack
//	RETURN:
//		true	on any ERROR
//		false	on	normal EXIT
//	POSTED ERRORS:
//	NOTE:
//		Call Post_Error with an empty string to clear the Error stack
IMGLIB_015_API  bool    Post_Error ( char *Str );

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	char	*Get_FileName_From_HDR( char *HdrFile);
//	FUNCTION:
//		Get Image file name file name from a Header file
//	RETURN:
//		char * to the image file name
//	POSTED ERRORS:
//	NOTE:
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char    *Get_FileName_From_HDR( char *HdrFile);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
//	NAME:
//		IMGLIB_015_API	char	*MakeTemp_FileName(char *FileName, char *Extention);
//	FUNCTION:
//		Convert a fully qualified FileName, to a fully qualified file name in the TEMP
//		directory.
//		if Extention is not an empty string, change the file extention to Extention.
//		The extention should not contain the leading '.'
//	RETURN:
//		char	* to a temporay file
//		char	* to Library's Temporay Path
//	POSTED ERRORS:
//	NOTE:
//	If FileName is an empty string, The Temporay path is returned
//	If Extention is an empty string, the extention is not changed
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
IMGLIB_015_API  char    *MakeTemp_FileName(char *FileName, char *Extention);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * set the Tepmprary path to ather then system default
 * ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
IMGLIB_015_API  void Set_Temp_Path(char *Tmp_Path);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Remove all temp files generated
 * ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
IMGLIB_015_API  void Cleanup(char *Dir);

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *	Find the first occurence of a file on all the disk drives
 * ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
IMGLIB_015_API  char *Find_File ( char *FileName );

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Obtain the recognized image type, see Imglib_structures.h
 * -1 is returnd if type is not recognized
 * ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
IMGLIB_015_API  int Get_File_Type ( char *FileName );

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Calculate a gamma table for specifiv Gamma
 * The resulting array Gam_Array is an int array  of the size ArrSize
 * ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
IMGLIB_015_API  void    Set_Gamma ( double Gamma, int *Gam_Array, int ArrSize );

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Determines if a FileName is en empty file.
 * if length of the file == 0 returns true.
 * ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
IMGLIB_015_API  bool    IsEmptyFile ( char *FileName );
IMGLIB_015_API  bool    IsEmptyFile ( char *FileName, __int64 *Size );

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Determines and obtain pointers to Image histgrams
 * ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
IMGLIB_015_API  void    GetHistogram ( ImgClass *Image, int *Red,int *Grn, int *Blu );

// END of FUNCTION DEFS
/*
#ifdef EXPORT_TII_DLL
// CIMGLIB_015App
// See IMGLIB_015.cpp for the implementation of this class
//
//extern	Utility	*pUtility;
class CIMGLIB_015App : public CWinApp
{
    public:
        CIMGLIB_015App();

        // Overrides
        // ClassWizard generated virtual function overrides
        //{{AFX_VIRTUAL(CIMGLIB_015App)
        //}}AFX_VIRTUAL

        //{{AFX_MSG(CIMGLIB_015App)
        // NOTE - the ClassWizard will add and remove member functions here.
        //    DO NOT EDIT what you see in these blocks of generated code !
        //}}AFX_MSG
        virtual ~CIMGLIB_015App();
        //	Utility	*pUtility;
        DECLARE_MESSAGE_MAP()
};
#endif
*/
/*
/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.
*/
#endif                           // !defined(AFX_IMGLIB_015_H__9FBB2D46_4016_11D5_97D2_0002E3037323__INCLUDED_)
