/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import photoorganizer.formats.Entry;
import photoorganizer.formats.Exif;
import photoorganizer.formats.Naming;

class PropertiesTableModel
extends AbstractTableModel {
    final String[] columnnames = new String[]{"Tag", "Type", "Value"};
    private Vector tags = new Vector();
    private Exif exif;
    private boolean flag_main_image;

    public PropertiesTableModel(Exif exif) {
        this(exif, true);
    }

    public PropertiesTableModel(Exif exif, boolean bl) {
        this.setExif(exif, bl);
    }

    public void setExif(Exif exif) {
        this.setExif(exif, true);
    }

    public void setExif(Exif exif, boolean bl) {
        this.exif = exif;
        this.flag_main_image = bl;
        if (exif == null) {
            return;
        }
        Enumeration enumeration = exif.tags(this.flag_main_image);
        while (enumeration.hasMoreElements()) {
            this.tags.addElement(enumeration.nextElement());
        }
    }

    public int getRowCount() {
        return this.tags.size();
    }

    public int getColumnCount() {
        return this.columnnames.length;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return Naming.getTagName((Integer)this.tags.elementAt(n));
        }
        Entry entry = this.exif.getTagValue((Integer)this.tags.elementAt(n), this.flag_main_image);
        switch (n2) {
            case 1: {
                return Naming.getTypeName(entry.getType());
            }
            case 2: {
                return entry;
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        return this.columnnames[n];
    }
}

