/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.album.Access;
import photoorganizer.album.AlbumModel;
import rogatkin.GranulatedLayout;

public class AlbumSelectionPanel
extends JPanel
implements ActionListener {
    JCheckBox cb_include;
    JTree t_all_albums;
    JTextField tf_album;

    public AlbumSelectionPanel(Controller controller, TreeModel treeModel) {
        this.setLayout(new GranulatedLayout(5, 12, 24, 4));
        this.t_all_albums = new JTree(treeModel);
        this.add((Component)new JScrollPane(this.t_all_albums), "0,1,5,8,28,12");
        this.tf_album = new JTextField();
        this.add((Component)this.tf_album, "0,9,2,1,32");
        JButton jButton = new JButton("Create a new album", UIManager.getIcon("FileChooser.newFolderIcon"));
        this.add((Component)jButton, "2,9,2");
        jButton.addActionListener(this);
        this.cb_include = new JCheckBox("add to selcted albums");
        this.add((Component)this.cb_include, "0,10,3,1,32");
        this.cb_include.setToolTipText("Check it, if the new created album has to be included to selected");
        JLabel jLabel = new JLabel();
        this.add((Component)jLabel, "0,0,5,12,6,18");
        jLabel.setBorder(new TitledBorder(new BevelBorder(0), "Name of the album"));
        jLabel.setOpaque(false);
    }

    public TreePath[] getSelectedAlbums() {
        return this.t_all_albums.getSelectionPaths();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Create a new album")) {
            int n;
            Access access = ((AlbumModel)this.t_all_albums.getModel()).access;
            String string2 = this.tf_album.getText().trim();
            if (string2.length() == 0) {
                return;
            }
            TreePath[] treePathArray = this.getSelectedAlbums();
            int[] nArray = new int[]{0};
            if (this.cb_include.isSelected() && treePathArray != null && treePathArray.length > 0) {
                nArray = new int[treePathArray.length];
                n = 0;
                while (n < treePathArray.length) {
                    nArray[n] = access.getAlbumId(treePathArray[n]);
                    ++n;
                }
            }
            n = access.createAlbum(string2);
            access.insertAlbumToAlbum(nArray, n);
            if (nArray[0] == 0) {
                this.refresh(new Object[]{this.t_all_albums.getModel().getRoot()});
            } else {
                int n2 = 0;
                while (treePathArray != null && n2 < treePathArray.length) {
                    this.refresh(treePathArray[n2].getPath());
                    ++n2;
                }
            }
            this.tf_album.setText("");
        }
    }

    void refresh(Object[] objectArray) {
        ((AlbumModel)this.t_all_albums.getModel()).fireTreeStructureChanged(this, objectArray, null, null);
    }
}

