/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import photoorganizer.Controller;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.Thumbnail;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.ThumbnailsPanel;

public class AlbumThumbnailsPanel
extends ThumbnailsPanel {
    public AlbumThumbnailsPanel(Controller controller) {
        super(controller);
        this.albumpanel.setTumbnailsPanel(this);
    }

    void setImageView() {
        this.imagepanel = (PhotoImagePanel)this.controller.component(Controller.COMP_IMAGEALBUMPANEL);
    }

    JPopupMenu getRightButtonMenu(ActionListener actionListener, boolean bl) {
        return new AlbumThumbsRightBtnMenu(actionListener);
    }

    void doSpecificAction(BasicJpeg basicJpeg, ActionEvent actionEvent, Thumbnail thumbnail) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Show")) {
            this.showFullImage(basicJpeg, thumbnail);
        } else if (string.equals("Delete")) {
            this.albumpanel.deletePicture(basicJpeg.getLocationName());
            this.remove((Component)((Object)thumbnail));
            this.adjustDimension();
        } else if (string.equals("Add comment")) {
            String string2 = this.albumpanel.getCommentOf(basicJpeg.getLocationName());
            if ((string2 = (String)JOptionPane.showInputDialog(this, "Type a commentary", "Commentary", 3, null, null, string2)) != null) {
                this.albumpanel.setCommentTo(basicJpeg.getLocationName(), string2);
                thumbnail.update();
            }
        } else if (string.equals("To selection")) {
            this.collectionpanel.add(new File(basicJpeg.getLocationName()));
        } else if (string.equals("Print")) {
            this.controller.print(new File[]{new File(basicJpeg.getLocationName())});
        }
    }

    public String getImageTitle(BasicJpeg basicJpeg, boolean bl) {
        String string = this.albumpanel.getCommentOf(basicJpeg.getLocationName());
        if (string == null || string.length() == 0) {
            string = super.getImageTitle(basicJpeg, bl);
        }
        return string;
    }

    class AlbumThumbsRightBtnMenu
    extends JPopupMenu {
        AlbumThumbsRightBtnMenu(ActionListener actionListener) {
            JMenuItem jMenuItem = new JMenuItem("Show");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem = new JMenuItem("To selection");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("Delete");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("Add comment");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("Print");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
        }
    }
}

