void __fastcall TDesignForm::cmdOpenMeshClick(TObject*) {
  TTreeNode* Node = CurrentFrameNode();
  if (!Node) return;

  OpenDlg->Title = "Open Mesh";
  OpenDlg->FileName = "";
  OpenDlg->Filter = "X files (*.x)|*.x";
  OpenDlg->DefaultExt = "*.x";
  if (!OpenDlg->Execute()) return;
  StatBar->SimpleText  = "Opening Mesh...";
  StatBar->SimplePanel = true; StatBar->Update();
  AnsiString name = OpenDlg->FileName;

  LPDIRECT3DRMMESHBUILDER IBuilder;
  try {
  TTreeNode *NewNode;
  IRM->CreateMeshBuilder(&IBuilder);
  LPDIRECT3DRMFRAME Iparent = ASFRAME(Node->Data);

  hr = IBuilder->Load(name.c_str(), OnTextureLoad,
                            D3DRMLOAD_FROMFILE, NULL, NULL);

  if (HR_FAILED(hr)) {
     AnsiString Error = "Could't load mesh\nHRESULT = ";
     Error += HRString(hr);
     Application->MessageBox(Error.c_str(), "Load error",
                                        MB_ICONEXCLAMATION);
     goto LoadError;
  }
  Iparent->AddVisual(IBuilder);
  name = ExtractFileName(name);
  //    "."    Direct3DRM:
  name = ChangeFileExt(name, "");
  IBuilder->SetName(name.c_str());
  NewNode = Tree->Items->AddChild(Node, name);
  NewNode->Data = IBuilder;
  Node->Expanded = true;
  Tree->Selected = NewNode;
  Changed();

  } catch (Exception &exception) {
      Application->ShowException(&exception);
  }
LoadError:
  D3dView->Render();
  RELEASE(IBuilder);
  StatBar->SimpleText  = ""; StatBar->Update();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdOpenFrameClick(TObject*) {
  TTreeNode* Node = CurrentFrameNode();
  if (!Node) return;

  OpenDlg->Title = "Open Frame";
  OpenDlg->FileName = "";
  OpenDlg->Filter = "X files (*.x)|*.x";
  OpenDlg->DefaultExt = "*.x";
  if (!OpenDlg->Execute()) return;
  StatBar->SimpleText  = "Opening Frame...";
  StatBar->SimplePanel = true;  StatBar->Update();
  AnsiString name = OpenDlg->FileName;

  try {
  LPDIRECT3DRMFRAME Iframe = ASFRAME(Node->Data);

  int mb = Application->MessageBox(
  "The file may contain objects with names used in this \
scene.\n Do you want to load them as reference?",
  "Open frame option", MB_ICONQUESTION | MB_YESNO);

  if (mb == ID_YES)
  hr = Iframe->Load(name.c_str(), NULL,
     D3DRMLOAD_FROMFILE | D3DRMLOAD_INSTANCEBYREFERENCE,
     OnTextureLoad, NULL);
  else
  hr = Iframe->Load(name.c_str(), NULL,
     D3DRMLOAD_FROMFILE | D3DRMLOAD_INSTANCEBYCOPYING,
     OnTextureLoad, NULL);

  if (HR_FAILED(hr)) {
     AnsiString Error = "Could't load frame\nHRESULT = ";
     Error += HRString(hr);
     Application->MessageBox(Error.c_str(), "Load error",
                                        MB_ICONEXCLAMATION);
     goto LoadError;
  }
  Changed();
  RebuildTree(this);

  } catch (Exception &exception) {
      Application->ShowException(&exception);
  }
LoadError:
  D3dView->Render();
  StatBar->SimpleText  = "";  StatBar->Update();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdOpenSceneClick(TObject*) {
  OpenDlg->Title = "Open Scene";
  OpenDlg->FileName = "";
  OpenDlg->Filter = "X files (*.x)|*.x";
  OpenDlg->DefaultExt = "*.x";
  if (!OpenDlg->Execute()) return;

  cmdFileNewClick(this);

  StatBar->SimpleText  = "Opening Scene...";
  StatBar->SimplePanel = true;  StatBar->Update();
  AnsiString name = OpenDlg->FileName;

  try {
  IScene->SetName(""); //    .
  hr = LoadScene(IScene, name.c_str(), OnTextureLoad);

  if (HR_FAILED(hr)) {
     AnsiString Error = "Could't load scene\nHRESULT = ";
     Error += HRString(hr);
     Application->MessageBox(Error.c_str(), "Load error",
                                        MB_ICONEXCLAMATION);
     goto LoadError;
  } else {
     LPDIRECT3DRMFRAMEARRAY IFrames = NULL;
     IScene->GetChildren(&IFrames);
     if (IFrames && (IFrames->GetSize()==1)) {
        IScene->Release();
        IFrames->GetElement(0, &IScene);
        IFrames->Release();
     }
  }

  EditorState(OpenDlg->FileName, false);

  } catch (Exception &exception) {
      Application->ShowException(&exception);
  }
LoadError:
  RebuildTree(this);
  FrameProjection(IScene, Vport->IRMVport, PROJECTION_POS);
  D3dView->Render();
  StatBar->SimpleText  = "";  StatBar->Update();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdOpenTextureClick(TObject*) {
  TTreeNode* Node = CurrentFrameNode();
  if (!Node) return;

  OpenDlg->Title  = "Open Texture";
  OpenDlg->FileName  = "";
  OpenDlg->Filter =
                "Texture files (*.ppm; *.bmp)|*.ppm; *.bmp";
  OpenDlg->DefaultExt = "*.bmp; *.ppm";
  if (!OpenDlg->Execute()) return;
  StatBar->SimpleText  = "Opening Texture...";
  StatBar->SimplePanel = true; StatBar->Update();

  LPDIRECT3DRMTEXTURE IRMTexture = NULL;
  try {
  TTreeNode *NewNode;
  LPDIRECT3DRMFRAME Iparent = ASFRAME(Node->Data);
  hr = IRM->LoadTexture(OpenDlg->FileName.c_str(),
                                               &IRMTexture);
  if (HR_FAILED(hr)) {
     Application->MessageBox("Could't load texture",
                          "Load error", MB_ICONEXCLAMATION);
     goto LoadError;
  }
  TRY(Iparent->AddVisual(IRMTexture));
  NewNode = Tree->Items->AddChild(Node, "");
  NewNode->Data = IRMTexture;
  Tree->Selected = NewNode;
  Changed();

  } catch (Exception &exception) {
      Application->ShowException(&exception);
  }
LoadError:
  RELEASE(IRMTexture);
  D3dView->Render();
  StatBar->SimpleText  = ""; StatBar->Update();
}//---------------------------------------------------------
HRESULT OnTextureLoad(char *name, void *arg,
  LPDIRECT3DRMTEXTURE *pITex)
{
  HRESULT hr;
  AnsiString ValidName = name;
  ValidName = ChangeFileExt(ValidName, ".BMP");
  hr = ::DesignForm->IRM->LoadTexture(
                          ValidName.c_str(), pITex);
  if (HR_FAILED(hr)) {
     ValidName = ChangeFileExt(ValidName, ".PPM");
     hr = ::DesignForm->IRM->LoadTexture(
                             ValidName.c_str(), pITex);
  }
  return hr;
}//---------------------------------------------------------
