LPGUID FindDevice(D3DCOLORMODEL model) {
  static D3DFINDDEVICERESULT result;

  LPDIRECTDRAW IDD = NULL;
  DirectDrawCreate(NULL, &IDD, NULL);
  if (!IDD) return NULL;

  D3DFINDDEVICESEARCH search;
  memset(&search, 0, sizeof search);
  search.dwSize = sizeof search;

  search.dwFlags = D3DFDS_COLORMODEL | D3DFDS_TRIANGLES;
  search.dcmColorModel = model;
  search.dpcPrimCaps.dwMiscCaps = D3DPMISCCAPS_CULLNONE;


  LPDIRECT3D ID3D = NULL;
  IDD->QueryInterface(IID_IDirect3D, (void**) &ID3D);
  if (!ID3D)   return NULL;

  memset(&result, 0, sizeof result);
  result.dwSize = sizeof result;

  HRESULT hr = ID3D->FindDevice(&search, &result);
  if (HR_SUCCEEDED(hr)) {
     bool NoBitDebpth =
      !(result.ddHwDesc.dwDeviceRenderBitDepth &BitDepth());
     if (result.ddHwDesc.dwFlags && NoBitDebpth) {
      search.dwFlags |= D3DFDS_HARDWARE;
      search.bHardware = FALSE;

      memset(&result, 0, sizeof result);
      result.dwSize = sizeof result;
      hr = ID3D->FindDevice(&search, &result);
    }
  }
  ID3D->Release();
  IDD->Release();

  if (HR_FAILED(hr)) return NULL;
  return &result.guid;
}//---------------------------------------------------------
