void __fastcall TSetupForm::FormActivate(TObject*) {
  SavedVports = new TList;
  PageControl->ActivePage = tsRMDevice;
  Start();
}//---------------------------------------------------------
void __fastcall TSetupForm::FormHide(TObject*) {
  Clear();
}//---------------------------------------------------------
void __fastcall TSetupForm::Start() {
  TempSave();
  GetAllSettings();
  lbDriversClick(this);
  btnOk->Enabled = false;
  btnSave->Enabled = false;
}//---------------------------------------------------------
void __fastcall TSetupForm::Clear() {
  RELEASE(IDev);
  RELEASE(IRMDev);
  ClearSavedVports();
  for (int i = 0; i < lbDrivers->Items->Count; i++)
     if (lbDrivers->Items->Objects[i])
      delete lbDrivers->Items->Objects[i];
  lbDrivers->Clear();
}//---------------------------------------------------------
void __fastcall TSetupForm::GetTheRMDevice() {
  if (!IRM) return;
  RELEASE(IRMDev);
  LPDIRECT3DRMDEVICEARRAY IRMDevArray = NULL;
  IRM->GetDevices(&IRMDevArray);
  if (!IRMDevArray) return;
  DWORD dev_count = IRMDevArray->GetSize();
  if (!dev_count) {
     IRMDevArray->Release();
     return;
  }
  IRMDevArray->GetElement(0, &IRMDev);
  IRMDevArray->Release();
  char buf[512];
  sprintf(buf, "RM Device 1[%d]", dev_count);
  tsRMDevice->Caption = AnsiString(buf);
}//---------------------------------------------------------
void __fastcall TSetupForm::GetVports() {
  if (!IRMDev) return;
  int SavedIndex = lbVports->ItemIndex;
  lbVports->Items->Clear();
  LPDIRECT3DRMVIEWPORTARRAY Ivports = NULL;
  IRMDev->GetViewports(&Ivports);
  if (!Ivports) return;
  if (!Ivports->GetSize()) {Ivports->Release(); return;}
  for (DWORD i = 0; i < Ivports->GetSize(); i++) {
     LPDIRECT3DRMVIEWPORT Ivport;
     Ivports->GetElement(i, &Ivport);
     char Name[255]; DWORD NameLen = 256;
     Ivport->GetName(&NameLen, Name);
     AnsiString st = "NONAME_";
     if (NameLen > 1) st = AnsiString(Name);
     else st += IntToStr(i);
     lbVports->Items->AddObject(st, (TObject*)Ivport);
     Ivport->Release();
  } Ivports->Release();
  if (SavedIndex != -1) lbVports->ItemIndex = SavedIndex;
  else lbVports->ItemIndex = 0;
  GetVportSettings();
}//---------------------------------------------------------
void __fastcall TSetupForm::GetVportSettings() {
  if (lbVports->Items->Count < 1) return;
  IVport = LPDIRECT3DRMVIEWPORT(
             lbVports->Items->Objects[lbVports->ItemIndex]);
  if (!IVport) return;

  DecimalSeparator = '.';
  laXOffset->Caption = IntToStr(IVport->GetX());
  laYOffset->Caption = IntToStr(IVport->GetY());
  laVWidth->Caption  = IntToStr(IVport->GetWidth());
  laVHeight->Caption = IntToStr(IVport->GetHeight());
  rbPerspective->Checked =
      (IVport->GetProjection() == D3DRMPROJECT_PERSPECTIVE);
  rbOrthographic->Checked =
     (IVport->GetProjection() == D3DRMPROJECT_ORTHOGRAPHIC);
  cbScale->Checked = IVport->GetUniformScaling();
  #define FTSF(x) FloatToStrF(x, ffFixed, 15, 2)
  edBack->Text     = FTSF(IVport->GetBack());
  edFront->Text    = FTSF(IVport->GetFront());
  edField->Text    = FTSF(IVport->GetField());

  D3DVALUE left, right, bottom, top;
  IVport->GetPlane(&left, &right, &bottom, &top);
  edLeft->Text   = FTSF(left);
  edRight->Text  = FTSF(right);
  edBottom->Text = FTSF(bottom);
  edTop->Text    = FTSF(top);
  #undef FTSF(x)
}//---------------------------------------------------------
void __fastcall TSetupForm::GetDeviceCaps() {
  if (!IRMDev) return;
  RELEASE(IDev);
  IRMDev->GetDirect3DDevice(&IDev);
  if (!IDev) return;

  D3DDEVICEDESC hw_desc;
  D3DDEVICEDESC hel_desc;
  memset(&hw_desc,  0, sizeof(D3DDEVICEDESC));
  memset(&hel_desc, 0, sizeof(D3DDEVICEDESC));
  hw_desc.dwSize  = sizeof(D3DDEVICEDESC);
  hel_desc.dwSize = sizeof(D3DDEVICEDESC);

  IDev->GetCaps(&hw_desc,  &hel_desc);
  if (hw_desc.dcmColorModel) DevDescription = hw_desc;
  else DevDescription = hel_desc;
}//---------------------------------------------------------
void __fastcall TSetupForm::GetDriversInfo() {
  for (int i = 0; i < lbDrivers->Items->Count; i++)
     if (lbDrivers->Items->Objects[i])
        delete lbDrivers->Items->Objects[i];
  lbDrivers->Clear();

  LPDIRECTDRAW IDD = NULL;
  DirectDrawCreate(NULL, &IDD, NULL);
  if (IDD) {
     LPDIRECT3D ID3D = NULL;
     IDD->QueryInterface(IID_IDirect3D, (void**) &ID3D);
     //      Direct3D:
     if (ID3D) {
        ResetD3dDescriptions(); //   
        ID3D->EnumDevices(D3DEnumDevicesCallback, NULL);
     }
     IDD->Release();
  }

  //      , 
  // !
  TD3DDesc *D3DDesc;
  for (int i = 0; i < D3dDescriptions->Count; i++) {
     D3DDesc = (TD3DDesc*)D3dDescriptions->Objects[i];
     if (!D3DDesc) continue;

     AnsiString st;
     TStrings *s = new TStringList;
     s->Add(D3DDesc->about);
     s->Add(D3dDescriptions->Strings[i]); //  guid

     LPD3DDEVICEDESC desc = &D3DDesc->d3ddesc;

     s->Add("Color Model:");
     if (desc->dcmColorModel == D3DCOLOR_MONO)
        s->Add("\tD3DCOLOR_MONO");
     if (desc->dcmColorModel == D3DCOLOR_RGB)
        s->Add("\tD3DCOLOR_RGB");
     if (desc->dwFlags & D3DDD_TRICAPS) {
        DWORD dw = desc->dpcTriCaps.dwMiscCaps;
        s->Add("Cull operations:");
        if (dw & D3DPMISCCAPS_CULLCCW) s->Add("\tCULLCCW");
        if (dw & D3DPMISCCAPS_CULLCCW) s->Add("\tCULLCW");
        if (dw & D3DPMISCCAPS_CULLCCW) s->Add("\tCULLNONE");

        s->Add("Shading operations:");
        dw = desc->dpcTriCaps.dwShadeCaps;
        if (dw & D3DPSHADECAPS_COLORFLATMONO)
           s->Add("\tCOLORFLATMONO");
        if (dw & D3DPSHADECAPS_COLORFLATRGB)
           s->Add("\tCOLORFLATRGB");
        if (dw & D3DPSHADECAPS_COLORGOURAUDMONO)
           s->Add("\tCOLORGOURAUDMONO");
        if (dw & D3DPSHADECAPS_COLORGOURAUDRGB)
           s->Add("\tCOLORGOURAUDRGB");
        if (dw & D3DPSHADECAPS_COLORPHONGMONO)
           s->Add("\tCOLORPHONGMONO");
        if (dw & D3DPSHADECAPS_COLORPHONGRGB)
           s->Add("\tCOLORPHONGRGB");
     } // D3DDD_TRICAPS

     st = D3DDesc->name;

     if (desc->dcmColorModel ==
                               DevDescription.dcmColorModel)
        st +=  " [Current]";
     lbDrivers->Items->AddObject(st, s);
     lbDrivers->ItemIndex = 0;

  } // for D3dDescriptions->Count
}//---------------------------------------------------------
void __fastcall TSetupForm::GetAllSettings() {
  GetTheRMDevice();
  if (!IRMDev) {
     PageControl->Enabled = false;
     return;
  }
  IsDeriving = true;
  GetVports();
  GetDeviceCaps();
  GetDriversInfo();
  PageControl->Enabled = true;

  //    :
  laBufs->Caption   = IntToStr(IRMDev->GetBufferCount());
  laTrigs->Caption  = IntToStr(IRMDev->GetTrianglesDrawn());
  laWidth->Caption  = IntToStr(IRMDev->GetWidth());
  laHeight->Caption = IntToStr(IRMDev->GetHeight());

  LPDIRECT3DRMVIEWPORTARRAY IVports = NULL;
  IRMDev->GetViewports(&IVports);
  if (IVports) {
     laVports->Caption = IntToStr(IVports->GetSize());
     IVports->Release();
  }

  DWORD op = IRMDev->GetWireframeOptions();
  cbCull->Checked = (op & D3DRMWIREFRAME_CULL);
  cbHide->Checked = (op & D3DRMWIREFRAME_HIDDENLINE);

  D3DCOLORMODEL cm = IRMDev->GetColorModel();
  rbMono->Checked = (cm == D3DCOLOR_MONO);
  rbRGB->Checked  = (cm == D3DCOLOR_RGB);

  //     :

  cbDither->Checked = IRMDev->GetDither();
  laShd->Caption    = IntToStr(IRMDev->GetShades());
  sel(QualityCombo, "UNKNOWN");
  D3DRMRENDERQUALITY qu = IRMDev->GetQuality();
  switch (qu) {
     case D3DRMRENDER_WIREFRAME:
        sel(QualityCombo, "WIREFRAME"); break;
     case D3DRMRENDER_UNLITFLAT:
        sel(QualityCombo, "UNLITFLAT"); break;
     case D3DRMRENDER_FLAT:
        sel(QualityCombo, "FLAT");      break;
     case D3DRMRENDER_GOURAUD:
        sel(QualityCombo, "GOURAUD");   break;
     case D3DRMRENDER_PHONG:
        sel(QualityCombo, "PHONG");     break;
  }

  sel(ShadeCombo, "UNKNOWN");
  if ((qu & D3DRMSHADE_MASK) == D3DRMSHADE_FLAT)
     sel(ShadeCombo, "FLAT");
  if ((qu & D3DRMSHADE_MASK) == D3DRMSHADE_GOURAUD)
     sel(ShadeCombo, "GOURAUD");
  if ((qu & D3DRMSHADE_MASK) == D3DRMSHADE_PHONG)
     sel(ShadeCombo, "PHONG");

  sel(LightCombo, "UNKNOWN");
  if ((qu & D3DRMLIGHT_MASK) == D3DRMLIGHT_OFF)
     sel(LightCombo, "OFF");
  if ((qu & D3DRMLIGHT_MASK) == D3DRMLIGHT_ON)
     sel(LightCombo, "ON");

  sel(FillCombo, "UNKNOWN");
  if ((qu & D3DRMFILL_MASK) == D3DRMFILL_POINTS)
     sel(FillCombo, "POINTS");
  if ((qu & D3DRMFILL_MASK) == D3DRMFILL_WIREFRAME)
     sel(FillCombo, "WIREFRAME");
  if ((qu & D3DRMFILL_MASK) == D3DRMFILL_SOLID)
     sel(FillCombo, "SOLID");

  sel(TextureCombo, "UNKNOWN");
  D3DRMTEXTUREQUALITY tex = IRMDev->GetTextureQuality();
  switch (tex) {
  case D3DRMTEXTURE_NEAREST:
     sel(TextureCombo, "NEAREST");          break;
  case D3DRMTEXTURE_LINEAR:
     sel(TextureCombo, "LINEAR");           break;
  case D3DRMTEXTURE_MIPNEAREST:
     sel(TextureCombo, "MIPNEAREST");       break;
  case D3DRMTEXTURE_MIPLINEAR:
     sel(TextureCombo, "MIPLINEAR");        break;
  case D3DRMTEXTURE_LINEARMIPNEAREST:
     sel(TextureCombo, "LINEARMIPNEAREST"); break;
  case D3DRMTEXTURE_LINEARMIPLINEAR:
     sel(TextureCombo, "LINEARMIPLINEAR");  break;
  }

  IsDeriving = false;
}//---------------------------------------------------------
void __fastcall TSetupForm::ClearSavedVports() {
  for (int i = 0; i < SavedVports->Count; i++)
     if (SavedVports->Items[i])
      delete SavedVports->Items[i];
  SavedVports->Clear();
}//---------------------------------------------------------
void __fastcall TSetupForm::TempSave() {
  if (!IRMDev) GetTheRMDevice();
  if (!IRMDev) return;
  SavedDither  = IRMDev->GetDither();
  SavedShades  = IRMDev->GetShades();
  SavedQuality = IRMDev->GetQuality();
  TexQuality   = IRMDev->GetTextureQuality();

  ClearSavedVports();
  LPDIRECT3DRMVIEWPORTARRAY Ivports = NULL;
  IRMDev->GetViewports(&Ivports);
  if (!Ivports) return;
  if (!Ivports->GetSize()) return;
  for (DWORD i = 0; i < Ivports->GetSize(); i++) {
     LPDIRECT3DRMVIEWPORT Ivport;
     Ivports->GetElement(i, &Ivport);
     SavedVports->Add(new TVportData(Ivport));
     Ivport->Release();
  } Ivports->Release();
}//---------------------------------------------------------
