/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.GenericCategory;
import GenCns.GenJava.GenericException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import palm.conduit.Log;

public class GenCategoryManager {
    public static boolean m_bDebug = false;
    GenericCategory[] m_catList;
    boolean m_bChanged = false;
    int m_iFindIndex = 0;
    public int m_iNextFreeID = 128;
    Class catClass;
    public static final int MAX_CATEGORIES = 16;
    public static final int CAT_NO_INDEX = -1;
    public static final int CAT_NO_ID = -1;
    public static final int CATEGORY_LENGTH = 16;
    public static final int CAT_FLAGS_BLOCK_SIZE = 2;
    public static final int CAT_NAME_BLOCK_SIZE = 256;
    public static final int CAT_ID_BLOCK_SIZE = 16;
    public static final int CAT_LAST_UNIQUE_ID_SIZE = 1;
    public static final int CAT_RESERVED_SIZE = 3;
    public static final int MIN_CATEGORY_BLOCK_SIZE = 278;
    public static final int CATEGORY_APP_INFO_SIZE = 274;

    public GenCategoryManager() {
        this.m_catList = new GenericCategory[16];
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's Constructor()", -1, false);
        }
        try {
            this.catClass = Class.forName("GenCns.GenJava.GenericCategory");
        }
        catch (Throwable throwable) {
            System.out.println("Uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
    }

    public GenCategoryManager(byte[] byArray) throws IOException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's Constructor(bytes)", -1, false);
        }
        this.m_catList = new GenericCategory[16];
        try {
            this.catClass = Class.forName("GenCns.GenJava.GenericCategory");
        }
        catch (Throwable throwable) {
            System.out.println("Uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
        this.extract(byArray);
    }

    protected GenericCategory getNewCatgory() {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's getNewCategory", -1, false);
        }
        GenericCategory genericCategory = null;
        try {
            genericCategory = (GenericCategory)this.catClass.newInstance();
        }
        catch (Throwable throwable) {
            System.out.println("Uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
        return genericCategory;
    }

    public GenericCategory findFirst() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's findFirst", -1, false);
        }
        this.m_iFindIndex = 0;
        return this.findNext();
    }

    public GenericCategory findNext() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's findNext", -1, false);
        }
        GenericCategory genericCategory = null;
        int n = this.m_iFindIndex;
        while (n < 16) {
            block5: {
                try {
                    genericCategory = this.m_catList[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block5;
                }
                if (genericCategory != null) {
                    this.m_iFindIndex = n + 1;
                    return genericCategory;
                }
            }
            ++n;
        }
        throw new GenericException(4403);
    }

    public GenericCategory findId(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's findId", -1, false);
        }
        GenericCategory genericCategory = null;
        int n2 = 0;
        while (n2 < 16) {
            block5: {
                try {
                    genericCategory = this.m_catList[n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block5;
                }
                if (genericCategory != null && genericCategory.getId() == n) {
                    return genericCategory;
                }
            }
            ++n2;
        }
        throw new GenericException(4403);
    }

    public GenericCategory findName(String string) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's findName : " + string, -1, false);
        }
        GenericCategory genericCategory = null;
        int n = 0;
        while (n < 16) {
            block5: {
                try {
                    genericCategory = this.m_catList[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block5;
                }
                if (genericCategory != null && genericCategory.getName().equals(string)) {
                    return genericCategory;
                }
            }
            ++n;
        }
        throw new GenericException(4403);
    }

    public GenericCategory getByIndex(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's getByIndex", -1, false);
        }
        GenericCategory genericCategory = null;
        int n2 = 0;
        while (n2 < 16) {
            block5: {
                try {
                    genericCategory = this.m_catList[n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block5;
                }
                if (genericCategory != null && genericCategory.getIndex() == n) {
                    return genericCategory;
                }
            }
            ++n2;
        }
        throw new GenericException(4357);
    }

    public void setAllModified() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's setAllModified", -1, false);
        }
        int n = 0;
        while (n < 16) {
            block5: {
                GenericCategory genericCategory;
                try {
                    genericCategory = this.m_catList[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block5;
                }
                if (genericCategory != null) {
                    genericCategory.setIsModified(true);
                }
            }
            ++n;
        }
    }

    public void add(GenericCategory genericCategory) throws GenericException {
        int n;
        int n2;
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's add", -1, false);
        }
        if ((n2 = genericCategory.getIndex()) == -1) {
            n2 = this.findFirstEmpty();
            if (n2 == -1) {
                throw new GenericException(4398);
            }
            genericCategory.setIndex(n2);
            genericCategory.setIsModified(true);
        }
        if ((n = genericCategory.getId()) == -1) {
            n = this.getNextAddID();
            if (n == -1) {
                throw new GenericException(4398);
            }
            genericCategory.setId(n);
            genericCategory.setIsModified(true);
        } else {
            GenericCategory genericCategory2 = null;
            try {
                genericCategory2 = this.findId(n);
            }
            catch (GenericException genericException) {
                // empty catch block
            }
            if (genericCategory2 != null) {
                throw new GenericException(4402);
            }
        }
        this.m_catList[genericCategory.getIndex()] = new GenericCategory(genericCategory.getName(), genericCategory.getId(), genericCategory.getIndex(), genericCategory.isModified());
        this.m_catList[genericCategory.getIndex()].setFilename(this.GenerateFileName(genericCategory.getName()));
        this.m_bChanged = true;
    }

    public void modifyByIndex(int n, GenericCategory genericCategory) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's modifyByIndex", -1, false);
        }
        try {
            GenericCategory genericCategory2 = this.m_catList[n];
            if (genericCategory2 != null) {
                genericCategory2.setId(genericCategory.getId());
                genericCategory2.setIndex(n);
                genericCategory2.setName(genericCategory.getName());
                genericCategory2.setIsModified(true);
                this.m_bChanged = true;
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new GenericException(4357);
    }

    public void renameByIndex(int n, String string) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's renameByIndex", -1, false);
        }
        try {
            GenericCategory genericCategory = this.m_catList[n];
            if (genericCategory != null) {
                genericCategory.setName(string);
                genericCategory.setIsModified(true);
                this.m_bChanged = true;
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new GenericException(4357);
    }

    public void deleteByID(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's deleteByID", -1, false);
        }
        int n2 = 0;
        while (n2 < 16) {
            block5: {
                GenericCategory genericCategory;
                try {
                    genericCategory = this.m_catList[n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block5;
                }
                if (genericCategory != null && genericCategory.getId() == n) {
                    this.m_catList[n2] = null;
                    this.m_bChanged = true;
                    return;
                }
            }
            ++n2;
        }
        throw new GenericException(4360);
    }

    public void deleteByIndex(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's deleteByIndex : " + n, -1, false);
        }
        try {
            GenericCategory genericCategory = this.m_catList[n];
            if (genericCategory != null) {
                this.m_catList[n] = null;
                this.m_bChanged = true;
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new GenericException(4357);
    }

    public void deleteByName(String string) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's deleteByName : " + string, -1, false);
        }
        int n = 0;
        while (n < 16) {
            block5: {
                GenericCategory genericCategory;
                try {
                    genericCategory = this.m_catList[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block5;
                }
                if (genericCategory != null && genericCategory.getName() == string) {
                    this.m_catList[n] = null;
                    this.m_bChanged = true;
                }
            }
            ++n;
        }
        throw new GenericException(4360);
    }

    public int getNextAddID() throws GenericException {
        return -1;
    }

    public int findFirstEmpty() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's findFirstEmpty", -1, false);
        }
        int n = 0;
        while (n < 16) {
            GenericCategory genericCategory;
            try {
                genericCategory = this.m_catList[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return n;
            }
            if (genericCategory == null) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isChanged() {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's isChanged : " + this.m_bChanged, -1, false);
        }
        return this.m_bChanged;
    }

    public void setChanged(boolean bl) {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's setChanged", -1, false);
        }
        this.m_bChanged = bl;
    }

    public void empty() {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's empty", -1, false);
        }
        int n = 0;
        while (n < 16) {
            this.m_catList[n] = null;
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's equals", -1, false);
        }
        if (m_bDebug) {
            Log.AddEntry("      category list size = 16", -1, false);
        }
        GenCategoryManager genCategoryManager = (GenCategoryManager)object;
        if (m_bDebug) {
            Log.AddEntry("      compare category list size = " + 16, -1, false);
        }
        GenericCategory genericCategory = null;
        GenericCategory genericCategory2 = null;
        int n = 0;
        while (n < 16) {
            try {
                genericCategory = this.m_catList[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                genericCategory2 = genCategoryManager.m_catList[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (genericCategory == null) {
                if (genericCategory2 != null) {
                    return false;
                }
            } else {
                if (genericCategory2 == null) {
                    return false;
                }
                if (genericCategory.getName().compareTo(genericCategory2.getName()) != 0) {
                    return false;
                }
                if (genericCategory.getId() != genericCategory2.getId()) {
                    return false;
                }
                if (genericCategory.getIndex() != genericCategory2.getIndex()) {
                    return false;
                }
            }
            ++n;
        }
        if (m_bDebug) {
            Log.AddEntry("      true", -1, false);
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's clone", -1, false);
        }
        return null;
    }

    public int extract(byte[] byArray) throws GenericException {
        short s;
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's extract", -1, false);
        }
        this.empty();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, 258);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray, 258, 16);
        DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream2);
        try {
            s = dataInputStream.readShort();
        }
        catch (IOException iOException) {
            throw new GenericException(4381);
        }
        int n = 1;
        int n2 = 0;
        while (n2 < 16) {
            int n3;
            int n4 = n2;
            try {
                n3 = dataInputStream2.read();
            }
            catch (IOException iOException) {
                throw new GenericException(4381);
            }
            String string = "";
            boolean bl = (n & s) > 0;
            boolean bl2 = false;
            int n5 = 0;
            while (n5 < 16) {
                byte by;
                try {
                    by = (byte)dataInputStream.read();
                }
                catch (IOException iOException) {
                    throw new GenericException(4381);
                }
                if (by == 0) {
                    bl2 = true;
                } else if (!bl2) {
                    string = string + (char)by;
                }
                ++n5;
            }
            if (string.length() > 0) {
                GenericCategory genericCategory = this.getNewCatgory();
                genericCategory.setId(n3);
                genericCategory.setIndex(n4);
                genericCategory.setName(string);
                genericCategory.setIsModified(bl);
                genericCategory.setFilename(this.GenerateFileName(string));
                this.m_catList[n4] = genericCategory;
            }
            n <<= 1;
            ++n2;
        }
        return 0;
    }

    public boolean containsModifiedCategory() {
        GenericCategory genericCategory = null;
        int n = 0;
        while (n < 16) {
            genericCategory = this.m_catList[n];
            if (genericCategory != null && genericCategory.isModified()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public byte[] compact(boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's compact", -1, false);
        }
        byte[] byArray = new byte[274];
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 16) {
            GenericCategory genericCategory = this.m_catList[n3];
            if (genericCategory != null) {
                String string;
                if (genericCategory.isModified()) {
                    if (bl) {
                        this.m_bChanged = true;
                    } else {
                        n |= n2;
                    }
                }
                if ((string = genericCategory.getName()).length() > 16) {
                    string = string.substring(0, 16);
                }
                byte[] byArray2 = new byte[string.length()];
                string.getBytes(0, string.length(), byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, 2 + 16 * n3, string.length());
                byArray[258 + n3] = (byte)genericCategory.getId();
            }
            n2 <<= 1;
            ++n3;
        }
        byArray[0] = (byte)(n2 >> 8);
        byArray[1] = (byte)(n2 & 0xF);
        return byArray;
    }

    public int getCount() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's getCount", -1, false);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 16) {
            try {
                if (this.m_catList[n2] != null) {
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++n2;
        }
        return n;
    }

    public String GenerateFileName(String string) {
        if (m_bDebug) {
            Log.AddEntry("* GenCategoryManager's GenerateFileName for " + string, -1, false);
        }
        String string2 = new String(string);
        string2.replace('*', '_');
        string2.replace('+', '_');
        string2.replace(',', '_');
        string2.replace('.', '_');
        string2.replace('/', '_');
        string2.replace(':', '_');
        string2.replace(';', '_');
        string2.replace('<', '_');
        string2.replace('=', '_');
        string2.replace('>', '_');
        string2.replace('?', '_');
        string2.replace('[', '_');
        string2.replace(']', '_');
        string2.replace('|', '_');
        string2.replace('\\', '_');
        string2.replace('^', '_');
        string2.replace('\"', '_');
        return string2;
    }
}

