/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.GenCategoryManager;
import GenCns.GenJava.GenDbInfo;
import GenCns.GenJava.GenericException;
import GenCns.GenJava.PalmBaseManager;
import GenCns.GenJava.PalmRecord;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import palm.conduit.Log;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public class HHMgr
extends PalmBaseManager {
    public static boolean m_bDebug = false;
    protected byte m_db = 0;
    protected boolean m_bRecordDB = true;

    public HHMgr() {
    }

    public HHMgr(SyncProperties syncProperties, String string, long l) throws GenericException {
        super(syncProperties, string, l);
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's Constructor", -1, false);
        }
    }

    public void Open() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HH Manager's Open()", -1, false);
        }
        switch (this.props.syncType) {
            case 0: 
            case 1: {
                this.Open(2);
                break;
            }
            case 2: 
            case 5: {
                this.Open(2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                this.Open(3);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new GenericException(4370);
            }
        }
    }

    protected void Open(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HH Manager's Open(iMode)", -1, false);
        }
        int n2 = 0;
        switch (n) {
            case 0: {
                if (m_bDebug) {
                    Log.AddEntry("* HH Manager's Open(eRead)", -1, false);
                }
                try {
                    this.m_db = (byte)SyncManager.openDB(this.m_DbName, n2, 128);
                    break;
                }
                catch (SyncException syncException) {
                    if (syncException.errorCode == 16387) {
                        throw new GenericException(4388);
                    }
                    throw new GenericException(syncException.errorCode);
                }
            }
            case 1: {
                if (m_bDebug) {
                    Log.AddEntry("* HH Manager's Open(eWrite)", -1, false);
                }
                try {
                    this.m_db = (byte)SyncManager.openDB(this.m_DbName, n2, 64);
                    break;
                }
                catch (SyncException syncException) {
                    if (syncException.errorCode == 16387) {
                        throw new GenericException(4388);
                    }
                    throw new GenericException(syncException.errorCode);
                }
            }
            case 2: {
                if (m_bDebug) {
                    Log.AddEntry("* HH Manager's Open(eReadWrite)", -1, false);
                }
                try {
                    this.m_db = (byte)SyncManager.openDB(this.m_DbName, n2, 192);
                    break;
                }
                catch (SyncException syncException) {
                    if (syncException.errorCode == 16387) {
                        throw new GenericException(4388);
                    }
                    throw new GenericException(syncException.errorCode);
                }
            }
            case 3: {
                if (m_bDebug) {
                    Log.AddEntry("* HH Manager's Open(eCreate)", -1, false);
                }
                try {
                    SyncManager.deleteDB(this.m_DbName, n2);
                    if (m_bDebug) {
                        Log.AddEntry("      Deleted database = " + this.m_DbName, -1, false);
                    }
                }
                catch (SyncException syncException) {
                    // empty catch block
                }
                try {
                    int n3 = 0;
                    this.m_db = (byte)SyncManager.createDB(this.props.creator, n3, n2, this.m_DbName, this.props.dbType);
                    if (!m_bDebug) break;
                    Log.AddEntry("      Created database = " + this.m_DbName, -1, false);
                    break;
                }
                catch (SyncException syncException) {
                    Log.err("Unable to create HH database");
                    throw new GenericException(syncException.errorCode);
                }
            }
            default: {
                throw new GenericException(4364);
            }
        }
    }

    public void Close(boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HH Manager's Close()", -1, false);
            Log.AddEntry("      m_db = " + this.m_db, -1, false);
        }
        if (this.m_db == 0) {
            throw new GenericException(4372);
        }
        if (!bl) {
            try {
                SyncManager.resetSyncFlags(this.m_db);
            }
            catch (SyncException syncException) {
                // empty catch block
            }
        }
        try {
            SyncManager.closeDB(this.m_db);
        }
        catch (SyncException syncException) {
            Log.err("Unable to close hh database");
        }
        this.m_db = 0;
    }

    protected void LoadModifiedRecords() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HH Manager's LoadModifiedRecords()", -1, false);
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        try {
            n2 = this.getRecordCount();
        }
        catch (SyncException syncException) {
            throw new GenericException(syncException.errorCode);
        }
        this.ReAllocateRecordList(n2 * 2);
        while (!bl) {
            try {
                PalmRecord palmRecord = this.getNewRecord();
                palmRecord.setIndex(n);
                SyncManager.readNextModifiedRec(this.m_db, palmRecord);
                n = palmRecord.getIndex();
                this.m_databaseRecords[n] = palmRecord;
            }
            catch (SyncException syncException) {
                bl = true;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
    }

    public int getRecordCount() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HH Manager's getRecordCount()", -1, false);
        }
        int n = 0;
        try {
            n = SyncManager.getDBRecordCount(this.m_db);
        }
        catch (SyncException syncException) {
            throw new GenericException(syncException.getMessage());
        }
        return n;
    }

    protected long LoadAllRecords() throws GenericException {
        int n;
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's LoadAllRecords", -1, false);
        }
        try {
            n = this.getRecordCount();
        }
        catch (SyncException syncException) {
            throw new GenericException(syncException.errorCode);
        }
        this.ReAllocateRecordList(n * 2);
        int n2 = 0;
        while (n2 < n) {
            PalmRecord palmRecord = this.getNewRecord();
            palmRecord.setIndex(n2);
            try {
                SyncManager.readRecordByIndex(this.m_db, palmRecord);
            }
            catch (IOException iOException) {
                if (m_bDebug) {
                    Log.AddEntry("SyncManager.readRecordById error " + iOException.getMessage(), -1, false);
                }
                throw new GenericException(iOException.getMessage());
            }
            if (m_bDebug) {
                Log.AddEntry("HH Add Rec (ID = " + palmRecord.getId() + ")", -1, false);
            }
            this.m_databaseRecords[n2] = palmRecord;
            ++n2;
        }
        return 0L;
    }

    PalmRecord findRecById(int n) throws GenericException {
        PalmRecord palmRecord = this.getNewRecord();
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's findRecById", -1, false);
        }
        palmRecord.setIndex(n);
        try {
            SyncManager.readRecordById(this.m_db, palmRecord);
        }
        catch (IOException iOException) {
            throw new GenericException(4374);
        }
        return palmRecord;
    }

    public void DeleteCategory(int n, boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's DeleteCategory", -1, false);
        }
        try {
            if (!bl) {
                SyncManager.purgeAllRecsInCategory(this.m_db, n);
            } else {
                SyncManager.changeCategory(this.m_db, n, 0);
            }
        }
        catch (SyncException syncException) {
            Log.err("Error Changing Categories");
            syncException.printStackTrace();
            throw new GenericException(4397);
        }
    }

    public void changeCategory(int n, int n2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's changeCategory", -1, false);
        }
        try {
            SyncManager.changeCategory(this.m_db, n, n2);
        }
        catch (SyncException syncException) {
            Log.err("Error Changing Categories");
            syncException.printStackTrace();
            throw new GenericException(4397);
        }
    }

    public void addRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's addRec", -1, false);
        }
        palmRecord.setIsDeleted(false);
        palmRecord.setIsNew(false);
        palmRecord.setIsModified(false);
        palmRecord.setIsArchived(false);
        try {
            if (this.m_bRecordDB) {
                SyncManager.writeRec(this.m_db, palmRecord);
            } else {
                SyncManager.writeResourceRec(this.m_db, palmRecord);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new GenericException(iOException.getMessage());
        }
    }

    public void SetRecordCount(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's SetRecordCount", -1, false);
        }
        throw new GenericException(4364);
    }

    public PalmRecord findRecById(int n, boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's findRecById", -1, false);
        }
        PalmRecord palmRecord = null;
        palmRecord = this.getNewRecord();
        palmRecord.setId(n);
        try {
            SyncManager.readRecordById(this.m_db, palmRecord);
        }
        catch (IOException iOException) {
            if (bl) {
                Log.err("Record not found");
            }
            throw new GenericException(4374);
        }
        return palmRecord;
    }

    public void DeleteRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's DeleteRec", -1, false);
        }
        try {
            if (this.m_bRecordDB) {
                SyncManager.deleteRecord(this.m_db, palmRecord);
            } else {
                SyncManager.deleteResourceRec(this.m_db, palmRecord);
            }
        }
        catch (SyncException syncException) {
            throw new GenericException(syncException.getMessage());
        }
    }

    public void PurgeDeletedRecs() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's PurgeDeletedRecs", -1, false);
        }
        try {
            SyncManager.purgeDeletedRecs(this.m_db);
        }
        catch (SyncException syncException) {
            Log.err("Bad Purge");
            throw new GenericException(syncException.getMessage(), 4395);
        }
    }

    protected PalmRecord findNextRecByIndex() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's findNextRecByIndex", -1, false);
        }
        PalmRecord palmRecord = null;
        if (this.m_databaseRecords == null) {
            throw new GenericException(4374);
        }
        if (this.m_iSyncType == 0) {
            if (this.m_iCurrentFindIndex >= this.m_databaseRecords.length) {
                throw new GenericException(4367);
            }
            if (this.m_databaseRecords[this.m_iCurrentFindIndex] != null) {
                palmRecord = this.m_databaseRecords[this.m_iCurrentFindIndex];
                ++this.m_iCurrentFindIndex;
            } else {
                palmRecord = this.getNewRecord();
                palmRecord.setIndex(this.m_iCurrentFindIndex);
                try {
                    SyncManager.readRecordByIndex(this.m_db, palmRecord);
                }
                catch (IOException iOException) {
                    throw new GenericException(4367);
                }
                this.m_databaseRecords[this.m_iCurrentFindIndex] = palmRecord;
                this.m_databaseRecords[this.m_iCurrentFindIndex].setIndex(this.m_iCurrentFindIndex);
                ++this.m_iCurrentFindIndex;
            }
        } else {
            if (this.m_iCurrentFindIndex >= this.m_databaseRecords.length) {
                throw new GenericException(4367);
            }
            try {
                palmRecord = this.m_databaseRecords[this.m_iCurrentFindIndex];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new GenericException(4367);
            }
            if (palmRecord == null) {
                throw new GenericException(4367);
            }
            ++this.m_iCurrentFindIndex;
        }
        if (m_bDebug) {
            Log.AddEntry("found record (ID = " + palmRecord.getId() + ")", -1, false);
        }
        return palmRecord;
    }

    public void ModifyRecByIndex(int n, PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's ModifyRecByIndex", -1, false);
        }
        if (n < 0) {
            throw new GenericException(4374);
        }
        PalmRecord palmRecord2 = null;
        try {
            palmRecord2 = (PalmRecord)palmRecord.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GenericException(cloneNotSupportedException.getMessage());
        }
        palmRecord2.setIndex(n);
        this.ModifyRec(palmRecord2);
        if (this.m_databaseRecords == null) {
            throw new GenericException(4357);
        }
        try {
            if (this.m_databaseRecords[n] != null) {
                this.m_databaseRecords[n] = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new GenericException(4357);
        }
        this.m_databaseRecords[n] = palmRecord2;
        if (palmRecord.getId() == 0) {
            palmRecord.setId(palmRecord2.getId());
        }
    }

    public void ModifyRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's ModifyRec", -1, false);
        }
        try {
            if (this.m_bRecordDB) {
                SyncManager.writeRec(this.m_db, palmRecord);
            } else {
                SyncManager.writeResourceRec(this.m_db, palmRecord);
            }
        }
        catch (IOException iOException) {
            throw new GenericException(4396);
        }
    }

    public byte[] getAppInfo() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's GetAppInfo", -1, false);
        }
        if (this.m_appInfo == null) {
            try {
                this.m_appInfo = new GenDbInfo();
                this.m_appInfo.setData(SyncManager.readDBAppInfoBlock(this.m_db, this.m_DbName));
            }
            catch (SyncException syncException) {
                throw new GenericException(syncException.errorCode);
            }
        }
        return this.m_appInfo.getData();
    }

    public byte[] getSortInfo() throws SyncException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's GetSortInfo", -1, false);
        }
        return SyncManager.readDBSortInfoBlock(this.m_db, this.m_DbName);
    }

    public void setAppInfo(byte[] byArray) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's setAppInfo. # bytes = " + byArray.length, -1, false);
        }
        try {
            SyncManager.writeDBAppInfoBlock(this.m_db, this.m_DbName, byArray);
        }
        catch (SyncException syncException) {
            throw new GenericException(syncException.errorCode);
        }
    }

    public void setSortInfo(byte[] byArray) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's setSortInfo. # bytes = " + byArray.length, -1, false);
        }
        try {
            SyncManager.writeDBSortInfoBlock(this.m_db, this.m_DbName, byArray);
        }
        catch (SyncException syncException) {
            throw new GenericException(syncException.errorCode);
        }
    }

    public int[] getRecIdMap() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's getRecIdMap", -1, false);
        }
        byte[] byArray = null;
        int n = this.getRecordCount();
        int n2 = n * 4;
        try {
            byArray = SyncManager.readPositionXMap(this.m_db, (short)0, (short)n2);
        }
        catch (SyncException syncException) {
            throw new GenericException(syncException.errorCode);
        }
        int[] nArray = new int[n];
        if (m_bDebug) {
            Log.AddEntry("      hh Records = " + n, -1, false);
            Log.AddEntry("      bytes length = " + byArray.length, -1, false);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n3 = 0;
        try {
            n3 = 0;
            while (n3 < n) {
                nArray[n3] = dataInputStream.readInt();
                if (m_bDebug) {
                    Log.AddEntry("      Index = " + n3 + ",Rec ID = " + nArray[n3], -1, false);
                }
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nArray;
    }

    protected void extractCategories() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's extractCategories", -1, false);
        }
        if (!this.areCategoriesSupported()) {
            throw new GenericException(4368);
        }
        this.getAppInfo();
        try {
            this.m_catMgr = new GenCategoryManager(this.m_appInfo.getData());
        }
        catch (IOException iOException) {
            throw new GenericException(4354);
        }
    }

    protected void compactCategories() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's compactCategories", -1, false);
        }
        if (!(this.m_catMgr != null && this.m_catMgr.isChanged() || this.m_catMgr.containsModifiedCategory())) {
            return;
        }
        if (this.m_appInfo == null) {
            this.m_appInfo = new GenDbInfo();
        }
        byte[] byArray = this.m_catMgr.compact(true);
        this.m_appInfo.setCategoryData(byArray);
    }

    public void PreSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's PreSync", -1, false);
        }
        switch (this.m_iSyncType) {
            case 0: {
                this.LoadModifiedRecords();
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                this.LoadAllRecords();
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public void PostSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's PostSync", -1, false);
        }
        switch (this.m_iSyncType) {
            case 0: 
            case 1: {
                this.Close(false);
                break;
            }
            case 2: {
                this.Close(false);
                break;
            }
            case 5: {
                this.Close(true);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                this.Close(false);
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public void PreAppInfoSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's PreAppInfoSync", -1, false);
        }
        if (!this.isAppInfoSupported()) {
            if (this.discoverIsAppInfoSupported()) {
                try {
                    this.getAppInfo();
                }
                catch (SyncException syncException) {
                    this.setDiscoverAppInfoSupport(false);
                    return;
                }
            }
            return;
        }
        this.extractCategories();
    }

    public void PostAppInfoSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* HHMgr's PostAppInfoSync", -1, false);
        }
        if (!this.isAppInfoSupported()) {
            return;
        }
        if (!this.m_bNeedToSaveAppInfo) {
            if (!this.areCategoriesSupported()) {
                return;
            }
            if (!(this.m_catMgr != null && this.m_catMgr.isChanged() || this.m_catMgr.containsModifiedCategory())) {
                return;
            }
        }
        if (this.areCategoriesSupported()) {
            this.compactCategories();
        }
        this.setAppInfo(this.m_appInfo.getData());
    }
}

