/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.kde2;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinPersonality;
import com.l2fprod.gui.plaf.skin.impl.kde2.Kde2Utils;
import com.l2fprod.util.ImageUtils;
import com.l2fprod.util.IniFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.border.Border;

class Kde2Personality
extends AbstractSkinPersonality {
    static int MINIMAL_SIZE = 50;
    Image background;
    DefaultButton comboBox;
    DefaultButton menuitemSelected;
    Border menuBarBorder;

    public boolean installSkin(JComponent c) {
        if ((c instanceof JMenuBar || c instanceof JToolBar) && this.menuBarBorder != null) {
            c.setBorder(this.menuBarBorder);
        }
        return true;
    }

    public boolean paintDialog(Graphics g, Component c) {
        if (this.background != null) {
            ImageUtils.paint(c, g, this.background, 2);
            return true;
        }
        if (!((JComponent)c).isOpaque()) {
            Color holdC = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(0, 0, ((JComponent)c).getWidth(), ((JComponent)c).getHeight());
            g.setColor(holdC);
        }
        return true;
    }

    public boolean paintMenuItem(Graphics g, JMenuItem c) {
        if (this.menuitemSelected != null) {
            if (c.isArmed() || c instanceof JMenu && c.getModel().isSelected()) {
                this.menuitemSelected.paint(g, c);
            }
            return true;
        }
        return false;
    }

    public boolean paintComboBox(Graphics g, JComboBox c, Rectangle bounds, boolean hasFocus) {
        if (this.comboBox != null) {
            this.comboBox.paint(g, c);
            return true;
        }
        return false;
    }

    public Kde2Personality(IniFile ini, URL skinURL) throws Exception {
        try {
            this.background = Kde2Utils.newIcon(ini, skinURL, "Background").getImage();
            if (this.background != null) {
                int width = this.background.getWidth(ImageUtils.producer);
                int height = this.background.getHeight(ImageUtils.producer);
                int factor = Math.max(MINIMAL_SIZE / height, MINIMAL_SIZE / width);
                if (factor > 1) {
                    this.background = ImageUtils.buildTile(this.background, factor);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.comboBox = Kde2Utils.newButton(ini, skinURL, "ComboBox");
        this.menuitemSelected = Kde2Utils.newButton(ini, skinURL, "MenuItemDown");
        this.menuBarBorder = Kde2Utils.newButton(ini, skinURL, "MenuBar");
    }
}

