package com.gotdns.jimula.EatHealthy;

/**
 * <em>CalculateNutrient</em> is an object which calculates personal
 * nutrient. It is evoked by NutrientPanel.
 * <p>EatHealthy </p>
 * <p>A simple personal nutrient need and food serving calculator </p>
 * <p>Copyright (c) 2003</p>
 * @author Jimmy Ding
 * @version 1.01, 05/01/03
 * @see com.gotdns.jimula.EatHealthy.NutrientPanel
 */
public class CalculateNutrient{

  /**
   * Ideal Body Weight
   */
  public float IBW;

  /**
   * Basal Metabolic Rate
   */
  public float BMR;

  /**
   * activity
   */
  public float Activity;

  /**
   * Diet-Induced Thermogenesis
   */
  public float DIT;

  /**
   * calories
   */
  public float Calorie;

  /**
   * protein contents
   */
  public float protein;

  /**
   * carbohydrate contents
   */
  public float carb;

  /**
   * fat contents
   */
  public float fat;

  /**
   * Construsts a new CalculateNutrient object and calculate personal
   * nutrient need.
   *
   * @param height personal height
   * @param sleepingTime personal sleeping hours
   * @param sex personal gendar
   * @param level personal activity level
   * @see com.gotdns.jimula.EatHealthy.IBW
   * @see com.gotdns.jimula.EatHealthy.BMR
   * @see com.gotdns.jimula.EatHealthy.Activity
   * @see com.gotdns.jimula.EatHealthy.DIT
   * @see com.gotdns.jimula.EatHealthy.Calorie
   * @see com.gotdns.jimula.EatHealthy.PFC
   */
  public CalculateNutrient(float height,int sleepingTime,String sex,float level){

    //constructs new objects of IBW, BMR, Activity, DIT, Calorie, and PFC
    IBW thisIBW=new IBW(height);
    BMR thisBMR=new BMR(thisIBW.getIBW(),sleepingTime,sex);
    Activity thisActivity =new Activity(level,thisIBW.getIBW(),sleepingTime);
    DIT thisDIT=new DIT(thisBMR.getBMR(),thisActivity.getActivity());
    Calorie thisCalorie=new Calorie(thisBMR.getBMR(),thisActivity.getActivity(),
                                    thisDIT.getDIT());
    PFC thisPFC=new PFC(thisCalorie.getCalorie());

    //get object field of IBW, BMR, Activity, DIT, calorie and PFC
    IBW=thisIBW.getIBW();
    BMR=thisBMR.getBMR();
    Activity=thisActivity.getActivity();
    DIT=thisDIT.getDIT();
    Calorie=thisCalorie.getCalorie();
    protein=thisPFC.getProtien();
    carb=thisPFC.getCarb();
    fat=thisPFC.getFat();

  }




}