/**********************************************************************/
/*								      */
/*  Programm:    SMCMOT.C					      */
/*  Version :    2.0                                                  */
/*  Funktion:    Ansteuerung der Schrittmotorsteuerkarte SMC800       */
/*               mit Angabe der Ausgabefrequenz in Schritte/sec       */
/*  Datum:       20.08.1996					      */
/*  Letzte nd.: 16.09.1996                                           */
/*								      */
/**********************************************************************/


#include "dos.h"


/*-----Funktionsdeklaration-------------------------------------------*/

void Init_Timer();
unsigned int Get_Timer();
void Wait_Time(long zeit);
void Mout(unsigned char Next_Value);
void Delay(int SAkku);
void Vecout(int xStep,int yStep,int zStep);
void Referenz(int xR_Step,int yR_Step,int zR_Step);
void Tastatur(unsigned char F_Mode);
void Pen_down();
void Pen_up();


/*-----Globale Variable-----------------------------------------------*/

unsigned int _LPT;

long V_Startfreq;
long V_Arbeitsfreq, R_Arbeitsfreq;
long Beschleunigung, Bremsen;

unsigned char MptrX=0, MptrY=0, MptrZ=0;
unsigned char P_Mode=0, Reffahrt=0, Tastfahrt=0;
unsigned char Pen_aktl=0, Pen_akth=0;

long T_Arbeitsfreq=500;
long starttimer, stoptimer;
unsigned char BrAktiv=0;
double Startfreq=1.0, Bremsfreq;
double StartRampe, BremsRampe;
double aenderdiff=0.0;
long MerkAkku;


void Init_Timer()            /* Interrupt-Timer initialisieren */
{
  outp(0x43, 0x34);          /* Timer 0, Modus 2 */
  outp(0x40, 0);
  outp(0x40, 0);

  return;
}


unsigned int Get_Timer()     /* Interrupt-Timer auslesen */
{
  unsigned int cnt_lo, cnt_hi;


  outp(0x43, 0);             /* Timer 0 */

  cnt_lo = inp(0x40);
+  cnt_hi = inp(0x40);

  return (cnt_hi * 256 + cnt_lo);
}


void Wait_Time(long zeit)   /* Zeiteinheit 0.838 s */
{
  long start, stop;
  long diff, merkdiff;
  long merkstop;
  unsigned char durchlauf;


  durchlauf = 0;
  diff      = 0;
  merkdiff  = 0;
  merkstop  = 99999999;

  start = Get_Timer();
  stop  = Get_Timer();

  if (start < stop)
  {
	 diff = start+(65535-stop);
	 merkdiff = diff;
	 diff = 0;
	 start= stop;
  }
  else
  {
	 diff = start-stop;
  }

  while ((diff + merkdiff) < zeit)
  {
	 stop = Get_Timer();

	 if (stop > merkstop)
		durchlauf = 1;

	 if ((start < stop)||(durchlauf==1))
	 {
		diff = start+(65535-stop);
		merkdiff = merkdiff + diff;
		diff = 0;
		durchlauf = 0;
		start= stop;
	 }
	 else
	 {
		diff = start-stop;
	 }

	 merkstop = stop;
  }

  return;
}


//void Mout(unsigned char Out_Val)       /* Portausgabe */
//{}


void Delay(int SAkku)                  /* Verzgerung bei Portausgabe */
{
  extern unsigned char BrAktiv;
  extern unsigned char Reffahrt;
  extern unsigned char Tastfahrt;
  extern double StartRampe, BremsRampe;
  extern double Startfreq, Bremsfreq;
  extern double aenderdiff;
  extern long R_Arbeitsfreq, T_Arbeitsfreq;
  extern long V_Arbeitsfreq, Beschleunigung;
  extern long MerkAkku;

  double Zeitbasis=0.000000838;        /* 0.838 s */

  double wartezeit, aenderzeit;
  double diff, merkdiff;
  double merkstop, help;
  long   merklong;
  double merkreal;
  unsigned char durchlauf;


  if ((Reffahrt == 0)&&(Tastfahrt == 0))
  {
	 if ((BrAktiv==0)&&(SAkku <= BremsRampe))
	 {
		if (MerkAkku < StartRampe + BremsRampe)
		{
		  if (SAkku > 0)
		  {
	  Bremsfreq = ((Startfreq*Startfreq) / (2.0 * SAkku));
			 if (Bremsfreq <= 0.0)
				Bremsfreq = 1.0;
		  }
		}

		aenderdiff = 0.0;
		BrAktiv = 1;
	 }
  }

  if (Reffahrt == 1)
  {
	 help = R_Arbeitsfreq;
  }
  else
  {
	 if (Tastfahrt == 1)
	 {
		help = T_Arbeitsfreq;
	 }
	 else
	 {
		help = Startfreq;
	 }
  }

  if (help <= 0.0)
	 help = 1.0;

  wartezeit = ((1.0 / help) / Zeitbasis);

  durchlauf = 0;
  diff      = 0.0;
  merkdiff  = 0.0;
  merkstop  = 99999999.0;

  stoptimer = Get_Timer();

  if (starttimer < stoptimer)
  {
	 diff = starttimer+(65535-stoptimer);
	 merkdiff = diff;
	 diff = 0.0;
	 starttimer= stoptimer;
  }
  else
  {
	 diff = starttimer-stoptimer;
  }

  while ((diff + merkdiff) < wartezeit)
  {
	 stoptimer = Get_Timer();

	 if (stoptimer > merkstop)
		durchlauf = 1;

	 if ((starttimer < stoptimer)||(durchlauf == 1))
	 {
		diff = starttimer+(65535-stoptimer);
		merkdiff = merkdiff + diff;
		diff = 0.0;
		durchlauf = 0;
		starttimer= stoptimer;
	 }
	 else
	 {
		diff = starttimer-stoptimer;
	 }

	 merkstop = stoptimer;
  }

  starttimer = stoptimer;

  if ((Reffahrt == 0)&&(Tastfahrt == 0))
  {
	 if (BrAktiv == 1)
	 {
		if (Startfreq > 0.0)
		{
		  aenderzeit = ((1.0 / Bremsfreq) / Zeitbasis);
		  if ((diff + merkdiff + aenderdiff) >= aenderzeit)
		  {
			 if (aenderzeit == 0.0)
				aenderzeit = 1.0;
			 merkstop  = ((diff + merkdiff + aenderdiff) / aenderzeit);
			 merklong  = (long) merkstop;
			 merkreal  = (double) merklong;
			 aenderdiff= merkstop-merkreal;
			 aenderdiff= aenderdiff * aenderzeit;
			 merkstop  = merkreal;
			 Startfreq = Startfreq - merkstop;
		  }
		  else
		  {
			 aenderdiff = (aenderdiff + diff + merkdiff);
		  }

		  if (SAkku > 0)
		  {
	  Bremsfreq = ((Startfreq*Startfreq) / (2.0 * SAkku));
	  if (Bremsfreq <= 0.0)
		 Bremsfreq = 1.0;
		  }
		}
		else
		{
		  Startfreq = Startfreq + merkstop;
		}
	 }
	 else
	 {
		if (Startfreq < V_Arbeitsfreq)
		{
		  aenderzeit = ((1.0 / Beschleunigung) / Zeitbasis);
		  if ((diff + merkdiff + aenderdiff) >= aenderzeit)
		  {
			 if (aenderzeit == 0.0)
				aenderzeit = 1.0;
			 merkstop  = ((diff + merkdiff + aenderdiff) / aenderzeit);
			 merklong  = (long) merkstop;
			 merkreal  = (double) merklong;
			 aenderdiff= merkstop-merkreal;
			 aenderdiff= aenderdiff * aenderzeit;
			 merkstop  = merkreal;
			 Startfreq = Startfreq + merkstop;
		  }
		  else
		  {
			 aenderdiff = (aenderdiff + diff + merkdiff);
		  }
		}
	 }
  }

  return;
}


//void Pen_down()
//{}
//void Pen_up()
//{}
//void Vecout(int xStep, int yStep, int zStep)
//{}/
//void Referenz(int xR_Step, int yR_Step, int zR_Step)
//{}
//void Tastatur(unsigned char F_Mode)
//{}
